#! /usr/bin/env ruby

# rmi2smf.rb: Written by Tadayoshi Funaba 2001-2006
# $Id: rmi2smf.rb,v 1.5 2006-11-10 21:57:06+09 tadf Exp $

require 'smf/toy/rmi'
require 'gopt'

def usage
  warn 'usage: rmi2smf [-o output] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.rmi') + '.mid' if ifile
ofile = nil if ofile == '-'

i = (unless ifile then $stdin else open(ifile) end).binmode.read
o = SMF::RMI::rmi2smf(i)
(unless ofile then $stdout else open(ofile, 'w') end).binmode.write(o)
