#! /usr/bin/env ruby

# smf2rmi.rb: Written by Tadayoshi Funaba 2001-2006
# $Id: smf2rmi.rb,v 1.6 2006-11-10 21:57:06+09 tadf Exp $

require 'smf/toy/rmi'
require 'gopt'

def usage
  warn 'usage: smf2rmi [-o output] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.mid') + '.rmi' if ifile
ofile = nil if ofile == '-'

i = (unless ifile then $stdin else open(ifile) end).binmode.read
o = SMF::RMI::smf2rmi(i)
(unless ofile then $stdout else open(ofile, 'w') end).binmode.write(o)
