#! /usr/bin/env ruby

# morse.rb: Written by Tadayoshi Funaba 2005,2006
# $Id

require 'smf/toy/morse'
require 'gopt'
include SMF

def usage
  warn 'usage: morse [-o output] [-e message] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:e:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.txt') + '.mid' if ifile
ofile = nil if ofile == '-'

so = opt[:e] if opt[:e]
so ||= unless ifile then $stdin.read else IO.read(ifile) end
sq = Sequence.new
mo = Morse.new(sq)
mo << so
mo.generate
unless ofile then sq.write($stdout) else sq.save(ofile) end
