#! /usr/bin/env ruby

# shuffle.rb: Written by Tadayoshi Funaba 2005,2006
# $Id: shuffle.rb,v 1.3 2006-11-10 21:57:06+09 tadf Exp $

require 'smf'
require 'smf/toy/shuffle'
require 'gopt'
include  SMF

def usage
  warn 'usage: shuffle [-o output] [-u n/d] [-a amount] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:u:a:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.mid') + '-shuffle.mid' if ifile
ofile = nil if ofile == '-'

n, d = (opt[:u] || '1/8').split('/')
unit = n.to_f / (d || '1').to_f
amount = (opt[:a] || '0.5').to_f

sq = unless ifile then Sequence.read($stdin) else Sequence.load(ifile) end
sh = Shuffle.new(sq.division, unit)
sh.amount = amount

sq.each do |tr|
  tr.pop
  tr.each do |ev|
    case ev
    when NoteOff, NoteOn
      sh.shuffle(ev)
    end
  end
end
unless ofile then sq.write($stdout) else sq.save(ofile) end
