#! /usr/bin/env ruby

# smf2smf.rb: Written by Tadayoshi Funaba 1999-2006
# $Id: smf2smf.rb,v 1.8 2006-11-10 21:57:06+09 tadf Exp $

require 'smf'
require 'gopt'
include  SMF

def usage
  warn 'usage: smf2smf [-o output] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.mid') + '-smf2smf.mid' if ifile
ofile = nil if ofile == '-'

sq = unless ifile then Sequence.read($stdin) else Sequence.load(ifile) end
unless ofile then sq.write($stdout) else sq.save(ofile) end
