#! /usr/bin/env ruby

# smf2text.rb: Written by Tadayoshi Funaba 1999-2006
# $Id: smf2text.rb,v 1.14 2006-11-10 21:57:06+09 tadf Exp $

require 'smf'
require 'smf/toy/text'
require 'gopt'
include  SMF

def usage
  warn 'usage: smf2text [-o output] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.mid') + '.txt' if ifile
ofile = nil if ofile == '-'

sq = unless ifile then Sequence.read($stdin) else Sequence.load(ifile) end
unless ofile then sq.write_text($stdout) else sq.save_text(ofile) end
