#! /usr/bin/env ruby

# smf2xml.rb: Written by Tadayoshi Funaba 2004-2006
# $Id: smf2xml.rb,v 1.3 2006-11-10 21:57:06+09 tadf Exp $

require 'smf'
require 'smf/toy/xml'
require 'gopt'
include  SMF

def usage
  warn 'usage: smf2xml [-o output] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.mid') + '.xml' if ifile
ofile = nil if ofile == '-'

sq = unless ifile then Sequence.read($stdin) else Sequence.load(ifile) end
unless ofile then sq.write_xml($stdout) else sq.save_xml(ofile) end
