#! /usr/bin/env ruby

# text2smf.rb: Written by Tadayoshi Funaba 2001-2006
# $Id: text2smf.rb,v 1.5 2006-11-10 21:57:06+09 tadf Exp $

require 'smf'
require 'smf/toy/text'
require 'gopt'
include  SMF

def usage
  warn 'usage: text2smf [-o output] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.txt') + '.mid' if ifile
ofile = nil if ofile == '-'

sq = unless ifile
     then Sequence.read_text($stdin) else Sequence.load_text(ifile) end
unless ofile then sq.write($stdout) else sq.save(ofile) end
