#! /usr/bin/env ruby

# xml2smf.rb: Written by Tadayoshi Funaba 2004-2006
# $Id: xml2smf.rb,v 1.3 2006-11-10 21:57:06+09 tadf Exp $

require 'smf'
require 'smf/toy/xml'
require 'gopt'
include  SMF

def usage
  warn 'usage: xml2smf [-o output] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:d:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.xml') + '.mid' if ifile
ofile = nil if ofile == '-'

sq = unless ifile
     then Sequence.read_xml($stdin) else Sequence.load_xml(ifile) end
unless ofile then sq.write($stdout) else sq.save(ofile) end
