#######################################################
# tc_biff.rb
#
# Test suite for the BIFFWriter class (biffwriter.rb)
# Requires testunit 0.1.8 or greater to run properly
#######################################################
base_dir = File.dirname(Dir.pwd)
spreadsheet_dir = base_dir + "/spreadsheet"
$:.unshift(base_dir)
$:.unshift(spreadsheet_dir)

require "test/unit"
require "biffwriter"

class TC_BIFFWriter < Test::Unit::TestCase

   def setup
      @b = BIFFWriter.new
   end

   def test_append_no_error
      assert_nothing_raised{@b.append("World")}
   end

   def test_prepend_no_error
      assert_nothing_raised{@b.prepend("Hello")}
   end

   def test_data_added
      @b.append("Hello","World")
      assert_equal("HelloWorld",@b.data,"Bad data contents")
      assert_equal(10,@b.datasize,"Bad data size")
   end

   def test_data_prepended
      @b.append("Hello")
      @b.prepend("World")
      assert_equal("WorldHello",@b.data,"Bad data contents")
   end

   def test_store_bof_length
      @b.store_bof
      assert_equal(12,@b.datasize,"Bad data size after store_bof call")
   end

   def test_store_eof_length
      @b.store_eof
      assert_equal(4,@b.datasize,"Bad data size after store_eof call")
   end

   def test_datasize_mixed
      @b.append("Hello")
      @b.prepend("World")
      @b.store_bof
      @b.store_eof
      assert_equal(26,@b.datasize,"Bad data size for mixed data")
   end

   def teardown
      @b = nil
   end

end
