########################################################################
# test.rb
# 
# Simply run this and then open up test.xls with MS Excel (or Gnumeric
# or whatever) to view the results.
########################################################################
if File.basename(Dir.pwd) == "test"
   Dir.chdir ".."
   $:.unshift Dir.pwd
   $:.unshift Dir.pwd + "/spreadsheet"
end

require "spreadsheet/excel"
include Spreadsheet

wb = Excel.new("test/test.xls")
version = Excel::VERSION

# Preferred way to add a format
f1 = wb.add_format(:color=>"blue",:bold=>1,:italic=>true)

# Another way to add a format
f2 = Format.new(
   :color  => "red",
   :bold   => 1,
   :italic => true
)
wb.add_format(f2)

# Yet another way to add a format
# A tiny bit more overhead doing it this way
f3 = Format.new{ |f|
   f.color  = "green"
   f.bold   = 1
   f.italic = true
}
wb.add_format(f3)

f4 = Format.new(:num_format => "d mmm yyyy")
f5 = Format.new(:num_format => 0x0f)
wb.add_format(f4)
wb.add_format(f5)

ws1 = wb.add_worksheet
ws2 = wb.add_worksheet("number")
ws3 = wb.add_worksheet("text")
ws1.write(0,0,version)
ws1.write(0,1,"Hello",f1)
ws1.write(1,1,["Matz","Larry","Guido"])
ws2.write_column(1,1,[[1,2,3],[4,5,6],[7,8,9]])
ws2.write(0,0,8888,f2)
ws3.write(0,0,36892.521,f5)

ws1.format_row(4..5,30,f1)
ws2.format_column(3..4,25,f2)
ws1.write(5,0,"This should be blue")
ws2.write(0,4,"This should be red")
wb.close
