#####################################################
# t_ole.rb
#
# Test suite for the OLEWriter class (olewriter.rb)
# Requires testunit 0.1.8 or greater to run properly
#####################################################
base_dir = File.dirname(Dir.pwd)
spreadsheet_dir = base_dir + "/spreadsheet"
$:.unshift(base_dir)
$:.unshift(spreadsheet_dir)

require "test/unit"
require "olewriter"

#############################################################################
# In some cases, even though the file sizes are identical, the files
# themselves do not appear to be identical.  The Perl output appears to
# contain a newline which the Ruby output does not.
#############################################################################

class TC_OLE < Test::Unit::TestCase

   def setup
      @f = "test.ole"
      @o = OLEWriter.new(@f)
   end

   def test_set_size_too_big
      err = "Should have raised MaxSizeError"
      assert_raises(MaxSizeError,err){@o.set_size(999999999)}
   end

   def test_booksize_large
      @o.set_size(8192)
      assert_equal(8192,@o.booksize)
   end

   def test_booksize_small
      @o.set_size(2048)
      assert_equal(4096,@o.booksize)
   end

   def test_biffsize
      @o.set_size(2048)
      assert_equal(2048,@o.biffsize)
   end

   def test_size_allowed
      @o.set_size
      assert_equal(true,@o.size_allowed)
   end

   def test_big_block_size_default
      @o.set_size
      @o.calculate_sizes
      assert_equal(8,@o.big_blocks,"Bad big block size")
   end

   def test_big_block_size_rounded_up
      @o.set_size(4099)
      @o.calculate_sizes
      assert_equal(9,@o.big_blocks,"Bad big block size")
   end

   def test_list_block_size
      @o.set_size
      @o.calculate_sizes
      assert_equal(1,@o.list_blocks,"Bad list block size")
   end

   def test_root_start_size_default
      @o.set_size
      @o.calculate_sizes
      assert_equal(8,@o.big_blocks,"Bad root start size")
   end

   def test_root_start_size_rounded_up
      @o.set_size(4099)
      @o.calculate_sizes
      assert_equal(9,@o.big_blocks,"Bad root start size")
   end

   #def test_write_header
   #   @o.write_header
   #   @o.close
   #   size = File.size(@f)
   #   assert_equal(512,size,"Bad file size after write_header")
   #end

   #def test_write_big_block_depot
   #   @o.write_big_block_depot
   #   @o.close
   #   size = File.size(@f)
   #   assert_equal(8,size,"Bad file size after write_big_block_depot")
   #end

   #def test_write_property_storage_size
   #   @o.write_property_storage
   #   @o.close
   #   size = File.size(@f)
   #   assert_equal(512,size,"Bad file size after write_property_storage")
   #end

   def teardown
      begin
         @o.close
      rescue IOError
         # ignore
      end
      File.delete(@f)
   end

end
