#!/usr/bin/env ruby

# :nodoc:

require 'test/unit'
require '../lib/xmlconfigfile'

class TC_FileAccess < Test::Unit::TestCase # :nodoc:
  def test_file_not_exist
    assert_raises(Errno::ENOENT) { XmlConfigFile.new('') }
  end

  def test_document_not_wellformed
    assert_raises(REXML::ParseException) {
      XmlConfigFile.new('original_files/notWellformedConfig.xml')
    }
  end
end

