#!/usr/bin/env ruby

# :nodoc:

require 'ftools'
require 'test/unit'
require '../lib/xmlconfigfile'

class Orwell # :nodoc:
  attr_reader :int_value

  def initialize(config)
    config.add_observer(self)
    @config = config
    @int_value = @config.get_int('/config/int-amount')
  end
  
  def update(*args)
    @int_value = @config.get_int('/config/int-amount')
  end
end

class TC_Observer < Test::Unit::TestCase # :nodoc:
  def test_observation
    File::copy('original_files/config.xml', '.')
    config = XmlConfigFile.new('config.xml', 2)
    orwell = Orwell.new(config)
    assert_equal(42, orwell.int_value)
    File::copy('original_files/changed_config.xml', 'config.xml')
    File::utime(0, 0, 'config.xml')
    sleep 3
    assert_equal(43, orwell.int_value)
    config.close
  end
end

