#!/usr/bin/env ruby

# :nodoc:

require 'test/unit'
require 'ftools'
require '../lib/xmlconfigfile'

class TC_WriteAccess < Test::Unit::TestCase # :nodoc:
  def setup
    ENV['PARAM_1'] = 'param1'
    ENV['PARAM2']  = '4711'
    @config = XmlConfigFile.new('original_files/config.xml')
  end

  def test_set_parameter
    @config.set_parameter('/config/db/name', 'new_shop')
    assert_equal('new_shop', @config.get_string('/config/db/name'))
    @config['/config/db/name'] = 'new_shop2'
    assert_equal('new_shop2', @config.get_string('/config/db/name'))
    @config.set_parameter('/config/environment-variable/@att', 4712)
    assert_equal(4712, @config.get_int('/config/environment-variable/@att'))
    @config.set_parameter('/config/environment-variable/@att', 3.1415)
    assert_equal(3.1415, @config.get_float('/config/environment-variable/@att'))
    @config.set_parameter('/config/environment-variable/@att', 'on')
    assert_equal(true, @config.get_boolean('/config/environment-variable/@att'))
    @config.set_parameter('/config/environment-variable/@att', 'off')
    assert_equal(false, @config.get_boolean('/config/environment-variable/@att'))
  end

  def test_set_parameter_that_does_not_exist
    assert_raises(ArgumentError) { @config.set_parameter('/config/xx/name', 'maik') }
  end

  def test_store_original_name
    File::cp('original_files/config.xml', '.')
    config = XmlConfigFile.new('config.xml')
    config.set_parameter('/config/db/name', 'new_shop')
    config.store
    assert_equal(true, File::cmp('reference/store.xml', 'config.xml'))
    File::delete('config.xml')
  end

  def test_store_new_name
    @config.set_parameter('/config/db/name', 'new_shop')
    @config.set_parameter('/config/splash-screen/@enabled', 'no')
    @config.store('store.xml')
    assert_equal(true, File::cmp('reference/store2.xml', 'store.xml'))
    File::delete('store.xml')
  end
end

