require 'rubygems'

spec = Gem::Specification.new do |s|
  s.name = 'xmlconfigfile'
  s.version = '0.9.6'
  s.platform = Gem::Platform::RUBY
  s.summary = "Simple access to XML configuration files"
  s.description = <<-EOF
  XmlConfigFile offers an way for accessing the content of
  XML configuration files using XPath. Additionally, it
  provides some convenience methods for periodically
  reloading the configuration file and so on.
  EOF
  s.require_path = 'lib'
  s.autorequire = 'xmlconfigfile'
  s.author = "Maik Schmidt"
  s.email = "contact@maik-schmidt.de"
  s.homepage = "http://www.maik-schmidt.de/xml-configfile.html"
  s.files = Dir.glob("lib/xmlconfigfile.rb")
  s.files += Dir.glob("docs/**/*").delete_if { |d| d =~ /\.svn/ }
  s.files += Dir.glob("test/**/*").delete_if { |d| d =~ /\.svn/ }
  s.files += ['README', 'CHANGES', 'LICENSE', 'TODO']
  s.has_rdoc = true
end

if $0 == __FILE__
  Gem::Builder.new(spec).build
end
