# -*- ruby -*-
#
# Using an internal stack.
#

require 'xtemplate'
require 'xtemplate/xml'

$mem1 = '<?xml version="1.0"?><member><uid>1</uid><name>name1</name></member>'
$mem2 = '<?xml version="1.0"?><member><uid>2</uid><name>name2</name></member>'
$mem3 = '<?xml version="1.0"?><member><uid>3</uid><name>name3</name></member>'

doc = XTemplate::XMLDocument.new(<<EOF)
<?xml version="1.0"?>
<members xmlns:xt="#{XTemplate::BIND_URI}">
  <xt:include src="$mem1" />
  <xt:include src="$mem2" />
  <xt:include src="$mem3" />
</members>
EOF

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<members xmlns:xt="#{XTemplate::BIND_URI}">
   <xt:select id="/members/member">
     <xt:element name="@{name}"><xt:attribute name="uid" id="uid"></xt:attribute><xt:value-of id="name" /></xt:element>
   </xt:select>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(doc))
