#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2"
fi

TEST_MYSQL=
# TEST_MYSQL=" --with-database=mysql --with-libs=-L/usr/local/mysql/lib "
export TEST_MYSQL

echo; echo "${S}__ STARTING TEST RUN CLIENT/SERVER W/GPG __${E}"; echo;
echo Working directory: $PW_DIR

MAKE=`which gmake`
if test "x$?" = x1 ; then
    MAKE="make -s"
else
    MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
    if test x$MAKE = x; then
	MAKE="make -s"
    elif test x$MAKE = xno; then
	MAKE="make -s"
    else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
	fi
    fi
fi

echo MAKE is $MAKE
echo

# $GPG_PATH _must_ be an absolute path
#
if test x${GPG_PATH} = x; then
    GPG_PATH=`which gpg | sed -e "s%\([a-z:]\) .*%\1%g"`
fi

if test x${GPG_PATH} = x; then
    echo "ERROR: gpg (GnuPG) not found"
    exit
else
    GPG_OK=`echo ${GPG_PATH} | sed -e "s%\(/.*\)%OK%g"`
    if test x${GPG_OK} = xOK; then
        echo "GPG_PATH is ${GPG_PATH}"
    else
        echo "ERROR: GPG_PATH (${GPG_PATH}) is _not_ an absolute path."
        echo
        echo "  Apparently the command 'which gpg' did not yield an absolute path."
        echo "  You can fix the problem by setting the environment variable GPG_PATH"
        echo "  to the absolute path to gpg (GnuPG) and start the test again."
        exit
    fi
fi

echo

testrun2b ()
{
	#
	# test standalone compilation
	#
	echo "${S}Building client and server${E}"; echo;
	#
	if test -r "Makefile"; then
		$MAKE distclean
	fi
        #
        GPG_HASH=`gpg --load-extension tiger --print-md TIGER192 ${GPG_PATH}`
        #
        echo GPG_HASH is ${GPG_HASH}
        #
	./configure --quiet  $TRUST --with-gpg=${GPG_PATH} --enable-static --enable-xml-log --enable-network=client --enable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=REQ_FROM_SERVER$PW_DIR/testrc_2.signed --with-data-file=REQ_FROM_SERVER$PW_DIR/.samhain_file --with-logserver=localhost  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-checksum="${GPG_HASH}" --with-fp="EF6C EF54 701A 0AFD B86A  F4C3 1AAD 26C8 0F57 1F6C"
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		if test x$? = x0; then
		    echo "$MAKE completed, exit status $?"; echo;
		else
		    echo "${S}ERROR:${E} make failed, exit status $?"; echo;
		    exit
		fi

	else
		echo "${S}ERROR:${E} configure failed, exit status $?"; echo;
		exit
	fi

	# save binary and build server
	#
	cp samhain samhain.build
	make clean

        #
	./configure --quiet  $TRUST --with-gpg=${GPG_PATH} --enable-static --enable-xml-log ${TEST_MYSQL} --enable-debug --enable-network=server --enable-srp --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=REQ_FROM_SERVER$PW_DIR/testrc_2.signed --with-data-file=REQ_FROM_SERVER$PW_DIR/.samhain_file --with-logserver=${SH_LOCALHOST}  --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-checksum="${GPG_HASH}" --enable-identity=rainer
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		if test x$? = x0; then
		    echo "$MAKE completed, exit status $?"; echo;
		else
		    echo "${S}ERROR:${E} make failed, exit status $?"; echo;
		    exit
		fi

	else
		echo "${S}ERROR:${E} configure failed, exit status $?"; echo;
		exit
	fi
	echo "${S}Initialize database${E}"; echo;

	rm -f ./.samhain_file
	rm -f ./.samhain_log
	rm -f ./.samhain_lock
	rm -f ./rc.${SH_LOCALHOST}
	rm -f ./file.${SH_LOCALHOST}

	cp testrc_2.in testrc_2.signed

	# Create a password
	SHPW=`./yule -G`
	if test x"$SHPW" = x; then
	    echo "password not generated -- aborting"
	    exit 1
	fi

	# Set in client
	echo "./samhain_setpwd samhain.build new $SHPW"
	./samhain_setpwd samhain.build new $SHPW
	mv samhain.build.new samhain.new
	SHCLT=`./yule -P $SHPW | sed s%HOSTNAME%${SH_LOCALHOST}%`
 	echo $SHCLT >> testrc_2.signed

        echo "--- You need to sign the config file testrc_2.signed now ---"
        echo
        gpg -a --clearsign $PW_DIR/testrc_2.signed
        mv $PW_DIR/testrc_2.signed.asc $PW_DIR/testrc_2.signed

	echo "./samhain.new -t init"
	./samhain.new -t init

	SHINI=$?

	rm -f ./.samhain_log
	rm -f ./.samhain_lock

	cp    ./testrc_2.signed       ./rc.${SH_LOCALHOST}
	mv    ./.samhain_file         ./file.${SH_LOCALHOST}

	if test x$SHINI = x0; then
                echo
                echo "--- You need to sign the database file.${SH_LOCALHOST} now ---"
                echo
                gpg -a --clearsign $PW_DIR/file.${SH_LOCALHOST}
                mv $PW_DIR/file.${SH_LOCALHOST}.asc $PW_DIR/file.${SH_LOCALHOST}

		echo; echo "${S}Start Server${E}: ./yule  &"; echo;
		./yule &
		PROC_Y=$!
		sleep 5

		echo; echo "${S}Start Client${E}: ./samhain.new -l none -p none -e info -t check";

		./samhain.new -t check -p none -l none -e info 
		if test x$? = x0; then
		    echo "${S}check completed${E}"
		else
		    echo "${S}ERROR:${E} -- check -- failed, exit status $?"
		    echo
		    kill $PROC_Y
		    exit
		fi

		kill $PROC_Y
		sleep 5
	else
		echo "${S}ERROR:${E} -- init -- failed, exit status $SHINI"; 
		echo;
		exit
	fi
	    
}

    if test x$1 = x; then
	echo
	echo "Please provide the local hostname as argument."
	echo
	exit 8
    fi

    SH_LOCALHOST=$1; export SH_LOCALHOST

    testrun2b


echo; echo "${S}__ END TEST RUN CLIENT/SERVER W/GPG __${E}"; echo;

exit

