/* environ.c

--GNU LGPL
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "../command.h"

extern char **_environ;

/**ENVIRON
=section misc
=title ENVIRON("envsymbol") or ENVIRON(n)
=display ENVIRON()

Return the string value of the environmental variable for which the name is
given as string argument. If the argument is a number T<n> then the value of the
n-th environmental variable is returned.
*/
COMMAND(ENVIRON)
#if NOTIMP_ENVIRON
NOTIMPLEMENTED;
#else

  NODE nItem;
  VARIABLE Op1;
#define MAX_ENVIRV_LEN 256
  char *s,buffer[MAX_ENVIRV_LEN];
  size_t sLen;
  char **EnvironmentPointer;
  long index;
  char *(*EnvirFunc)(void *, char *, long );
  /* this is an operator and not a command, therefore we do not have our own mortal list */
  USE_CALLER_MORTALS;

  /* evaluate the parameter */
  nItem = PARAMETERLIST;
  Op1 = _EVALUATEEXPRESSION(CAR(nItem));
  ASSERTOKE;

  if( Op1 == NULL ){
    RESULT = NULL;
    RETURN;
    }

  EnvirFunc = pEo->fpEnvirFunction;
  if( TYPE(Op1) == VTYPE_LONG ){
    index = LONGVALUE(Op1);
    if( EnvirFunc ){
      s = EnvirFunc(pEo->pEmbedder,NULL,index);
      }else{
      EnvironmentPointer = _environ;
      if( index < 0 ){
        RESULT = NULL;
        RETURN;
        }
      /* we have to walk on eby one, because index may be too large and _environ is terminated with NULL and
         we do not have the length */
      while( index && *EnvironmentPointer ){
        index--;
        EnvironmentPointer++;
        }
      s = *EnvironmentPointer;
      }
    }else{

    Op1 = CONVERT2STRING(Op1);
    if( (sLen=STRLEN(Op1)) > MAX_ENVIRV_LEN -1 )sLen = MAX_ENVIRV_LEN-1;
    memcpy(buffer,STRINGVALUE(Op1),sLen);
    buffer[sLen] = (char)0;
    if( EnvirFunc )
      s = EnvirFunc(pEo->pEmbedder,buffer,0);
    else
      s = getenv( buffer );
    }

  if( s == NULL ){
    RESULT = NULL;
    RETURN;
    }
  sLen=strlen(s);
  RESULT = NEWMORTALSTRING(sLen);
  memcpy(STRINGVALUE(RESULT),s,sLen);

#endif
END

/**COMMANDF
=section misc
=title COMMAND()
=display COMMAND()

Return the command line string.
*/
COMMAND(COMMANDF)
#if NOTIMP_COMMANDF
NOTIMPLEMENTED;
#else

  int q;

  /* this is an operator and not a command, therefore we do not have our own mortal list */
  USE_CALLER_MORTALS;

  if( pEo->CmdLineArgument == NULL ){
    RESULT = NULL;
    RETURN;
    }

  RESULT = NEWMORTALSTRING(q=strlen(pEo->CmdLineArgument));
  if( RESULT == NULL )ERROR(COMMAND_ERROR_MEMORY_LOW);
  memcpy(STRINGVALUE(RESULT),pEo->CmdLineArgument,q);

#endif
END