/*goto.c

--GNU LGPL
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdlib.h>
#include <stdio.h>

#include "../command.h"

/**GOTO
=section misc
=title GOTO label
Go to a label and continue program execution at that label. Labels are local within functions and
subroutines. You can not jump into a sub or jump out of it.

*/
COMMAND(GOTO)
#if NOTIMP_GOTO
NOTIMPLEMENTED;
#else


  SETPROGRAMCOUNTER(PARAMETERNODE);

#endif
END

/**RESUME
=section error
=title RESUME [ label | next ]

Resume the program execution after handling the error. T<RESUME> without argument tries to execute
the same line again that caused the error. T<RESUME NEXT> tries to continue execution after the
line that caused the error. T<RESUME label> tries to continue execution at the specified label.

See also R<ONERRORGOTO>, R<ONERRORRESUME> and R<ERROR>.
*/
COMMAND(RESUMELABEL)
#if NOTIMP_RESUMELABEL
NOTIMPLEMENTED;
#else


  SETPROGRAMCOUNTER(PARAMETERNODE);
  pEo->LastError = 0;
  pEo->ErrorGoto = 0;
  pEo->fErrorGoto = 0;

#endif
END
/**ONERRORRESUME
=section error
=title ON ERROR RESUME [ label | next ]
=display ON ERROR RESUME

Setting T<ON ERROR RESUME> will try to continue execution on the label or on the next statement
when ean error occures without any error handling code.

See also R<ONERRORGOTO>, R<RESUME> and R<ERROR>.

*/
COMMAND(ONERRORRESUMELABEL)
#if NOTIMP_ONERRORRESUMELABEL
NOTIMPLEMENTED;
#else


  pEo->ErrorGoto = PARAMETERNODE;
  pEo->fErrorGoto = ONERROR_RESUME;

#endif
END

/**ONERRORGOTO
=section error
=title ON ERROR GOTO [ label | 0 ]
=display ON ERROR GOTO

Set the entry point of the error handling routine. If the argument is T<0> then the error handling
is switched off.
*/
COMMAND(ONERRORGOTONULL)
#if NOTIMP_ONERRORGOTONULL
NOTIMPLEMENTED;
#else


  pEo->ErrorGoto = 0;
  pEo->fErrorGoto = 0;

#endif
END

COMMAND(ONERRORGOTO)
#if NOTIMP_ONERRORGOTO
NOTIMPLEMENTED;
#else


  pEo->ErrorGoto = PARAMETERNODE;
  pEo->fErrorGoto = ONERROR_GOTO;

#endif
END

COMMAND(RESUME)
#if NOTIMP_RESUME
NOTIMPLEMENTED;
#else


  pEo->LastError = 0;
  if( !pEo->ErrorResume )ERROR(COMMAND_ERROR_NO_RESUME);
  SETPROGRAMCOUNTER(pEo->ErrorResume);

#endif
END

COMMAND(ONERRORRESUMENEXT)
#if NOTIMP_ONERRORRESUMENEXT
NOTIMPLEMENTED;
#else


  pEo->fErrorGoto = ONERROR_RESUMENEXT;

#endif
END

COMMAND(RESUMENEXT)
#if NOTIMP_RESUMENEXT
NOTIMPLEMENTED;
#else


  pEo->LastError = 0;
  if( ! pEo->ErrorResume )ERROR(COMMAND_ERROR_NO_RESUME);
  SETPROGRAMCOUNTER( CDR(pEo->ErrorResume) );

#endif
END

/**STOP
=section misc error

Stop program execution.
*/
COMMAND(STOP)
#if NOTIMP_STOP
NOTIMPLEMENTED;
#else


    pEo->fStop = fStopSTOP;

#endif
END

/**END
=section misc

End of the program. Stops program execution.
*/
COMMAND(END)
#if NOTIMP_END
NOTIMPLEMENTED;
#else


    pEo->fStop = fStopSTOP;

#endif
END

/**ERROR
=section error
=title ERROR() or ERROR n

Get the code of the last error that happened when used as a function or cause the error with code T<n>
when used as a command.
*/
COMMAND(ERROR)
#if NOTIMP_ERROR
NOTIMPLEMENTED;
#else


  RESULT = NEWMORTALLONG;
  if( RESULT ){
    LONGVALUE(RESULT) = pEo->LastError;
    }

#endif
END

COMMAND(CERROR)
#if NOTIMP_CERROR
NOTIMPLEMENTED;
#else


  ERROR(pEo->LastError=LONGVALUE(CONVERT2LONG(EVALUATEEXPRESSION(PARAMETERNODE))));
  // this is a bit weird, but it can happen that the user wants to create an error and
  // an error happens while the expression following the keyword ERROR is evaluated
  ASSERTOKE;

#endif
END