/*if.c

--GNU LGPL
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdlib.h>
#include <stdio.h>

#include "../command.h"

/*POD
=H 'if' conditional statement
CUT*/

/*POD
=section SLIF
=H Signle line 'IF' conditional statement

This command is a single line version of the IF statement
This has the form:

=verbatim
 IF expression THEN command
=noverbatim

CUT*/


/**IF
=section misc
=title IF condition THEN
Conditional execution. There are two different ways to use this commandsingle
line T<IF> and multi line T<IF>.

A single line T<IF> has the form

=verbatim
IF condition THEN command
=noverbatim

There is no way to specify any T<ELSE> command. If you need T<ELSE> command you have 
use multi line T<IF>.

The multi line T<IF> should not contain any command directly after the keyword T<THEN>. It
should have the format:

=verbatim

IF condition THEN
 commands
[ ELSE IF | ELSEIF | ELSIF | ELIF 
  commands
  ... ]
[ ELSE
  commands ]
END IF | ENDIF
=noverbatim

You can use as many T<ELSE IF> branchges as you like and at most one T<ELSE> branch. The
different verbiages are allowed for ease program porting from other BASIC dialect. There is no
difference between the interpretetion.

*/
COMMAND(SLIF)
#if NOTIMP_WHEN
NOTIMPLEMENTED;
#else
  NODE nGoForward;
  VARIABLE ItemResult;

  ItemResult = EVALUATEEXPRESSION(PARAMETERNODE);
  ASSERTOKE;

  nGoForward = pEo->CommandArray[pEo->ProgramCounter-1].Parameter.NodeList.rest;
  if( nGoForward ){
    nGoForward = pEo->CommandArray[nGoForward-1].Parameter.NodeList.rest;
    }

  if( ItemResult == NULL ){
    SETPROGRAMCOUNTER(nGoForward);
    RETURN;
    }

   switch( TYPE(ItemResult) ){
      case VTYPE_LONG:
        if( ! LONGVALUE(ItemResult) ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_DOUBLE:
        if( ! DOUBLEVALUE(ItemResult) ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_STRING:
        if( * STRINGVALUE(ItemResult) == (char)0 ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_ARRAY:
        break;
      }
#endif
END


/*POD
=section IF
=H 'if' conditional statement
CUT*/
COMMAND(IF)
#if NOTIMP_IF
NOTIMPLEMENTED;
#else


  NODE nItem;
  NODE nGoForward;
  NODE nCode;
  VARIABLE ItemResult;

  nItem = PARAMETERNODE;
  ItemResult = EVALUATEEXPRESSION(nItem);
  ASSERTOKE;
  NEXTPARAMETER;
  /* if the condition is FALSE then we step forward to the ENDIF/ELSIF or ELSE statement */
  nGoForward = PARAMETERNODE;
  nCode = CAR(nGoForward); /* the code node of the instruction */

  switch( OPCODE(nCode) ){
    case CMD_ELSE:
    case CMD_ENDIF:
      /* go AFTER the ELSE or ENDIF statement */
      nGoForward = CDR(nGoForward);
      break;
    case CMD_ELSIF:
      break;
    }

  if( ItemResult == NULL ){
    SETPROGRAMCOUNTER(nGoForward);
    RETURN;
    }

   switch( TYPE(ItemResult) ){
      case VTYPE_LONG:
        if( ! LONGVALUE(ItemResult) ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_DOUBLE:
        if( ! DOUBLEVALUE(ItemResult) ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_STRING:
        if( * STRINGVALUE(ItemResult) == (char)0 ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_ARRAY:
        break;
      }
  pEo->InstructionParameter[nCode-1] = (void *)1; /* non NULL a bit nasty */
#endif
END

COMMAND(ELSE)
#if NOTIMP_ELSE
NOTIMPLEMENTED;
#else


  SETPROGRAMCOUNTER(PARAMETERNODE);

#endif
END

COMMAND(ENDIF)
#if NOTIMP_ENDIF
NOTIMPLEMENTED;
#else

  /* this command does not do anything */
#endif
END

COMMAND(ELSIF)
#if NOTIMP_ELSIF
NOTIMPLEMENTED;
#else

  NODE nItem;
  NODE nGoForward;
  NODE nCode;
  VARIABLE ItemResult;
  void **q;

  q = &PARAMETEREXEC;
  nItem = PARAMETERNODE;
  ItemResult = EVALUATEEXPRESSION(nItem);
  ASSERTOKE;
  NEXTPARAMETER;
  /* if the condition is FALSE then we step forward to the ENDIF/ELSIF or ELSE statement */
  nGoForward = PARAMETERNODE;
  nCode = CAR(nGoForward); /* the code node of the instruction */

  /* If we got here because an earlier IF or ELSEIF command was true then we find the
     final ENDIF and go there
  */
  if( *q ){
    *q = NULL;
    while( OPCODE(nCode) == CMD_ELSE || OPCODE(nCode) == CMD_ELSIF ){
      if( OPCODE(nCode) == CMD_ELSE )
        nGoForward = pEo->CommandArray[nCode-1].Parameter.CommandArgument.Argument.pNode;
      else{
        nGoForward = pEo->CommandArray[nCode-1].Parameter.CommandArgument.next;
        nGoForward = pEo->CommandArray[nGoForward-1].Parameter.CommandArgument.Argument.pNode;
        }
      nCode = CAR(nGoForward);
      }
    nGoForward = CDR(nGoForward);
    SETPROGRAMCOUNTER(nGoForward);
    RETURN;
    }

  switch( OPCODE(nCode) ){
    case CMD_ELSE:
    case CMD_ENDIF:
      /* go AFTER the ELSE or ENDIF statement */
      nGoForward = CDR(nGoForward);
      break;
    case CMD_ELSIF:
      /* do nothing we will step ON the ELSIF command */
      break;
    }

  if( ItemResult == NULL ){
    SETPROGRAMCOUNTER(nGoForward);
    RETURN;
    }

   switch( TYPE(ItemResult) ){
      case VTYPE_LONG:
        if( ! LONGVALUE(ItemResult) ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_DOUBLE:
        if( ! DOUBLEVALUE(ItemResult) ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_STRING:
        if( * STRINGVALUE(ItemResult) == (char)0 ){
          SETPROGRAMCOUNTER(nGoForward);
          RETURN;
          }
        break;
      case VTYPE_ARRAY:
        break;
      }
  pEo->InstructionParameter[nCode-1] = (void *)1; /* non NULL a bit nasty */
#endif
END