#include <stdio.h>
#include <string.h>

#ifdef WIN32
#include <httpext.h>
#endif

#include "../../basext.h"
#include "cgi.h"

typedef struct _ModuleObject {
  CgiObject Cgi;
  SymbolTable symboltable;
  }ModuleObject,*pModuleObject;

besVERSION_NEGOTIATE

  /* This module currently suports only the standard
     and the ISAPI variation. */
  if( ! memcmp(pszVariation,"STANDARD",8) )return (int)INTERFACE_VERSION;
  if( ! memcmp(pszVariation,"WINISAPI",8) )return (int)INTERFACE_VERSION;
  return 0;

besEND

besSUB_START
  pModuleObject p;
  long lOptionValue,lErrorCode;
  char *s;

  besMODULEPOINTER = besALLOC(sizeof(ModuleObject));
  if( besMODULEPOINTER == NULL )return 0;
  p = (pModuleObject)besMODULEPOINTER;
  if( *(pSt->pEo->Ver.Variation) == 'W' )/*WINISAPI*/
    cgi_InitIsapi(&(p->Cgi),pSt->pEo->pEmbedder);
  else
    cgi_InitCgi(&(p->Cgi));

  if( lOptionValue = besOPTION("cgi$bufferincrease") )
    p->Cgi.lBufferIncrease = lOptionValue;
  if( lOptionValue = besOPTION("cgi$buffermax") )
    p->Cgi.lBufferMax = lOptionValue;
  if( lOptionValue = besOPTION("cgi$contentmax") )
    p->Cgi.lContentMax = lOptionValue;
  if( lOptionValue = besOPTION("cgi$filemax") )
    p->Cgi.lFileMax = lOptionValue;
  if( lOptionValue = besOPTION("cgi$method") )
    p->Cgi.fMethods = lOptionValue;

#ifdef WIN32
  if( s = besCONFIG("isapi.buffer") )
    p->Cgi.dwIsapiBufferSize = atol(s);
#endif

  p->Cgi.pszDebugFile = besCONFIG("cgi.debugfile");

  lErrorCode = cgi_ReadHttpRequest(&(p->Cgi));
  /* cgi.c is an autonomous program file and is loosely copled with the Scriba source and therefor it
     uses its own error codes. This error code is converted to the built-in error code of scriba. The other
     codes are module specific. */
  if( lErrorCode == CGI_ERROR_MEMORY_LOW )lErrorCode = COMMAND_ERROR_MEMORY_LOW;

  p->symboltable = besNEWSYMBOLTABLE();
  if( p->symboltable == NULL )return COMMAND_ERROR_MEMORY_LOW;

  return lErrorCode;
besEND

besSUB_FINISH
  pModuleObject p;
  pSymbolList pH;

  p = (pModuleObject)besMODULEPOINTER;
  if( p == NULL )return 0;
  pH = p->Cgi.pPostParameters;
  while( pH ){
    if( pH->fp ){
      fclose(pH->fp);
      pH->fp = NULL;
      }
    pH = pH->next;
    }
  if( p->symboltable != NULL ){
    /* note that this does not free the strings (values) but the whole memory segment is unloaded anyway */
    besFREESYMBOLTABLE( p->symboltable );
    }
  return 0;
besEND

besFUNCTION(getget)
// char *cgi_GetParam(pModuleObject pCO, char *pszParam);
  pModuleObject p;
  VARIABLE Argument;
  char *pszArgument,*pszResult;
  long slen;
  p = (pModuleObject)besMODULEPOINTER;

  Argument = besARGUMENT(1);
  besDEREFERENCE(Argument);
  if( Argument == NULL ){
    besRETURNVALUE = NULL;
    return COMMAND_ERROR_SUCCESS;
    }
  Argument = besCONVERT2STRING(Argument);
  besCONVERT2ZCHAR(Argument,pszArgument);
  pszResult = cgi_GetParam(&(p->Cgi),pszArgument);
  besFREE(pszArgument);
  if( pszResult ){
    slen=strlen(pszResult);
    besALLOC_RETURN_STRING(slen);
    memcpy(STRINGVALUE(besRETURNVALUE ),pszResult,slen);
    return COMMAND_ERROR_SUCCESS;
    }else{
    besRETURNVALUE  = NULL;
    return COMMAND_ERROR_SUCCESS;
    }

besEND

besFUNCTION(getpost)
// char *cgi_PostParam(pModuleObject pCO, char *pszParam);
  pModuleObject p;
  VARIABLE Argument;
  char *pszArgument,*pszResult;
  long slen;
  p = (pModuleObject)besMODULEPOINTER;

  Argument = besARGUMENT(1);
  besDEREFERENCE(Argument);
  if( Argument == NULL ){
    besRETURNVALUE = NULL;
    return COMMAND_ERROR_SUCCESS;
    }
  Argument = besCONVERT2STRING(Argument);
  besCONVERT2ZCHAR(Argument,pszArgument);
  pszResult = cgi_PostParam(&(p->Cgi),pszArgument);
  besFREE(pszArgument);
  if( pszResult ){
    slen=strlen(pszResult);
    besALLOC_RETURN_STRING(slen);
    memcpy(STRINGVALUE(besRETURNVALUE ),pszResult,slen);
    return COMMAND_ERROR_SUCCESS;
    }else{
    besRETURNVALUE  = NULL;
    return COMMAND_ERROR_SUCCESS;
    }

besEND

besFUNCTION(getgetex)
// char *cgi_GetParamEx(pModuleObject pCO, char *pszParam, pSymbolList *p);
  pModuleObject p;
  VARIABLE Argument,*pSymVAR,SymVAR;
  pSymbolList pSYM;
  char *pszArgument,*pszResult;
  long slen;
  unsigned long __refcount_;

  p = (pModuleObject)besMODULEPOINTER;

  Argument = besARGUMENT(1);
  SymVAR = besARGUMENT(2);
  besDEREFERENCE(Argument);
  besLEFTVALUE(SymVAR,pSymVAR);
  if( pSymVAR ){
    SymVAR = *pSymVAR;
    if( SymVAR && TYPE(SymVAR) == VTYPE_STRING ){
      memcpy(&pSYM,STRINGVALUE(SymVAR),sizeof(pSYM));
      }else{
      pSYM = NULL;
      }
    }else{
    pSYM = NULL;
    }

  if( Argument == NULL ){
    besRETURNVALUE = NULL;
    return COMMAND_ERROR_SUCCESS;
    }
  Argument = besCONVERT2STRING(Argument);
  besCONVERT2ZCHAR(Argument,pszArgument);
  pszResult = cgi_GetParamEx(&(p->Cgi),pszArgument,&pSYM);
  besFREE(pszArgument);

  if( pSymVAR ){
    besRELEASE( *pSymVAR );
    *pSymVAR = besNEWSTRING(sizeof(pSYM));
    if( *pSymVAR == NULL )return COMMAND_ERROR_MEMORY_LOW;
    memcpy(STRINGVALUE( *pSymVAR ),&pSYM,sizeof(pSYM));
    }

  if( pszResult ){
    slen=strlen(pszResult);
    besALLOC_RETURN_STRING(slen);
    memcpy(STRINGVALUE(besRETURNVALUE ),pszResult,slen);
    return COMMAND_ERROR_SUCCESS;
    }else{
    besRETURNVALUE  = NULL;
    return COMMAND_ERROR_SUCCESS;
    }

besEND

besFUNCTION(getpostex)
// char *cgi_PostParamEx(pModuleObject pCO, char *pszParam, pSymbolList *p);
  pModuleObject p;
  VARIABLE Argument,*pSymVAR,SymVAR;
  pSymbolList pSYM;
  char *pszArgument,*pszResult;
  long slen;
  unsigned long __refcount_;

  p = (pModuleObject)besMODULEPOINTER;

  Argument = besARGUMENT(1);
  SymVAR = besARGUMENT(2);
  besDEREFERENCE(Argument);
  besLEFTVALUE(SymVAR,pSymVAR);
  if( pSymVAR ){
    SymVAR = *pSymVAR;
    if( SymVAR && TYPE(SymVAR) == VTYPE_STRING ){
      memcpy(&pSYM,STRINGVALUE(SymVAR),sizeof(pSYM));
      }else{
      pSYM = NULL;
      }
    }else{
    pSYM = NULL;
    }

  if( Argument == NULL ){
    besRETURNVALUE = NULL;
    return COMMAND_ERROR_SUCCESS;
    }
  Argument = besCONVERT2STRING(Argument);
  besCONVERT2ZCHAR(Argument,pszArgument);
  pszResult = cgi_PostParamEx(&(p->Cgi),pszArgument,&pSYM);
  besFREE(pszArgument);

  if( pSymVAR ){
    besRELEASE( *pSymVAR );
    *pSymVAR = besNEWSTRING(sizeof(pSYM));
    if( *pSymVAR == NULL )return COMMAND_ERROR_MEMORY_LOW;
    memcpy(STRINGVALUE( *pSymVAR ),&pSYM,sizeof(pSYM));
    }

  if( pszResult ){
    slen=strlen(pszResult);
    besALLOC_RETURN_STRING(slen);
    memcpy(STRINGVALUE(besRETURNVALUE ),pszResult,slen);
    return COMMAND_ERROR_SUCCESS;
    }else{
    besRETURNVALUE  = NULL;
    return COMMAND_ERROR_SUCCESS;
    }

besEND

besFUNCTION(savefile)
// FILE *cgi_FILEp(pModuleObject pCO, char *pszParam);
  pModuleObject p;
  VARIABLE Argument,FileName;
  char *pszArgument,*pszFileName;
  FILE *fp,*fi;
  int ch;

  p = (pModuleObject)besMODULEPOINTER;

  Argument = besARGUMENT(1);
  FileName = besARGUMENT(2);
  besDEREFERENCE(Argument);
  besDEREFERENCE(FileName);
  Argument = besCONVERT2STRING(Argument);
  FileName = besCONVERT2STRING(FileName);
  besCONVERT2ZCHAR(Argument,pszArgument);
  fi = cgi_FILEp(&(p->Cgi),pszArgument);
  besFREE(pszArgument);
  if( fi == NULL ){
    return 0x00080000;
    }
  besCONVERT2ZCHAR(FileName,pszFileName);

  fp = besHOOK_FOPEN(pszFileName,"wb");
  besFREE(pszFileName);
  if( fp == NULL ){
    return COMMAND_ERROR_FILE_CANNOT_BE_OPENED;
    }

  while( (ch=fgetc(fi)) != EOF )besFPUTC(ch,fp);
  besFCLOSE(fp);

besEND

besFUNCTION(filename)
// char *cgi_OriginalFileName(pModuleObject pCO, char *pszParam);
  pModuleObject p;
  VARIABLE Argument;
  char *pszArgument,*pszResult;
  long slen;
  p = (pModuleObject)besMODULEPOINTER;

  Argument = besARGUMENT(1);
  besDEREFERENCE(Argument);
  if( Argument == NULL ){
    besRETURNVALUE = NULL;
    return COMMAND_ERROR_SUCCESS;
    }
  Argument = besCONVERT2STRING(Argument);
  besCONVERT2ZCHAR(Argument,pszArgument);
  pszResult = cgi_OriginalFileName(&(p->Cgi),pszArgument);
  besFREE(pszArgument);
  if( pszResult ){
    slen=strlen(pszResult);
    besALLOC_RETURN_STRING(slen);
    memcpy(STRINGVALUE(besRETURNVALUE ),pszResult,slen);
    return COMMAND_ERROR_SUCCESS;
    }else{
    besRETURNVALUE  = NULL;
    return COMMAND_ERROR_SUCCESS;
    }
besEND

besFUNCTION(filelen)
// char *cgi_OriginalFileName(pModuleObject pCO, char *pszParam);
  pModuleObject p;
  VARIABLE Argument;
  char *pszArgument;
  long lResult;
  p = (pModuleObject)besMODULEPOINTER;

  Argument = besARGUMENT(1);
  besDEREFERENCE(Argument);
  if( Argument == NULL ){
    besRETURNVALUE = NULL;
    return COMMAND_ERROR_SUCCESS;
    }
  Argument = besCONVERT2STRING(Argument);
  besCONVERT2ZCHAR(Argument,pszArgument);
  lResult = cgi_FileLength(&(p->Cgi),pszArgument);
  besFREE(pszArgument);
  besRETURNVALUE = besNEWMORTALLONG;
  if( besRETURNVALUE == NULL )return COMMAND_ERROR_MEMORY_LOW;
  LONGVALUE(besRETURNVALUE) = lResult;
  return COMMAND_ERROR_SUCCESS;
besEND

#define ENVIRFUNC(XXX) \
besFUNCTION(XXX)\
  char *pszResult;\
  long slen;\
  pModuleObject p;\
  p = (pModuleObject)besMODULEPOINTER;\
  pszResult = cgi_##XXX( &(p->Cgi) );\
  if( pszResult ){\
    slen = strlen(pszResult);\
    besALLOC_RETURN_STRING(slen);\
    memcpy(STRINGVALUE(besRETURNVALUE),pszResult,slen);\
    return COMMAND_ERROR_SUCCESS;\
    }else{\
    besRETURNVALUE = NULL;\
    return COMMAND_ERROR_SUCCESS;\
    }\
besEND

besFUNCTION(ServerSoftware)
  char *pszResult;
  long slen;
  pModuleObject p;
  p = (pModuleObject)besMODULEPOINTER;
  pszResult = cgi_ServerSoftware(&(p->Cgi));
  if( pszResult ){
    slen = strlen(pszResult);
    besALLOC_RETURN_STRING(slen);
    memcpy(STRINGVALUE(besRETURNVALUE),pszResult,slen);
    return COMMAND_ERROR_SUCCESS;
    }else{
    besRETURNVALUE = NULL;
    return COMMAND_ERROR_SUCCESS;
    }
besEND


ENVIRFUNC(ServerName)
ENVIRFUNC(GatewayInterface)
ENVIRFUNC(ServerProtocol)
ENVIRFUNC(ServerPort)
ENVIRFUNC(RequestMethod)
ENVIRFUNC(PathInfo)
ENVIRFUNC(PathTranslated)
ENVIRFUNC(ScriptName)
ENVIRFUNC(QueryString)
ENVIRFUNC(RemoteHost)
ENVIRFUNC(RemoteAddress)
ENVIRFUNC(AuthType)
ENVIRFUNC(RemoteUser)
ENVIRFUNC(RemoteIdent)
ENVIRFUNC(ContentType)
ENVIRFUNC(ContentLength)
ENVIRFUNC(UserAgent)
ENVIRFUNC(Cookie)

/*

Define a named symbol passing the value.

*/
besFUNCTION(defsname)
  pModuleObject p;
  VARIABLE Argument;
  char *pszName,*pszValue;
  void **q;

  p = (pModuleObject)besMODULEPOINTER;
  pszName = pszValue = NULL;

  if( besARGNR >= 1 ){
    Argument = besARGUMENT(1);
    besDEREFERENCE(Argument);
    Argument = besCONVERT2STRING(Argument);
    besCONVERT2ZCHAR(Argument,pszName);
    }

  if( besARGNR >= 2 ){
    Argument = besARGUMENT(2);
    besDEREFERENCE(Argument);
    Argument = besCONVERT2STRING(Argument);
    besCONVERT2ZCHAR(Argument,pszValue);
    }

  if( p->symboltable == NULL ){
    p->symboltable = besNEWSYMBOLTABLE();
    if( p->symboltable == NULL )return COMMAND_ERROR_MEMORY_LOW;
    }
 
 q = besLOOKUPSYMBOL(pszName,p->symboltable,1);
 /* if there was any name defined for this symbol */
 if( *q )besFREE(*q);
 *q = pszValue;
 besFREE(pszName);
besEND

static void freesymbol_callback(char *SymbolName, char *SymbolValue, void *p){
  pSupportTable pSt=p;
  if( SymbolValue )
    besFREE(SymbolValue);
  }

/*

Reset the symbol table removing all symbols and releasing memory.

*/
besFUNCTION(resetsymt)

  pModuleObject p;

  p = (pModuleObject)besMODULEPOINTER;
  if( p->symboltable != NULL ){
    besTRAVERSESYMBOLTABLE(p->symboltable,(void *)freesymbol_callback,pSt);
    besFREESYMBOLTABLE(p->symboltable);
    p->symboltable = NULL;
    }

besEND

/*
 define a named symbol by the file it is contained
*/
besFUNCTION(defsfile)
  pModuleObject p;
  VARIABLE Argument;
  char *pszName,*pszValue,*pszFile;
  void **q;
  FILE *fp;
  long lFileLength,i;
  int ch;

  p = (pModuleObject)besMODULEPOINTER;
  pszName = pszValue = NULL;

  if( besARGNR >= 1 ){
    Argument = besARGUMENT(1);
    besDEREFERENCE(Argument);
    Argument = besCONVERT2STRING(Argument);
    besCONVERT2ZCHAR(Argument,pszName);
    }

  if( besARGNR >= 2 ){
    Argument = besARGUMENT(2);
    besDEREFERENCE(Argument);
    Argument = besCONVERT2STRING(Argument);
    besCONVERT2ZCHAR(Argument,pszFile);
    }

  fp = besFOPEN(pszFile,"rb");
  if( fp == NULL ){
    besFREE(pszName);
    besFREE(pszFile);
    return COMMAND_ERROR_FILE_CANNOT_BE_OPENED;
    }
  lFileLength = besSIZE(pszFile);
  besFREE(pszFile);
  pszValue = besALLOC(lFileLength+1);
  for( i=0 ; i<lFileLength && (ch=besFGETC(fp)) != EOF ; i++ ){
    pszValue[i] = ch;
    }
  besFCLOSE(fp);
  pszValue[i] = (char)0;

  if( p->symboltable == NULL ){
    p->symboltable = besNEWSYMBOLTABLE();
    if( p->symboltable == NULL )return COMMAND_ERROR_MEMORY_LOW;
    }
 
 q = besLOOKUPSYMBOL(pszName,p->symboltable,1);
 /* if there was any name defined for this symbol */
 if( *q )besFREE(*q);
 *q = pszValue;
 besFREE(pszName);
besEND

/*
 get a file resolving the references inside it
*/
besFUNCTION(getfile)
  pModuleObject p;
  VARIABLE Argument;
  void **q;
  char *pszFile,
       *pszName,
       *pszValue,
       *pszSymbolValue,
       *pszResult,
       cSave;
  FILE *fp;
  long lFileLength,i,j;
  int ch;
  long cRemovedChars,cInsertedChars,cTotalChars;

  p = (pModuleObject)besMODULEPOINTER;
  if( besARGNR >= 1 ){
    Argument = besARGUMENT(1);
    besDEREFERENCE(Argument);
    Argument = besCONVERT2STRING(Argument);
    besCONVERT2ZCHAR(Argument,pszFile);
    }else return COMMAND_ERROR_FILE_CANNOT_BE_OPENED;
 
  if( besARGNR >= 2 ){
    pszValue = pszFile;
   }else{
    fp = besFOPEN(pszFile,"rb");
    if( fp == NULL ){
      besFREE(pszFile);
      return COMMAND_ERROR_FILE_CANNOT_BE_OPENED;
      }
    lFileLength = besSIZE(pszFile);
    besFREE(pszFile);
    pszValue = besALLOC(lFileLength+1);
    for( i=0 ; i < lFileLength && (ch=besFGETC(fp)) != EOF ; i++ ){
      pszValue[i] = ch;
      }
    besFCLOSE(fp);
    pszValue[i] = (char)0;
    }

  cRemovedChars = 0;
  cInsertedChars = 0;
  /* here it has to resolve the references iteratively and return the result */

  /* loop counting the characters in the comments and counting the characters that are to be inserted */
  for( i=0 ; pszValue[i] ; i++ ){/*COUNT LOOP*/
    /* skip the <!--- comments --> (note: starts with three dashes!) */
    if( pszValue[i+0] == '<' && 
        pszValue[i+1] == '!' && 
        pszValue[i+2] == '-' && 
        pszValue[i+3] == '-' && 
        pszValue[i+4] == '-' ){
        i += 5;/* step over the <!--- */
        cRemovedChars += 5;
        while( pszValue[i] &&
               ! ( pszValue[i+0] == '-' &&
                   pszValue[i+1] == '-' &&
                   pszValue[i+2] == '>') )i++,cRemovedChars++;
        if( pszValue[i] ){
          i += 2;
          cRemovedChars += 3;
          }else i--;
        continue;
        }

    if( pszValue[i+0] == '<' && 
        pszValue[i+1] == '!' && 
        pszValue[i+2] == '-' && 
        pszValue[i+3] == '-' ){
      i += 4; /* step over the <!-- */
      cRemovedChars += 4;
      /* step over the spaces */
      while( pszValue[i] && isspace(pszValue[i]) )i++,cRemovedChars++;
      pszName = pszValue+i;
      while( pszValue[i] &&
             !isspace(pszValue[i]) &&
             pszValue[i] != '=' &&
             pszValue[i] != '-' )i++,cRemovedChars++;
      cSave = pszValue[i];
      pszValue[i] = (char)0;
      q = besLOOKUPSYMBOL(pszName,p->symboltable,0);
      pszValue[i] = cSave;
      if( q && *q ){
        /* there is a symbol defined */
        pszSymbolValue = (char *)*q;
        /* get the length of the string to be inserted */
        while( *pszSymbolValue )cInsertedChars++,pszSymbolValue++;
        /* go to the end of the comment */
        while( pszValue[i] &&
             ! ( pszValue[i+0] == '-' &&
                 pszValue[i+1] == '-' &&
                 pszValue[i+2] == '>') )i++,cRemovedChars++;
        if( pszValue[i] ){
          i += 2;
          cRemovedChars += 3;
          }else i--;
        continue;
        }else{
        /* the symbol is not defined in the symbol table */
        /*step over the optional spaces between the name and the = */
        while( pszValue[i] && isspace(pszValue[i]) )i++,cRemovedChars++;
        if( pszValue[i] == '=' ){/* there is some default value */
          i++,cRemovedChars++;
          /*step over the optional spaces between the = and the default value */
          while( pszValue[i] && isspace(pszValue[i]) )i++,cRemovedChars++;
          if( pszValue[i] && (pszValue[i] == '\'' || pszValue[i] == '\"') )
            cRemovedChars++,cSave = pszValue[i++];
          else
            cSave = ' ';
          while( pszValue[i] ){
            if( pszValue[i] == cSave )break;
            if( cSave == ' ' &&
                pszValue[i+0] == '-' &&
                pszValue[i+1] == '-' &&
                pszValue[i+2] == '>' )break;
            i++; /* we could also increment cRemovedChars and cInsertedChars */
            }
          }
        /* go to the end of the comment */
        while( pszValue[i] &&
             ! ( pszValue[i+0] == '-' &&
                 pszValue[i+1] == '-' &&
                 pszValue[i+2] == '>') )i++,cRemovedChars++;
          if( pszValue[i] ){
            i += 2;
            cRemovedChars += 3;
            }else i--;
          continue;
        }
      }
    }/*COUNT LOOP*/


  cTotalChars = i - cRemovedChars + cInsertedChars;
  besALLOC_RETURN_STRING(cTotalChars);
  pszResult = STRINGVALUE(besRETURNVALUE );

  /* loop replacing the symbols with the values of the referenced symbols  */
  for( j=i=0 ; pszValue[i] ; i++ ){/*REPLACE LOOP*/
    /* skip the <!--- comments --> (note: starts with three dashes!) */
    if( pszValue[i+0] == '<' && 
        pszValue[i+1] == '!' && 
        pszValue[i+2] == '-' && 
        pszValue[i+3] == '-' && 
        pszValue[i+4] == '-' ){
        i += 5;/* step over the <!--- */
        while( pszValue[i] &&
               ! ( pszValue[i+0] == '-' &&
                   pszValue[i+1] == '-' &&
                   pszValue[i+2] == '>') )i++;
        if( pszValue[i] )i += 2; else i--;
        continue;
        }

    if( pszValue[i+0] == '<' && 
        pszValue[i+1] == '!' && 
        pszValue[i+2] == '-' && 
        pszValue[i+3] == '-' ){
      i += 4; /* step over the <!-- */
      /* step over the spaces */
      while( pszValue[i] && isspace(pszValue[i]) )i++;
      pszName = pszValue+i;
      while( pszValue[i] &&
             !isspace(pszValue[i]) &&
             pszValue[i] != '=' &&
             pszValue[i] != '-' )i++;
      cSave = pszValue[i];
      pszValue[i] = (char)0;
      q = besLOOKUPSYMBOL(pszName,p->symboltable,0);
      pszValue[i] = cSave;
      if( q && *q ){
        /* there is a symbol defined */
        pszSymbolValue = (char *)*q;
        /* get the length of the string to be inserted */
        while( *pszSymbolValue )pszResult[j++] = *pszSymbolValue++;
        /* go to the end of the comment */
        while( pszValue[i] &&
             ! ( pszValue[i+0] == '-' &&
                 pszValue[i+1] == '-' &&
                 pszValue[i+2] == '>') )i++;
        if( pszValue[i] ) i += 2; else i--;
        continue;
        }else{
        /* the symbol is not defined in the symbol table */
        /*step over the optional spaces between the name and the = */
        while( pszValue[i] && isspace(pszValue[i]) )i++,cRemovedChars++;
        if( pszValue[i] == '=' ){/* there is some default value */
          i++;
          /*step over the optional spaces between the = and the default value */
          while( pszValue[i] && isspace(pszValue[i]) )i++;
          if( pszValue[i] && (pszValue[i] == '\'' || pszValue[i] == '\"') )
            cSave = pszValue[i++];
          else
            cSave = ' ';
          while( pszValue[i] ){
            if( pszValue[i] == cSave )break;
            if( cSave == ' ' &&
                pszValue[i+0] == '-' &&
                pszValue[i+1] == '-' &&
                pszValue[i+2] == '>' )break;
            pszResult[j++] = pszValue[i++];
            }
          }
        /* go to the end of the comment */
        while( pszValue[i] &&
             ! ( pszValue[i+0] == '-' &&
                 pszValue[i+1] == '-' &&
                 pszValue[i+2] == '>') )i++,cRemovedChars++;
          if( pszValue[i] ){
            i += 2;
            cRemovedChars += 3;
            }else i--;
          continue;
        }/*if( q && *q ) */
      }/* if( <!-- ... */
    pszResult[j++] = pszValue[i];
    }/*REPLACE LOOP*/

  return 0;
besEND
