# read a C file and create a header file from it
#
#  Lines processed: HEADER: headerfilename
#                   FILE:   name of the file (used to create header file name unless HEADER is defined)
#                   TO_HEADER:
#                      lines until a single */ on a line are put to the header file
#
#                   /*FUNCTION*/
#                   lines are put to the header file until a single { is found on a line
#                   ; is added after these lines
#
#                   GLOBAL declaration
#                   is put to the header file replcing 'GLOBAL' to 'extern'
#                   define GLOBAL to nothing in the source file
#

START_HERE:
$file = shift;
exit unless defined $file;

$input_file_name = '';
$header_file_name = '';
$header_file_opened = 0;
$header_file = undef;

open(F,"<$file") or die "Can not open the input file $file";
$header_content = '';

while( defined( $_ = <F>) ){
  chomp;

  if( /^\s*FILE\s*:\s*(\S+)/ ){
    $input_file_name = $1;
    next;
    }

  if( /^\s*HEADER\s*:\s*(\S+)/ ){
    $header_file_name = $1;
    next;
    }

  if( /^\s*TO_HEADER\s*:/ ){
    &open_header_file;
    while( <F> ){
      chomp;
      last if m{^\s*\*/\s*$};
      if( m{^(.*)//(.*)} ){
        $_ = $1;
        }
      s/\\\s*$/\\/; # delete trailing space after \
      $header_content .= "$_\n";
      }
    next;
    }

  if( m{^\s*/\*FUNCTION\*/\s*$} ){
    &open_header_file;
    while( <F> ){
      chomp;
      last if m{^\s*\)\s*\{\s*$};
      $header_content .= "\n$_";
      }
    $header_content .= ");\n";
    next;
    }
  }

$header_content .= "#endif\n";
close F;

if( $header_file_opened ){
  if( open(H,"<$open_header_file_name") ){
    # check if the file is identical
    my $oldsep = $/; undef $/;
    $q = <H>;
    close H;
    $/ = $oldsep;
    goto START_HERE if $q eq $header_content;
    }
  open(H,">$open_header_file_name") or die "Can not open header file $open_header_file_name";
  print H $header_content;
  close H;
  }else{
  print STDERR "No header was created for $file\n";
  }
goto START_HERE;

sub open_header_file {

  return if $header_file_opened;

  $header_file_opened = 1;

  if( ! $header_file_name && ! $input_file_name ){
    $header_file_name = $file;
    $header_file_name =~ s/\.\w+$/.h/;
    }
  if( ! $header_file_name ){
    $header_file_name = $input_file_name;
    $header_file_name =~ s/\.\w+$/.h/;
    }
  if( ! $header_file_name ){
    die "No header file name.";
    }

  # modify the header name so that it is created in the same directory as the source
  my $dir = $file;
  $dir =~ s/\\/\//g; # leaning toothpicks effect :-) (convert \ to / for Win32 users)
  if( $dir =~ s/\/[^\/]+$// ){
    $open_header_file_name = "$dir/$header_file_name";
    }else{
    $open_header_file_name = $header_file_name;
    }
  $header_symbol = uc $header_file_name;
  $header_symbol =~ s{^.*/}{};
  $header_symbol = '__'.$header_symbol.'__';
  $header_symbol =~ s/\./_/g;
  $header_content .= "/*\n$header_file_name\n*/\n#ifndef $header_symbol\n#define $header_symbol 1\n";
  }
