'
' FILE: heb.bas
'
' This is the module declaration of the ScriptBasic external module cgi
'
' To use this module you have to have cgi.dll or cgi.so installed in the
' modules directory.
'
' This include file is imported by all HTML embedded BASIC files automatically,
' the preprocessor inserts the import statement at the start of the files. This
' file is the same as cgi.bas with the exception that it puts all functions and
' constants into the main name space.

' When requestiong SaveFile for a field name that does not exist
const ErrorNoFile           = &H00080000
const ErrorBufferOverflow   = &H00080001
const ErrorContentTooLarge  = &H00080002
const ErrorMethodIsInvalid  = &H00080003
const ErrorNoDebugFile      = &H00080004
const ErrorNotImplemented   = &H00080005
const ErrorEndOfFile        = &H00080006
const ErrorIllFormedUpload  = &H00080007
const ErrorFileTooLarge     = &H00080008
const ErrorMethodNotAllowed = &H0008000A

' constants for setting option cgi$Method
const None   = &H00000000
const Get    = &H00000001
const Post   = &H00000002
const Upload = &H00000006
const Put    = &H00000008
const Del    = &H00000010
const Copy   = &H00000020
const Move   = &H00000040

'
' GetParam("param")
'
declare sub GetParam alias "getget" lib "cgi"

'
' PostParam("param")
'
declare sub PostParam alias "getpost" lib "cgi"

Function Param(ParameterName)
local ParameterValue

  ParameterValue = GetParam(ParameterName)
  If NOT IsDefined(ParameterValue) Then
    ParameterValue = PostParam(ParameterName)
  End If

  Param = ParameterValue
End Function

'
' q = undef
' GetParamEx("param",q)
' GetParamEx("param",q)
' ....
'
declare sub GetParamEx alias "getgetex" lib "cgi"

'
' q = undef
' PostParamEx("param",q)
' PostParamEx("param",q)
' ....
'
declare sub PostParamEx alias "getpostex" lib "cgi"

'
' SaveFile("param","filename")
'
declare sub SaveFile alias "savefile" lib "cgi"

'
' FileName("param")
'
declare sub FileName alias "filename" lib "cgi"

'
' FileLength("param")
'
declare sub FileLength alias "filelen" lib "cgi"

declare sub ServerSoftware alias "ServerSoftware" lib "cgi"
declare sub ServerName alias "ServerName" lib "cgi"
declare sub GatewayInterface alias "GatewayInterface" lib "cgi"
declare sub ServerProtocol alias "ServerProtocol" lib "cgi"
declare sub ServerPort alias "ServerPort" lib "cgi"
declare sub RequestMethod alias "RequestMethod" lib "cgi"
declare sub PathInfo alias "PathInfo" lib "cgi"
declare sub PathTranslated alias "PathTranslated" lib "cgi"
declare sub ScriptName alias "ScriptName" lib "cgi"
declare sub QueryString alias "QueryString" lib "cgi"
declare sub RemoteHost alias "RemoteHost" lib "cgi"
declare sub RemoteAddress alias "RemoteAddress" lib "cgi"
declare sub AuthType alias "AuthType" lib "cgi"
declare sub RemoteUser alias "RemoteUser" lib "cgi"
declare sub RemoteIdent alias "RemoteIdent" lib "cgi"
declare sub ContentType alias "ContentType" lib "cgi"
declare sub ContentLength alias "ContentLength" lib "cgi"
declare sub UserAgent alias "UserAgent" lib "cgi"
declare sub RawCookie alias "Cookie" lib "cgi"

' ------------------------------------------------

'
' SymbolName(Name,Value)
' define a symbol to use later in templates resolved
'
declare sub SymbolName   alias "defsname" lib "cgi"

'
' SymbolFile(Name,File)
' define a symbol gicing the name of the file where it is
'
declare sub SymbolFile   alias "defsfile" lib "cgi"

'
' ResetSymbols
' reset the symbol table
'
declare sub ResetSymbols alias "resetsymt" lib "cgi"

'
' GetHtmlTemplate(File)
' return the content of the file with symbols resolved
'
declare sub GetHtmlTemplate alias "getfile" lib "cgi"

'
' ResolveHtml(Text)
' Resolve an HTML text given as argument
'
sub ResolveHtml(HtmlText)
  ResolveHtml = GetHtmlTemplate(HtmlText,1)
end sub

'
' EmitHtmlTemplate(FileName)
' emit the content of the HTML template to the web client
'
sub EmitHtmlTemplate(FileName)
  print GetHtmlTemplate(FileName)
end sub

sub Header(State,ContentType)
  if ServerSoftware() like "Microsoft-IIS*" then
    print "HTTP/1.0 ",State,"\nContent-Type: ",ContentType,"\n"
  else
    print "Status: ",State,"\nContent-Type: ",ContentType,"\n"
  end if
end sub

sub SetCookie(CookieName,CookieValue,CookieDomain,CookiePath,CookieExpires,CookieIsSecure)
  print "Set-cookie:",CookieName,"=",CookieValue,";"
  if IsDefined( CookieDomain ) then
    print " domain=",CookieDomain,";"
  end if
  if IsDefined( CookiePath ) then
    print " path=",CookiePath,";"
  end if
  if IsDefined(CookieExpires) then
    print FormatDate("expires=WDN, DD-MON-YY HH:mm:ss GMT;",CookieExpires)
  end if
'Wdy, DD-Mon-YY HH:MM:SS GMT
  if CookieIsSecure then
    print " secure"
  end if
  print "\n"
end sub

sub FinishHeader
  print "\n"
end sub

function Cookie(CookieName)
  local RawCookieText,CookieList,i,LikeString,CookieValue

  RawCookieText = RawCookie()
  splita RawCookieText by ";" to CookieList
  LikeString = CookieName & "=*"
  i = 0
  while IsDefined(CookieList[i])
   CookieList[i] = trim(CookieList[i])
   if CookieList[i] LIKE LikeString then
     split CookieList[i] by "=" to CookieName,CookieValue
     Cookie = CookieValue
     exit function
   end if
   i = i + 1
  wend
' by default function return value is undef when cookie is not found
end function

