/*
FILE:   options.c
HEADER: options.h

--GNU LGPL
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Handling options

TO_HEADER:

*/


#include <stdio.h>
#include <stdlib.h>

#include "sym.h"
#include "errcodes.h"
#include "report.h"
#include "lexer.h"
#include "expression.h"
#include "builder.h"
#include "memory.h"
#include "syntax.h"
#include "execute.h"
#include "myalloc.h"
#include "command.h"

/*POD
=H Setting and gettion an option value


CUT*/

/*POD
=section Reset
=H Clear an option data

/*FUNCTION*/
int options_Reset(pExecuteObject pEo,
                  char *name
  ){
/*noverbatim
CUT*/
  void **p;

  if( pEo->OptionsTable == NULL )
    pEo->OptionsTable = sym_NewSymbolTable(alloc_Alloc,pEo->pMemorySegment);
  if( pEo->OptionsTable == NULL )return 1;
  p = sym_LookupSymbol(name,pEo->OptionsTable,1,alloc_Alloc,alloc_Free,pEo->pMemorySegment);
  if( p == NULL )return 1;
  if( *p == NULL )return 0; /* it was already clear */
  alloc_Free(p,pEo->pMemorySegment);
  *p = NULL;
  return 0;
  }

/*POD
=section Set
=H Set option data

This function sets a long value for an option.

/*FUNCTION*/
int options_Set(pExecuteObject pEo,
                char *name,
                long value
  ){
/*noverbatim
CUT*/
  void **p;

  if( pEo->OptionsTable == NULL )
    pEo->OptionsTable = sym_NewSymbolTable(alloc_Alloc,pEo->pMemorySegment);
  if( pEo->OptionsTable == NULL )return 1;
  p = sym_LookupSymbol(name,pEo->OptionsTable,1,alloc_Alloc,alloc_Free,pEo->pMemorySegment);
  if( p == NULL )return 1;
  if( *p == NULL ){
    *p = alloc_Alloc(sizeof(long),pEo->pMemorySegment);
    if( *p == NULL )return 1;
    }
  *((long *)*p) = value;
  return 0;
  }

/*POD
=section Get
=H Set option data

This function gets a long value for an option.

/*FUNCTION*/
long options_Get(pExecuteObject pEo,
                 char *name
  ){
/*noverbatim
CUT*/
  void **p;
  char *pszName;

  pszName = ALLOC(strlen(name)+1);
  if( pszName == NULL )return 0L;
  strcpy(pszName,name);
  if( pEo->OptionsTable == NULL )return 0L;
  p = sym_LookupSymbol(pszName,pEo->OptionsTable,1,alloc_Alloc,alloc_Free,pEo->pMemorySegment);
  FREE(pszName);
  if( p == NULL )return 0L;
  if( *p == NULL )return 0L;

  return *((long *)*p);
  }