; scriba.conf
; ScriptBasic sample configuration file
;
; Note that this configuration file format is from v1.0b19 or later and has to be compiled
; to internal binary format before starting ScriptBasic

; this is the extension of the dynamic load libraries on this system
dll ".dll"


; where the modules are to be loaded from
module "e:\\MyProjects\\sb\\modules\\"
module "e:\\MyProjects\\sb\\sysmodules\\"
module "e:\\ScriptBasic\\modules\\"

; where to search system and module include files
; trailing / or \\ is needed
include "e:\\MyProjects\\sb\\source\\include\\"
include "e:\\ScriptBasic\\source\\include\\"


;
; define external preprocessors
;
preproc (
;  internal (
;    )

; extensions that preprocessors are to be applied on
  extensions (
; here the key is the extension and the value is the symbolic name of the external preprocessor
     heb "heb"
     )
; the external preprocessors
  external (
    heb (
      executable "e:\\MyProjects\\sb\\Release\\scriba.exe e:\\MyProjects\\sb\\source\\heber.bas"
      directory "e:\\MyProjects\\sb\\hebtemp\\"
      )
    )
  )

;
; LIMIT VALUES TO STOP INIFINITE LOOP
;

; the maximal number of steps allowed for a program to run
; comment it out or set to zero to have no limit
maxstep 30000

; the maximal number of steps allowed for a program to run
; inside a function.
; comment it out or set to zero to have no limit
maxlocalstep 0

; the maximal number of recursive function call deepness
; essentially this is the "stack" size
maxlevel 300


; the maximal memory in bytes that a basic program is allowed to use
; for its variables
maxmem 1000000

;
; ScriptBasic loads the modules before starting the code
; in the order they are specified here
;
;preload "ext_trial"

;
; This is the directory where we store the compiled code
; to automatically avoid recompilation
;
cache "e:\\MyProjects\\sb\\cache\\"

isapi (
;
; where to write error messages when running the isapi interpreter
;
  report "e:\\MyProjects\\sb\\error.log"

;
; When an error happens this file is sent to the client after the
; listed error messages. Error messages are recorded in the error log file
; if there is configured any and are also sent to the client browser.
; after the list of error messages this file is sent. This is actually the tail
; of an HTML file. It has to contain </TT></FONT></BODY></HTML> tags in this
; order with optional extra text between. You probably want to place the webmaster
; eMail address in this text.
;
  errmesfile "e:\\MyProjects\\sb\\source\\error.html"

;
; If this config key exists scribais.dll will cache the compiled code
; into memory. To avoid memory caching during development comment this
; config line out.
;
; Note that if there is a code in memory cache it is used even if the code on
; disk has changed! This results fast execution but may be inconvinient during 
; development.
;
;  memcache

;
; This parameter is used by the CGI module when the interface is ISAPI
; This parameter gives the size of the buffer that the module uses to handle
; POST parameters above 48K (usually uploads). The larger the buffer is the
; faster upload handling can be.
;
  buffer "655360"
  )

cgi (
;
; These are the keys used by the CGI module
;
  debugfile "e:\\MyProjects\\sb\\cgidebug.txt"
  )

;
; berkeley db config
;
bdb (

 ; directories where to store the 
 dir (
   home "e:\\MyProjects\\sb\\sampledb" ; the home directory of operation of the Berkerley DB
   data "db"  ; database files
   log  "log" ; log files
   temp "tmp" ; temporary files
   )

; ScriptBasic extension modules can access only string configuration values
; therefore you have to specify these numbers within quotes (later versions will change it)
;  limits (
;    lg_max "1024000"
;    mp_mmapsize "0000"
;    mp_size "000"
;    tx_max "000"
;    lk_max "000"
;    )

  ; what lock strategy to use
  ; it can be any of the followings
  ; default oldest random youngest
  lockstrategy default

  flags (
    ; set the value to yes or no
    lock_default no
    init_lock yes
    init_log yes
    init_mpool yes
    init_txn yes
    create yes
    )
  )

;
; MySQL configuration
;
mysql (
  connections (
    test (        ; the name of the connection
	  host "127.0.0.1" ; the host for the connection
	  db "test"   ; database for the connection
	  user "root" ; user for the connection
	  password "" ; password for the connection
	  port 0      ; the port to use
	  socket ""  ; the name of the socket or ""
	  flag 0      ; the client flag
	  clients 10  ; how many clients to serve before really closing the connections
	  )
    )
  )

;
; Configure the sample preprocessor
;
preproc$sample_uppercase "D:/MyProjects/sb/Debug/preproc.dll"

;break