; scriba.conf
; ScriptBasic sample configuration file
;
; Note that this configuration file format is from v1.0b19 or later and has to be compiled
; to internal binary format before starting ScriptBasic

; this is the extension of the dynamic load libraries on this system
dll ".so"

; where the modules are to be loaded from
module "/etc/scriba/modules/"

; where to search system and module include files
; trailing / or / is needed
include "/etc/scriba/include/"

;
; define external preprocessors
;
preproc (
;  internal (
;    )

; extensions that preprocessors are to be applied on
  extensions (
; here the key is the extension and the value is the symbolic name of the external preprocessor
     heb "heb"
     )
; the external preprocessors
  external (
    heb (
      executable "/usr/bin/scriba /etc/scriba/source/heber.bas"
      directory "/etc/scriba/hebtemp/"
      )
    )
  )

;
; LIMIT VALUES TO STOP INIFINITE LOOP
;

; the maximal number of steps allowed for a program to run
; comment it out or set to zero to have no limit
maxstep 30000

; the maximal number of steps allowed for a program to run
; inside a function.
; comment it out or set to zero to have no limit
maxlocalstep 0

; the maximal number of recursive function call deepness
; essentially this is the "stack" size
maxlevel 300


; the maximal memory in bytes that a basic program is allowed to use
; for its variables
maxmem 1000000

;
; ScriptBasic loads the modules before starting the code
; in the order they are specified here
;
;preload "ext_trial"

;
; This is the directory where we store the compiled code
; to automatically avoid recompilation
;
cache "/etc/scriba/cache/"

cgi (
;
; These are the keys used by the CGI module
;
  debugfile "/etc/scriba/cgidebug.txt"
  )

;
; berkeley db config
;
bdb (

 ; directories where to store the 
 dir (
   home "/etc/scriba/sampledb" ; the home directory of operation of the Berkerley DB
   data "db"  ; database files
   log  "log" ; log files
   temp "tmp" ; temporary files
   )

; ScriptBasic extension modules can access only string configuration values
; therefore you have to specify these numbers within quotes (later versions will change it)
;  limits (
;    lg_max "1024000"
;    mp_mmapsize "0000"
;    mp_size "000"
;    tx_max "000"
;    lk_max "000"
;    )

  ; what lock strategy to use
  ; it can be any of the followings
  ; default oldest random youngest
  lockstrategy default

  flags (
    ; set the value to yes or no
    lock_default no
    init_lock yes
    init_log yes
    init_mpool yes
    init_txn yes
    create yes
    )
  )

;break