/* 

FILE:   scribacmd.c
HEADER: scribacmd.h

--GNU LGPL
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

TO_HEADER:

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../../getopt.h"
#include "../../scriba.h"

#include "../../basext.h"

int GetC(void *f){ return getc((FILE *)f); }

#ifdef _DEBUG
#define ERREXIT do{getchar();exit(1);}while(0)
#else
#define ERREXIT exit(1)
#endif

#ifdef WIN32
main(int argc, char *argv[]){
#else
char **_environ;
main(int argc, char *argv[], char *env[]){
#endif
  int iError;
  unsigned long iErrorCounter;
  int OptionIndex;
  pSbProgram pProgram;
  char *pszForcedConfigurationFileName;
  unsigned long fErrorFlags;
  char *szInputFile,
       *szOutputFile;
  char *optarg,opt;
  /* the maximal number of preprocessors that are applied in chain */
#define MAXPREPROC 100
  char *pszEPreproc[MAXPREPROC],*pszPreprocessedFileName;
  int iPreprocIndex;
  int giveusage,binarycode,nocache,iscgi,isCoutput;
  int execute;
#define FULL_PATH_BUFFER_LENGTH 256
  char CmdLinBuffer[FULL_PATH_BUFFER_LENGTH];
pSbData p,psb;
SbData RetVale;
#ifndef WIN32
  _environ = env;
#endif

#ifdef _DEBUG
#define malloc testa_Alloc
#define free testa_Free
  testa_InitSegment();
#endif

  /* default values for command line options */
  szInputFile = NULL;
  szOutputFile = NULL;
  iPreprocIndex = 0; /* no external preprocessor by default */
  pszPreprocessedFileName = NULL;
  *pszEPreproc = NULL; 
  giveusage  = 0; /* assume the command line is correct, we need not display usage and stop */
  binarycode = 0; /* input is not binary by default */
  execute    = 0; /* do not execute by default after binary format save */
  nocache   = 0; /* we use cached code if it exists */
  OptionIndex = 0;
  iscgi = 0; /* by default this is not a cgi script, not HTTP/1.0 ... when error message is sent */
  isCoutput = 0;
  pszForcedConfigurationFileName = NULL;

  while( (opt = getoptt(argc, argv, "f:pCcnvebo:",&optarg,&OptionIndex)) != ':'){
    switch( opt ){
      case 'p' :
        if( iPreprocIndex >= MAXPREPROC-1 )
          giveusage = 1;
        else{
          pszEPreproc[iPreprocIndex ++ ] = optarg;
          pszEPreproc[iPreprocIndex] = NULL;
          }
         break;
      case 'C' :
        if( isCoutput )giveusage = 1;
        isCoutput = 1;
        break;
      case 'c' :
        if( iscgi )giveusage = 1;
        iscgi = 1;
        break;
      case 'n' :
        if( nocache )giveusage = 1;
        nocache = 1;
        break;
      case 'e' :
        if( execute )giveusage = 1;
        execute = 1;
        break;
      case 'f' :
        if( pszForcedConfigurationFileName )giveusage = 1;
        pszForcedConfigurationFileName = optarg;
        break;
      case 'o' :
        if( szOutputFile || binarycode )giveusage = 1;
        szOutputFile = optarg;
        break;
      case 'b':
        if( szOutputFile || binarycode )giveusage = 1;
        binarycode =1;
        break;
      case 'v':
#define S fprintf(stderr,
#define E );
                   S "ScriptBasic v%ld.%ld\n",VERSION_HIGH,VERSION_LOW E
                   S "Variation >>%s<< build %ld\n",VARIATION,SCRIPTBASIC_BUILD E
                   S "Magic value %lu\n",build_MagicCode(NULL) E
                   S "Node size is %d\n", sizeof(cNODE) E
                   S "Extension interface version is %d\n",INTERFACE_VERSION E
                   S "Compilation: %s %s\n", __DATE__,__TIME__ E
        exit(0);
      case '!' :
        giveusage = 1;
        break;
      case '?':
        if( szInputFile )giveusage = 1;
        szInputFile = optarg;
        CmdLinBuffer[0] = (char)0;
        while( OptionIndex < argc ){
          strcat(CmdLinBuffer,argv[OptionIndex++]);
          if( OptionIndex < argc )
            strcat(CmdLinBuffer," ");
          }
        goto CmdLineFinished;
      }
    }

CmdLineFinished:
  if( execute && binarycode )giveusage=1;
  if( isCoutput && !szOutputFile )giveusage=1;

  if( szInputFile == NULL || giveusage ){
#define U(x) fprintf(stderr,"%s\n",(x));
    U("Usage: basic [options] program.bas")
    U("")
    U("options: -o file_name")
    U("            save binary format to file but don't execute")
    U("         -b file_name")
    U("            load binary format from file and execute")
    U("         -n")
    U("            do not use cache (no save, no load)")
    U("         -e")
    U("            execute after binary format was saved")
    U("         -v")
    U("            print version info and stop")
    U("         -c")
    U("            inform scriba that this is a CGI script.")
    U("         -C");
    U("            save C program output.");
    U("         -p preprocessor");
    U("            specify preprocessor.");
    U("         -f configurationfile");
    U("            specify configuration file");
    exit(1);
    }

  pProgram = scriba_new(malloc,free);
  scriba_LoadConfiguration(pProgram,pszForcedConfigurationFileName);

  if( iscgi )scriba_SetCgiFlag(pProgram);

  scriba_SetFileName(pProgram,szInputFile);

  if( scriba_UseCacheFile(pProgram) == SCRIBA_ERROR_SUCCESS )binarycode = 1;
  if( binarycode || scriba_IsFileBinaryFormat(pProgram) ){
    if( scriba_LoadBinaryProgram(pProgram) != 0 ){
      ERREXIT;
      }
    }else{
    if( iError=scriba_RunExternalPreprocessor(pProgram,pszEPreproc) ){
      report_report(stderr,"",0,iError,REPORT_ERROR,&iErrorCounter,NULL,&fErrorFlags);
      ERREXIT;
      }
    if( scriba_LoadSourceProgram(pProgram) )ERREXIT;
    if( szOutputFile ){
      if( isCoutput )
        scriba_SaveCCode(pProgram,szOutputFile);
      else
        scriba_SaveCode(pProgram,szOutputFile);
      if( !execute )exit(0);
      }
     scriba_SaveCacheFile(pProgram);
    }
  if( iError=scriba_Run(pProgram,CmdLinBuffer) ){
    report_report(stderr,"",0,iError,REPORT_ERROR,&iErrorCounter,NULL,&fErrorFlags);
    ERREXIT;
    }


/*

  p = scriba_NewSbArgs(pProgram,"i i i i",13,14,15,16);
  scriba_CallArgEx(pProgram,scriba_LookupFunctionByName(pProgram,"main::thisfunc"),&RetVale,4,p);
printf("modified argument is >>%s<<\n",scriba_GetString(pProgram,*p));
printf("return value is >>%s<<\n",scriba_GetString(pProgram,RetVale));
printf("testvar type is %d\n",scriba_GetVariableType(pProgram,
scriba_LookupVariableByName(pProgram,"main::testvar")));
scriba_GetVariable(pProgram,
                   scriba_LookupVariableByName(pProgram,"main::testvar"),
                   &psb
  );
printf("testvar from C is %s\n",scriba_GetString(pProgram,*psb));

scriba_SetVariable(pProgram,scriba_LookupVariableByName(pProgram,"main::testvar"),
                   SBT_ZCHAR,1,2.2,"kukac",4);
scriba_CallArgEx(pProgram,scriba_LookupFunctionByName(pProgram,"main::thatfunc"),&RetVale,4,p);
*/
  scriba_destroy(pProgram);

#ifdef _DEBUG
  testa_AssertLeak();
  if( ! iscgi ){
    printf("Press any key to continue...\n");
    getchar();
    }
#endif
  if( iError )exit(1); else exit(0);
  }

