/* ScummVM - Scumm Interpreter
 * Copyright (C) 2003-2004 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/sky/compacts/30comp.h,v 1.12 2004/01/06 12:45:32 fingolfin Exp $ 
 *
 */

#ifndef SKY30COMP_H
#define SKY30COMP_H


#include "31comp.h"
#include "38comp.h"
#include "33comp.h"
#include "32comp.h"
#include "34comp.h"
#include "39comp.h"
#include "40comp.h"
#include "41comp.h"
#include "36comp.h"
#include "37comp.h"
#include "44comp.h"
#include "45comp.h"
#include "46comp.h"
#include "47comp.h"
#include "48comp.h"
#include "65comp.h"
#include "42comp.h"


namespace Sky {

namespace SkyCompact {

uint16 sc32_vinc_talk[] = {
	57*64,
	57*64,
	218,
	188,
	0,
	218,
	188,
	1,
	218,
	188,
	1,
	218,
	188,
	2,
	218,
	188,
	3,
	218,
	188,
	2,
	218,
	188,
	0,
	218,
	188,
	1,
	218,
	188,
	1,
	218,
	188,
	0,
	218,
	188,
	2,
	218,
	188,
	2,
	218,
	188,
	0,
	218,
	188,
	0,
	218,
	188,
	0,
	218,
	188,
	0,
	218,
	188,
	3,
	218,
	188,
	3,
	218,
	188,
	2,
	218,
	188,
	2,
	218,
	188,
	1,
	218,
	188,
	1,
	218,
	188,
	2,
	218,
	188,
	2,
	218,
	188,
	0,
	218,
	188,
	1,
	218,
	188,
	3,
	218,
	188,
	3,
	218,
	188,
	2,
	218,
	188,
	2,
	218,
	188,
	1,
	218,
	188,
	0,
	218,
	188,
	0,
	218,
	188,
	1,
	218,
	188,
	1,
	218,
	188,
	2,
	218,
	188,
	3,
	218,
	188,
	2,
	218,
	188,
	0,
	218,
	188,
	1,
	218,
	188,
	1,
	218,
	188,
	0,
	218,
	188,
	2,
	218,
	188,
	2,
	218,
	188,
	0,
	218,
	188,
	0,
	218,
	188,
	0,
	218,
	188,
	0,
	218,
	188,
	3,
	218,
	188,
	3,
	218,
	188,
	2,
	218,
	188,
	2,
	218,
	188,
	1,
	218,
	188,
	1,
	218,
	188,
	2,
	218,
	188,
	2,
	218,
	188,
	0,
	218,
	188,
	1,
	218,
	188,
	3,
	218,
	188,
	3,
	218,
	188,
	2,
	218,
	188,
	2,
	218,
	188,
	1,
	218,
	188,
	0,
	0
};

uint16 sc30_palette[] = {
	0,
	1792,
	1286,
	2313,
	2311,
	2825,
	2317,
	2823,
	2316,
	2827,
	3086,
	2064,
	3342,
	3340,
	4365,
	3852,
	3599,
	2575,
	3346,
	5643,
	2315,
	4366,
	2572,
	8206,
	4879,
	4104,
	5136,
	3863,
	4107,
	3859,
	4370,
	4370,
	2837,
	4624,
	5142,
	3347,
	4374,
	6417,
	3601,
	6163,
	5129,
	5395,
	5394,
	4882,
	3607,
	4892,
	6668,
	4117,
	5397,
	6169,
	3351,
	5654,
	5398,
	4122,
	4897,
	7181,
	5142,
	6422,
	6168,
	3612,
	5912,
	5659,
	5149,
	6417,
	8490,
	4119,
	6430,
	6166,
	6939,
	6684,
	6426,
	4383,
	6436,
	4882,
	11547,
	6945,
	7444,
	5662,
	7445,
	10282,
	4377,
	7198,
	8734,
	6171,
	7706,
	7966,
	6685,
	6950,
	5653,
	11806,
	8734,
	7445,
	7457,
	6954,
	8724,
	7199,
	7968,
	6176,
	11810,
	7721,
	9752,
	6943,
	8735,
	8227,
	5926,
	9251,
	8985,
	7970,
	9242,
	8241,
	7207,
	8491,
	10266,
	7458,
	8239,
	8727,
	8741,
	8995,
	11302,
	6181,
	9258,
	8992,
	7721,
	9769,
	11548,
	7459,
	10269,
	10290,
	9254,
	9775,
	11035,
	8488,
	10536,
	12071,
	7974,
	10028,
	10533,
	7979,
	10290,
	11037,
	9259,
	11048,
	12589,
	9001,
	10798,
	13863,
	7465,
	11059,
	13344,
	9260,
	11569,
	11560,
	10543,
	11824,
	13868,
	8238,
	12334,
	13359,
	9776,
	12339,
	14890,
	8750,
	12599,
	14115,
	10545,
	13103,
	13106,
	12082,
	12602,
	13606,
	11316,
	13624,
	13864,
	12341,
	14136,
	13356,
	13878,
	13884,
	14122,
	13112,
	14654,
	14632,
	12090,
	14653,
	15405,
	12604,
	15423,
	15659,
	13629,
	15677,
	16187,
	16191,
	5682,
	12822,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	50,
	12820,
	5120,
	0,
	14336,
	13364,
	11569,
	9517,
	8738,
	6689,
	6681,
	4369,
	2579,
	1803,
	770,
	519,
	14851,
	9263,
	10037,
	12828,
	5151,
	5932,
	9741,
	1807,
	2593,
	11779,
	2056,
	8210,
	7441,
	6954,
	9494,
	4119,
	3866,
	4864,
	13316,
	13364,
	11563,
	9519,
	10277,
	12849,
	9780,
	12069,
	6174,
	5927,
	7951,
	2581,
	3096,
	3077,
	12090,
	13092,
	6693,
	7473,
	10003,
	2834,
	2593,
	6917,
	259,
	9276,
	13867,
	9501,
	5936,
	10784,
	6673,
	3108,
	5142,
	4104,
	2866,
	10251,
	1285,
	285,
	4865,
	0,
	11573,
	12837,
	7462,
	0,
	16128,
	0,
	16191,
	12863,
	5120,
	50,
	12820,
	5120,
	50,
	13844,
	13878,
	12077,
	8241,
	10527,
	5917,
	5925,
	7698,
	2865,
	9995,
	1285,
	285,
	16129,
	16191
};

uint32 *sec4_compacts = (uint32*)data_4;

uint16 sc36_col_talk2[] = {
	63*64,
	63*64,
	219,
	226,
	0,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	0,
	219,
	226,
	0,
	219,
	226,
	4,
	219,
	226,
	4,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	4,
	219,
	226,
	4,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	4,
	219,
	226,
	4,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	4,
	219,
	226,
	4,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	0,
	219,
	226,
	0,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	0,
	0
};

uint16 sc42_judge_point[] = {
	164*64,
	164*64,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	6,
	269,
	186,
	3,
	269,
	186,
	2,
	269,
	186,
	7,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	9,
	269,
	186,
	9,
	269,
	186,
	10,
	269,
	186,
	10,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	10,
	269,
	186,
	10,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	9,
	269,
	186,
	9,
	269,
	186,
	11,
	269,
	186,
	11,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	12,
	269,
	186,
	12,
	269,
	186,
	11,
	269,
	186,
	11,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	9,
	269,
	186,
	9,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	10,
	269,
	186,
	10,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	9,
	269,
	186,
	9,
	269,
	186,
	8,
	269,
	186,
	8,
	269,
	186,
	9,
	269,
	186,
	9,
	269,
	186,
	8,
	269,
	186,
	8,
	0
};

uint16 sc30_floor_table[] = {
	ID_SC30_FLOOR,
	RET_OK,
	ID_SC30_EXIT_31,
	GT_SC30_EXIT_31,
	0,
	SC30_EXIT_31_WALK_ON,
	ID_SC30_EXIT_33,
	GT_SC30_EXIT_33,
	1,
	SC30_EXIT_33_WALK_ON,
	ID_SC30_EXIT_36,
	GT_SC30_EXIT_36,
	3,
	SC30_EXIT_36_WALK_ON,
	ID_SC30_COURT_DOOR,
	GT_SC30_COURT_DOOR,
	4,
	SC30_COURT_DOOR_WALK_ON,
	ID_SC30_NOTICE,
	GT_SC30_NOTICE,
	ID_SC30_STATUE_1,
	GT_SC30_STATUE_1,
	ID_SC30_STATUE_2,
	GT_SC30_STATUE_2,
	ID_SC30_HENRI,
	GT_SC30_HENRI,
	ID_STD_LEFT_TALK,
	GT_SC30_LEFT_TALK,
	ID_STD_RIGHT_TALK,
	GT_SC30_RIGHT_TALK,
	ID_JOEY_PARK,
	GT_DANI_WAIT,
	65535
};

Compact sc30_floor = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	30,	// screen
	0,	// place
	sc30_floor_table,	// getToTable
	184,	// xcood
	240,	// ycood
	0,	// frame
	0,	// cursorText
	0,	// mouseOn
	0,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	447-184,	// mouseSize_x
	327-240,	// mouseSize_y
	FLOOR_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 reset_33_30[] = {
	C_SCREEN,
	30,
	C_PLACE,
	ID_SC30_FLOOR,
	C_XCOOD,
	OFF_RIGHT,
	C_YCOOD,
	312,
	65535
};

uint16 sc30_hen_step_b[] = {
	89*64,
	1,
	1,
	0,
	1,
	1,
	1,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	3,
	0
};

uint16 sc42_pros_talk[] = {
	152*64,
	152*64,
	197,
	277,
	0,
	197,
	277,
	0,
	197,
	277,
	1,
	197,
	277,
	1,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	1,
	197,
	277,
	1,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	3,
	197,
	277,
	3,
	197,
	277,
	3,
	197,
	277,
	0,
	197,
	277,
	0,
	197,
	277,
	2,
	197,
	277,
	4,
	197,
	277,
	4,
	197,
	277,
	2,
	197,
	277,
	1,
	197,
	277,
	1,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	3,
	197,
	277,
	3,
	197,
	277,
	1,
	197,
	277,
	0,
	197,
	277,
	0,
	197,
	277,
	3,
	197,
	277,
	3,
	197,
	277,
	1,
	197,
	277,
	1,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	4,
	197,
	277,
	4,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	1,
	197,
	277,
	1,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	4,
	197,
	277,
	4,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	1,
	197,
	277,
	1,
	197,
	277,
	1,
	197,
	277,
	1,
	197,
	277,
	3,
	197,
	277,
	3,
	197,
	277,
	2,
	197,
	277,
	4,
	197,
	277,
	2,
	197,
	277,
	1,
	197,
	277,
	3,
	197,
	277,
	3,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	2,
	197,
	277,
	2,
	0
};

uint16 sc36_col_talk1[] = {
	62*64,
	62*64,
	219,
	226,
	0,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	4,
	219,
	226,
	1,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	0,
	219,
	226,
	0,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	5,
	219,
	226,
	5,
	219,
	226,
	4,
	219,
	226,
	4,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	0,
	219,
	226,
	0,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	0,
	219,
	226,
	0,
	219,
	226,
	2,
	219,
	226,
	2,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	4,
	219,
	226,
	1,
	219,
	226,
	1,
	219,
	226,
	3,
	219,
	226,
	3,
	219,
	226,
	3,
	0
};

uint16 sc30_fast_list[] = {
	12+DISK_12,
	51+DISK_12,
	52+DISK_12,
	53+DISK_12,
	54+DISK_12,
	135+DISK_12,
	IT_SC30_HENRI_BLINK+DISK_12,
	0
};

uint16 sc30_chip_list[] = {
	IT_SC30_LAYER_0+DISK_12,
	IT_SC30_LAYER_1+DISK_12,
	IT_SC30_LAYER_2+DISK_12,
	IT_SC30_GRID_1+DISK_12,
	IT_SC30_GRID_2+DISK_12,
	IT_DANIELLE+DISK_12,
	IT_DANI_CONV+DISK_12,
	IT_SPUNKY+DISK_12,
	IT_SNIFF_LEFT+DISK_12,
	IT_PISS_LEFT+DISK_12,
	IT_SC30_HENRI_TALK+DISK_12,
	IT_SC30_HENRI_TIE+DISK_12,
	IT_SC30_HENRI_STEP+DISK_12,
	IT_SC30_COURT_DOOR+DISK_12,
	IT_SC30_PUSH_DOOR+DISK_12,
	0
};

uint16 sc30_logic_list[] = {
	ID_FOSTER,
	ID_DANIELLE,
	ID_SPUNKY,
	ID_DOG_BARK_THING,
	ID_SC30_HENRI,
	ID_SC30_COURT_DOOR,
	ID_SC32_LIFT,
	0XFFFF,
	ID_STD_MENU_LOGIC
};

uint16 sc30_mouse_list[] = {
	ID_SC30_HENRI,
	ID_SPUNKY,
	ID_DANIELLE,
	ID_SC30_NOTICE,
	ID_SC30_STATUE_1,
	ID_SC30_STATUE_2,
	ID_SC30_EXIT_31,
	ID_SC30_EXIT_33,
	ID_SC30_EXIT_36,
	ID_SC30_COURT_DOOR,
	ID_SC30_FLOOR,
	0XFFFF,
	ID_TEXT_MOUSE
};

uint32 *sc30_walk_grid = (uint32*)sc30_joey_list;

Compact sc30_exit_31 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	30,	// screen
	0,	// place
	0,	// getToTable
	420,	// xcood
	190,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	447-420,	// mouseSize_x
	256-190,	// mouseSize_y
	SC30_EXIT_31_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact sc30_exit_33 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	30,	// screen
	0,	// place
	0,	// getToTable
	420,	// xcood
	270,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_RIGHT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	447-420,	// mouseSize_x
	327-270,	// mouseSize_y
	SC30_EXIT_33_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

uint16 reset_31_30[] = {
	C_SCREEN,
	30,
	C_PLACE,
	ID_SC30_FLOOR,
	C_XCOOD,
	OFF_RIGHT,
	C_YCOOD,
	248,
	65535
};

Compact sc30_court_door = {
	L_SCRIPT,	// logic
	ST_MOUSE+ST_BACKGROUND,	// status
	0,	// sync
	30,	// screen
	0,	// place
	0,	// getToTable
	167,	// xcood
	210,	// ycood
	3+134*64,	// frame
	181,	// cursorText
	SC30_COURT_DOOR_MOUSE_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	(int16) 65535,	// mouseRel_x
	(int16) 65532,	// mouseRel_y
	179-166,	// mouseSize_x
	265-206,	// mouseSize_y
	SC30_COURT_DOOR_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC30_COURT_DOOR_LOGIC,	// baseSub
	0,	// baseSub_off
	0
};

Compact sc30_notice = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	30,	// screen
	0,	// place
	0,	// getToTable
	169,	// xcood
	218,	// ycood
	0,	// frame
	52,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	174-169,	// mouseSize_x
	227-218,	// mouseSize_y
	SC30_NOTICE_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact sc30_statue_1 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	30,	// screen
	0,	// place
	0,	// getToTable
	206,	// xcood
	215,	// ycood
	0,	// frame
	16620,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	220-206,	// mouseSize_x
	244-215,	// mouseSize_y
	SC30_STATUE_1_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact sc30_statue_2 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	30,	// screen
	0,	// place
	0,	// getToTable
	330,	// xcood
	220,	// ycood
	0,	// frame
	16620,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	360-330,	// mouseSize_x
	249-220,	// mouseSize_y
	SC30_STATUE_2_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

Compact sc30_exit_36 = {
	0,	// logic
	ST_MOUSE,	// status
	0,	// sync
	30,	// screen
	0,	// place
	0,	// getToTable
	280,	// xcood
	231,	// ycood
	0,	// frame
	1+T7,	// cursorText
	STD_EXIT_LEFT_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	0,	// mouseRel_x
	0,	// mouseRel_y
	288-280,	// mouseSize_x
	290-231,	// mouseSize_y
	SC30_EXIT_36_ACTION,	// actionScript
	0,
	0,
	0,
	0,
	0,
	{ 0, 0, 0 },
	0,
	0,
	0,
	0,
	0
};

ExtCompact sc30_henri_ext = {
	0,	// actionSub
	0,	// actionSub_off
	0,	// getToSub
	0,	// getToSub_off
	0,	// extraSub
	0,	// extraSub_off
	0,	// dir
	0,	// stopScript
	0,	// miniBump
	0,	// leaving
	0,	// atWatch
	0,	// atWas
	0,	// alt
	0,	// request
	96+32,	// spWidth_xx
	SP_COL_HENRI30,	// spColour
	0,	// spTextId
	0,	// spTime
	0,	// arAnimIndex
	0,	// turnProg
	0,	// waitingFor
	0,	// arTarget_x
	0,	// arTarget_y
	0,	// animScratch
	0,	// megaSet
	0,
	0,
	0,
	0
};

Compact sc30_henri = {
	L_SCRIPT,	// logic
	ST_MOUSE+ST_LOGIC+ST_SORT+ST_RECREATE,	// status
	0,	// sync
	30,	// screen
	0,	// place
	0,	// getToTable
	284,	// xcood
	228,	// ycood
	3+89*64,	// frame
	16615,	// cursorText
	STD_ON,	// mouseOn
	STD_OFF,	// mouseOff
	ADVISOR_188,	// mouseClick
	5,	// mouseRel_x
	0,	// mouseRel_y
	311-289,	// mouseSize_x
	281-228,	// mouseSize_y
	SC30_HENRI_ACTION,	// actionScript
	0,	// upFlag
	0,	// downFlag
	0,	// getToFlag
	0,	// flag
	0,	// mood
	{ 0, 0, 0 },
	0,	// offset
	C_BASE_MODE,	// mode
	SC30_HENRI_LOGIC,	// baseSub
	0,	// baseSub_off
	&sc30_henri_ext
};

uint16 sc30_henri_talk[] = {
	87*64,
	87*64,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	2,
	284,
	228,
	2,
	284,
	228,
	3,
	284,
	228,
	3,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	3,
	284,
	228,
	3,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	2,
	284,
	228,
	2,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	4,
	284,
	228,
	4,
	284,
	228,
	3,
	284,
	228,
	3,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	4,
	284,
	228,
	4,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	3,
	284,
	228,
	3,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	2,
	284,
	228,
	2,
	284,
	228,
	3,
	284,
	228,
	3,
	284,
	228,
	4,
	284,
	228,
	4,
	284,
	228,
	2,
	284,
	228,
	2,
	284,
	228,
	3,
	284,
	228,
	3,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	4,
	284,
	228,
	4,
	284,
	228,
	1,
	284,
	228,
	1,
	0
};

uint16 sc30_henri_tie[] = {
	88*64,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	2,
	284,
	228,
	2,
	284,
	228,
	3,
	284,
	228,
	3,
	284,
	228,
	4,
	284,
	228,
	4,
	284,
	228,
	5,
	284,
	228,
	5,
	284,
	228,
	6,
	284,
	228,
	6,
	284,
	228,
	3,
	284,
	228,
	3,
	284,
	228,
	2,
	284,
	228,
	2,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	0,
	284,
	228,
	0,
	284,
	228,
	7,
	284,
	228,
	7,
	0
};

uint16 sc30_hen_step_f[] = {
	89*64,
	1,
	1,
	3,
	1,
	1,
	2,
	1,
	1,
	2,
	1,
	1,
	1,
	1,
	1,
	0,
	0
};

uint16 sc30_hen_blink[] = {
	90*64,
	284,
	228,
	0,
	284,
	228,
	1,
	284,
	228,
	1,
	284,
	228,
	0,
	1,
	1,
	3+89*64,
	0
};

uint16 sc30_push_door[] = {
	91*64,
	162,
	208,
	0,
	162,
	208,
	1,
	162,
	208,
	2,
	162,
	208,
	3,
	162,
	208,
	4,
	162,
	208,
	4,
	162,
	208,
	4,
	162,
	208,
	4,
	162,
	208,
	3,
	162,
	208,
	2,
	162,
	208,
	1,
	162,
	208,
	5,
	0
};

uint16 reset_36_30[] = {
	C_SCREEN,
	30,
	C_PLACE,
	ID_SC30_FLOOR,
	C_XCOOD,
	264,
	C_YCOOD,
	288,
	C_FRAME,
	46+12*64,
	C_DIR,
	RIGHT,
	65535
};

uint16 sc30_joey_list[] = {
	184,
	415,
	240,
	327,
	1,
	232,
	343,
	272,
	327,
	0,
	0
};

uint16 dani_conv[] = {
	85*64,
	85*64,
	272,
	189,
	0,
	272,
	189,
	1,
	272,
	189,
	1,
	272,
	189,
	2,
	272,
	189,
	3,
	272,
	189,
	3,
	272,
	189,
	1,
	272,
	189,
	1,
	272,
	189,
	2,
	272,
	189,
	2,
	272,
	189,
	0,
	272,
	189,
	0,
	272,
	189,
	1,
	272,
	189,
	1,
	272,
	189,
	2,
	272,
	189,
	2,
	272,
	189,
	0,
	272,
	189,
	3,
	272,
	189,
	3,
	272,
	189,
	1,
	272,
	189,
	4,
	272,
	189,
	4,
	272,
	189,
	5,
	272,
	189,
	5,
	272,
	189,
	6,
	272,
	189,
	6,
	272,
	189,
	0,
	272,
	189,
	0,
	272,
	189,
	2,
	272,
	189,
	2,
	272,
	189,
	1,
	272,
	189,
	1,
	272,
	189,
	2,
	272,
	189,
	6,
	272,
	189,
	6,
	272,
	189,
	1,
	272,
	189,
	1,
	272,
	189,
	6,
	272,
	189,
	1,
	272,
	189,
	0,
	272,
	189,
	2,
	272,
	189,
	1,
	272,
	189,
	4,
	272,
	189,
	4,
	272,
	189,
	3,
	272,
	189,
	3,
	272,
	189,
	6,
	272,
	189,
	6,
	272,
	189,
	0,
	272,
	189,
	0,
	272,
	189,
	2,
	272,
	189,
	2,
	272,
	189,
	1,
	272,
	189,
	1,
	272,
	189,
	3,
	272,
	189,
	3,
	272,
	189,
	0,
	272,
	189,
	0,
	272,
	189,
	6,
	272,
	189,
	6,
	272,
	189,
	1,
	272,
	189,
	1,
	272,
	189,
	0,
	272,
	189,
	0,
	0
};

uint16 sc38_dani_sattlk[] = {
	108*64,
	108*64,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	1,
	294,
	244,
	1,
	294,
	244,
	1,
	294,
	244,
	1,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	2,
	294,
	244,
	2,
	294,
	244,
	3,
	294,
	244,
	3,
	294,
	244,
	1,
	294,
	244,
	1,
	294,
	244,
	2,
	294,
	244,
	2,
	294,
	244,
	3,
	294,
	244,
	3,
	294,
	244,
	1,
	294,
	244,
	1,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	3,
	294,
	244,
	3,
	294,
	244,
	4,
	294,
	244,
	4,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	1,
	294,
	244,
	1,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	2,
	294,
	244,
	2,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	2,
	294,
	244,
	2,
	294,
	244,
	3,
	294,
	244,
	3,
	294,
	244,
	4,
	294,
	244,
	4,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	2,
	294,
	244,
	2,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	1,
	294,
	244,
	1,
	294,
	244,
	3,
	294,
	244,
	3,
	294,
	244,
	0,
	294,
	244,
	0,
	294,
	244,
	2,
	294,
	244,
	2,
	294,
	244,
	2,
	294,
	244,
	2,
	294,
	244,
	4,
	294,
	244,
	4,
	0
};

uint16 sc31_guard_talk[] = {
	101*64,
	101*64,
	328,
	176,
	0,
	328,
	176,
	0,
	328,
	176,
	1,
	328,
	176,
	1,
	328,
	176,
	2,
	328,
	176,
	2,
	328,
	176,
	3,
	328,
	176,
	3,
	328,
	176,
	2,
	328,
	176,
	2,
	328,
	176,
	0,
	328,
	176,
	0,
	328,
	176,
	4,
	328,
	176,
	4,
	328,
	176,
	3,
	328,
	176,
	3,
	328,
	176,
	0,
	328,
	176,
	0,
	328,
	176,
	1,
	328,
	176,
	1,
	328,
	176,
	2,
	328,
	176,
	2,
	328,
	176,
	3,
	328,
	176,
	3,
	328,
	176,
	5,
	328,
	176,
	5,
	328,
	176,
	3,
	328,
	176,
	3,
	328,
	176,
	0,
	328,
	176,
	0,
	328,
	176,
	2,
	328,
	176,
	2,
	328,
	176,
	4,
	328,
	176,
	4,
	328,
	176,
	1,
	328,
	176,
	1,
	328,
	176,
	2,
	328,
	176,
	2,
	328,
	176,
	0,
	328,
	176,
	0,
	328,
	176,
	4,
	328,
	176,
	4,
	328,
	176,
	2,
	328,
	176,
	2,
	328,
	176,
	3,
	328,
	176,
	3,
	328,
	176,
	5,
	328,
	176,
	5,
	328,
	176,
	0,
	328,
	176,
	0,
	328,
	176,
	1,
	328,
	176,
	1,
	328,
	176,
	4,
	328,
	176,
	4,
	328,
	176,
	2,
	328,
	176,
	2,
	328,
	176,
	3,
	328,
	176,
	3,
	328,
	176,
	5,
	328,
	176,
	5,
	328,
	176,
	0,
	328,
	176,
	0,
	328,
	176,
	4,
	328,
	176,
	4,
	0
};

uint16 sc38_phone_talk[] = {
	131*64,
	131*64,
	160,
	256,
	0,
	160,
	256,
	0,
	160,
	256,
	1,
	160,
	256,
	1,
	160,
	256,
	2,
	160,
	256,
	2,
	160,
	256,
	0,
	160,
	256,
	0,
	160,
	256,
	3,
	160,
	256,
	3,
	160,
	256,
	4,
	160,
	256,
	4,
	160,
	256,
	5,
	160,
	256,
	5,
	160,
	256,
	6,
	160,
	256,
	6,
	160,
	256,
	0,
	160,
	256,
	0,
	160,
	256,
	1,
	160,
	256,
	1,
	160,
	256,
	2,
	160,
	256,
	2,
	160,
	256,
	0,
	160,
	256,
	0,
	160,
	256,
	5,
	160,
	256,
	5,
	160,
	256,
	3,
	160,
	256,
	3,
	160,
	256,
	4,
	160,
	256,
	4,
	160,
	256,
	5,
	160,
	256,
	5,
	160,
	256,
	6,
	160,
	256,
	6,
	160,
	256,
	0,
	160,
	256,
	0,
	160,
	256,
	1,
	160,
	256,
	1,
	160,
	256,
	2,
	160,
	256,
	2,
	160,
	256,
	0,
	160,
	256,
	0,
	160,
	256,
	3,
	160,
	256,
	3,
	160,
	256,
	5,
	160,
	256,
	5,
	160,
	256,
	6,
	160,
	256,
	6,
	160,
	256,
	6,
	160,
	256,
	6,
	160,
	256,
	0,
	160,
	256,
	0,
	160,
	256,
	1,
	160,
	256,
	1,
	160,
	256,
	0,
	160,
	256,
	0,
	160,
	256,
	3,
	160,
	256,
	3,
	160,
	256,
	4,
	160,
	256,
	4,
	160,
	256,
	5,
	160,
	256,
	5,
	160,
	256,
	6,
	160,
	256,
	6,
	0
};

uint16 sc32_garden_talk[] = {
	60*64,
	60*64,
	269,
	169,
	0,
	269,
	169,
	0,
	269,
	169,
	1,
	269,
	169,
	1,
	269,
	169,
	0,
	269,
	169,
	0,
	269,
	169,
	2,
	269,
	169,
	2,
	269,
	169,
	3,
	269,
	169,
	3,
	269,
	169,
	4,
	269,
	169,
	4,
	269,
	169,
	5,
	269,
	169,
	5,
	269,
	169,
	0,
	269,
	169,
	6,
	269,
	169,
	6,
	269,
	169,
	6,
	269,
	169,
	7,
	269,
	169,
	7,
	269,
	169,
	8,
	269,
	169,
	8,
	269,
	169,
	9,
	269,
	169,
	9,
	269,
	169,
	10,
	269,
	169,
	10,
	269,
	169,
	0,
	269,
	169,
	0,
	269,
	169,
	11,
	269,
	169,
	11,
	269,
	169,
	12,
	269,
	169,
	12,
	269,
	169,
	3,
	269,
	169,
	3,
	269,
	169,
	4,
	269,
	169,
	4,
	269,
	169,
	5,
	269,
	169,
	5,
	269,
	169,
	0,
	269,
	169,
	6,
	269,
	169,
	6,
	269,
	169,
	7,
	269,
	169,
	7,
	269,
	169,
	8,
	269,
	169,
	8,
	269,
	169,
	9,
	269,
	169,
	9,
	269,
	169,
	10,
	269,
	169,
	10,
	269,
	169,
	0,
	269,
	169,
	12,
	269,
	169,
	12,
	269,
	169,
	13,
	269,
	169,
	13,
	269,
	169,
	0,
	269,
	169,
	0,
	269,
	169,
	0,
	269,
	169,
	0,
	269,
	169,
	2,
	269,
	169,
	2,
	269,
	169,
	3,
	269,
	169,
	3,
	269,
	169,
	4,
	269,
	169,
	0,
	0
};

uint16 sc31_guard_talk2[] = {
	131*64,
	131*64,
	328,
	242,
	0,
	328,
	242,
	0,
	328,
	242,
	1,
	328,
	242,
	1,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	3,
	328,
	242,
	3,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	4,
	328,
	242,
	4,
	328,
	242,
	0,
	328,
	242,
	0,
	328,
	242,
	1,
	328,
	242,
	1,
	328,
	242,
	4,
	328,
	242,
	4,
	328,
	242,
	5,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	3,
	328,
	242,
	3,
	328,
	242,
	6,
	328,
	242,
	6,
	328,
	242,
	3,
	328,
	242,
	3,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	1,
	328,
	242,
	1,
	328,
	242,
	0,
	328,
	242,
	0,
	328,
	242,
	1,
	328,
	242,
	1,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	3,
	328,
	242,
	3,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	4,
	328,
	242,
	4,
	328,
	242,
	0,
	328,
	242,
	0,
	328,
	242,
	1,
	328,
	242,
	1,
	328,
	242,
	4,
	328,
	242,
	4,
	328,
	242,
	5,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	3,
	328,
	242,
	3,
	328,
	242,
	6,
	328,
	242,
	6,
	328,
	242,
	3,
	328,
	242,
	3,
	328,
	242,
	2,
	328,
	242,
	2,
	328,
	242,
	1,
	328,
	242,
	1,
	0
};

uint16 barman_talk[] = {
	61*64,
	61*64,
	391,
	240,
	0,
	391,
	240,
	1,
	391,
	240,
	2,
	391,
	240,
	2,
	391,
	240,
	3,
	391,
	240,
	3,
	391,
	240,
	4,
	391,
	240,
	1,
	391,
	240,
	0,
	391,
	240,
	0,
	391,
	240,
	4,
	391,
	240,
	4,
	391,
	240,
	1,
	391,
	240,
	1,
	391,
	240,
	3,
	391,
	240,
	3,
	391,
	240,
	4,
	391,
	240,
	4,
	391,
	240,
	3,
	391,
	240,
	3,
	391,
	240,
	0,
	391,
	240,
	0,
	391,
	240,
	4,
	391,
	240,
	3,
	391,
	240,
	0,
	391,
	240,
	0,
	391,
	240,
	4,
	391,
	240,
	4,
	391,
	240,
	1,
	391,
	240,
	1,
	391,
	240,
	0,
	391,
	240,
	0,
	391,
	240,
	3,
	391,
	240,
	3,
	391,
	240,
	2,
	391,
	240,
	2,
	391,
	240,
	0,
	391,
	240,
	0,
	391,
	240,
	3,
	391,
	240,
	3,
	391,
	240,
	4,
	391,
	240,
	4,
	391,
	240,
	2,
	391,
	240,
	2,
	391,
	240,
	0,
	391,
	240,
	0,
	391,
	240,
	3,
	391,
	240,
	3,
	391,
	240,
	0,
	391,
	240,
	0,
	391,
	240,
	1,
	391,
	240,
	1,
	391,
	240,
	2,
	391,
	240,
	2,
	391,
	240,
	0,
	391,
	240,
	0,
	391,
	240,
	4,
	391,
	240,
	4,
	391,
	240,
	2,
	391,
	240,
	2,
	391,
	240,
	1,
	391,
	240,
	1,
	391,
	240,
	0,
	391,
	240,
	0,
	0
};

uint16 sc36_gal_talk[] = {
	64*64,
	64*64,
	202,
	238,
	0,
	202,
	238,
	1,
	202,
	238,
	1,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	0,
	202,
	238,
	0,
	202,
	238,
	3,
	202,
	238,
	3,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	4,
	202,
	238,
	4,
	202,
	238,
	4,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	0,
	202,
	238,
	0,
	202,
	238,
	1,
	202,
	238,
	1,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	0,
	202,
	238,
	0,
	202,
	238,
	1,
	202,
	238,
	1,
	202,
	238,
	4,
	202,
	238,
	4,
	202,
	238,
	0,
	202,
	238,
	0,
	202,
	238,
	3,
	202,
	238,
	3,
	202,
	238,
	1,
	202,
	238,
	1,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	0,
	202,
	238,
	0,
	202,
	238,
	2,
	202,
	238,
	2,
	202,
	238,
	4,
	202,
	238,
	4,
	202,
	238,
	0,
	0
};

uint16 sc36_juke_talk[] = {
	86*64,
	86*64,
	233,
	222,
	0,
	233,
	222,
	1,
	233,
	222,
	2,
	233,
	222,
	3,
	233,
	222,
	4,
	233,
	222,
	5,
	233,
	222,
	0,
	233,
	222,
	3,
	233,
	222,
	4,
	233,
	222,
	0,
	233,
	222,
	6,
	233,
	222,
	0,
	233,
	222,
	3,
	233,
	222,
	6,
	233,
	222,
	5,
	233,
	222,
	7,
	233,
	222,
	6,
	233,
	222,
	0,
	233,
	222,
	7,
	233,
	222,
	4,
	233,
	222,
	2,
	233,
	222,
	5,
	233,
	222,
	3,
	233,
	222,
	7,
	233,
	222,
	4,
	233,
	222,
	2,
	233,
	222,
	0,
	233,
	222,
	3,
	233,
	222,
	7,
	233,
	222,
	1,
	233,
	222,
	6,
	233,
	222,
	5,
	233,
	222,
	0,
	233,
	222,
	3,
	233,
	222,
	1,
	233,
	222,
	6,
	233,
	222,
	5,
	233,
	222,
	7,
	233,
	222,
	4,
	233,
	222,
	6,
	233,
	222,
	2,
	233,
	222,
	5,
	233,
	222,
	0,
	233,
	222,
	3,
	233,
	222,
	7,
	233,
	222,
	4,
	233,
	222,
	5,
	233,
	222,
	3,
	233,
	222,
	7,
	233,
	222,
	1,
	233,
	222,
	6,
	233,
	222,
	5,
	233,
	222,
	0,
	233,
	222,
	1,
	233,
	222,
	6,
	233,
	222,
	5,
	233,
	222,
	3,
	233,
	222,
	1,
	233,
	222,
	4,
	233,
	222,
	6,
	233,
	222,
	2,
	233,
	222,
	6,
	233,
	222,
	5,
	233,
	222,
	3,
	0
};

uint16 sc36_babs_talk[] = {
	107*64,
	107*64,
	216,
	206,
	0,
	216,
	206,
	1,
	216,
	206,
	1,
	216,
	206,
	1,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	2,
	216,
	206,
	2,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	3,
	216,
	206,
	3,
	216,
	206,
	4,
	216,
	206,
	4,
	216,
	206,
	3,
	216,
	206,
	3,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	3,
	216,
	206,
	4,
	216,
	206,
	3,
	216,
	206,
	3,
	216,
	206,
	0,
	216,
	206,
	1,
	216,
	206,
	1,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	2,
	216,
	206,
	2,
	216,
	206,
	1,
	216,
	206,
	0,
	216,
	206,
	1,
	216,
	206,
	1,
	216,
	206,
	3,
	216,
	206,
	4,
	216,
	206,
	2,
	216,
	206,
	2,
	216,
	206,
	1,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	1,
	216,
	206,
	1,
	216,
	206,
	0,
	216,
	206,
	2,
	216,
	206,
	2,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	1,
	216,
	206,
	1,
	216,
	206,
	2,
	216,
	206,
	2,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	1,
	216,
	206,
	2,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	0,
	216,
	206,
	0,
	0
};

uint16 reset_42_30[] = {
	C_SCREEN,
	30,
	C_PLACE,
	ID_SC30_FLOOR,
	C_XCOOD,
	144,
	C_YCOOD,
	256,
	65535
};

uint16 reset_court_open[] = {
	C_STATUS,
	ST_LOGIC+ST_MOUSE+ST_RECREATE,
	C_CURSOR_TEXT,
	1+T7,
	65535
};

uint16 sc30_court_close[] = {
	134*64,
	167,
	210,
	0,
	167,
	210,
	1,
	167,
	210,
	2,
	167,
	210,
	3,
	0
};

uint16 sc42_judge_talk[] = {
	150*64,
	150*64,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	3,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	3,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	0
};

uint16 sc42_jobs_talk[] = {
	153*64,
	153*64,
	340,
	200,
	0,
	340,
	200,
	1,
	340,
	200,
	2,
	340,
	200,
	2,
	340,
	200,
	3,
	340,
	200,
	3,
	340,
	200,
	0,
	340,
	200,
	2,
	340,
	200,
	2,
	340,
	200,
	0,
	340,
	200,
	4,
	340,
	200,
	1,
	340,
	200,
	1,
	340,
	200,
	0,
	340,
	200,
	3,
	340,
	200,
	4,
	340,
	200,
	4,
	340,
	200,
	1,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	2,
	340,
	200,
	1,
	340,
	200,
	1,
	340,
	200,
	3,
	340,
	200,
	4,
	340,
	200,
	2,
	340,
	200,
	1,
	340,
	200,
	1,
	340,
	200,
	0,
	340,
	200,
	2,
	340,
	200,
	2,
	340,
	200,
	1,
	340,
	200,
	3,
	340,
	200,
	4,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	4,
	340,
	200,
	4,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	4,
	340,
	200,
	4,
	340,
	200,
	2,
	340,
	200,
	2,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	1,
	340,
	200,
	1,
	340,
	200,
	3,
	340,
	200,
	3,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	1,
	340,
	200,
	1,
	340,
	200,
	0,
	340,
	200,
	0,
	0
};

uint16 sc42_blunt_talk[] = {
	156*64,
	156*64,
	232,
	224,
	0,
	232,
	224,
	1,
	232,
	224,
	1,
	232,
	224,
	2,
	232,
	224,
	2,
	232,
	224,
	3,
	232,
	224,
	3,
	232,
	224,
	4,
	232,
	224,
	4,
	232,
	224,
	5,
	232,
	224,
	5,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	1,
	232,
	224,
	1,
	232,
	224,
	2,
	232,
	224,
	2,
	232,
	224,
	3,
	232,
	224,
	3,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	4,
	232,
	224,
	4,
	232,
	224,
	5,
	232,
	224,
	5,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	6,
	232,
	224,
	6,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	2,
	232,
	224,
	2,
	232,
	224,
	3,
	232,
	224,
	3,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	4,
	232,
	224,
	4,
	232,
	224,
	5,
	232,
	224,
	5,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	2,
	232,
	224,
	2,
	232,
	224,
	7,
	232,
	224,
	7,
	232,
	224,
	3,
	232,
	224,
	3,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	232,
	224,
	0,
	0
};

uint16 sc42_fos_talk_l[] = {
	159*64,
	159*64,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	3,
	324,
	279,
	2,
	324,
	279,
	4,
	324,
	279,
	5,
	324,
	279,
	4,
	324,
	279,
	4,
	324,
	279,
	4,
	324,
	279,
	4,
	324,
	279,
	6,
	324,
	279,
	2,
	324,
	279,
	7,
	324,
	279,
	7,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	2,
	324,
	279,
	0,
	324,
	279,
	8,
	324,
	279,
	8,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	8,
	324,
	279,
	8,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	6,
	324,
	279,
	6,
	324,
	279,
	6,
	324,
	279,
	6,
	324,
	279,
	4,
	324,
	279,
	4,
	324,
	279,
	5,
	324,
	279,
	4,
	324,
	279,
	9,
	324,
	279,
	10,
	324,
	279,
	6,
	324,
	279,
	7,
	324,
	279,
	2,
	324,
	279,
	3,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	2,
	0
};

uint16 sc42_fos_talk_r[] = {
	160*64,
	160*64,
	324,
	279,
	0,
	324,
	279,
	0,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	2,
	324,
	279,
	2,
	324,
	279,
	4,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	5,
	324,
	279,
	5,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	5,
	324,
	279,
	5,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	2,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	1,
	324,
	279,
	6,
	324,
	279,
	6,
	324,
	279,
	7,
	324,
	279,
	5,
	324,
	279,
	3,
	324,
	279,
	6,
	324,
	279,
	6,
	324,
	279,
	3,
	324,
	279,
	3,
	324,
	279,
	1,
	324,
	279,
	2,
	324,
	279,
	2,
	0
};

uint16 sc42_dani_talk[] = {
	162*64,
	162*64,
	280,
	209,
	0,
	280,
	209,
	0,
	280,
	209,
	1,
	280,
	209,
	1,
	280,
	209,
	2,
	280,
	209,
	2,
	280,
	209,
	3,
	280,
	209,
	3,
	280,
	209,
	2,
	280,
	209,
	2,
	280,
	209,
	4,
	280,
	209,
	4,
	280,
	209,
	3,
	280,
	209,
	3,
	280,
	209,
	5,
	280,
	209,
	6,
	280,
	209,
	7,
	280,
	209,
	7,
	280,
	209,
	0,
	280,
	209,
	0,
	280,
	209,
	1,
	280,
	209,
	1,
	280,
	209,
	2,
	280,
	209,
	2,
	280,
	209,
	0,
	280,
	209,
	0,
	280,
	209,
	8,
	280,
	209,
	8,
	280,
	209,
	1,
	280,
	209,
	1,
	280,
	209,
	2,
	280,
	209,
	2,
	280,
	209,
	3,
	280,
	209,
	3,
	280,
	209,
	0,
	280,
	209,
	0,
	280,
	209,
	7,
	280,
	209,
	7,
	280,
	209,
	0,
	280,
	209,
	0,
	280,
	209,
	1,
	280,
	209,
	1,
	280,
	209,
	4,
	280,
	209,
	4,
	280,
	209,
	0,
	280,
	209,
	0,
	280,
	209,
	7,
	280,
	209,
	7,
	280,
	209,
	8,
	280,
	209,
	8,
	280,
	209,
	1,
	280,
	209,
	1,
	280,
	209,
	4,
	280,
	209,
	4,
	280,
	209,
	3,
	280,
	209,
	3,
	280,
	209,
	7,
	280,
	209,
	7,
	280,
	209,
	0,
	280,
	209,
	5,
	280,
	209,
	9,
	280,
	209,
	2,
	280,
	209,
	0,
	280,
	209,
	0,
	0
};

uint16 sc42_clerk_talk[] = {
	165*64,
	165*64,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	1,
	310,
	234,
	1,
	310,
	234,
	2,
	310,
	234,
	2,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	1,
	310,
	234,
	1,
	310,
	234,
	3,
	310,
	234,
	3,
	310,
	234,
	4,
	310,
	234,
	4,
	310,
	234,
	5,
	310,
	234,
	5,
	310,
	234,
	3,
	310,
	234,
	3,
	310,
	234,
	2,
	310,
	234,
	2,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	3,
	310,
	234,
	3,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	5,
	310,
	234,
	5,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	2,
	310,
	234,
	2,
	310,
	234,
	5,
	310,
	234,
	5,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	2,
	310,
	234,
	2,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	1,
	310,
	234,
	1,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	4,
	310,
	234,
	4,
	310,
	234,
	5,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	1,
	310,
	234,
	1,
	310,
	234,
	0,
	310,
	234,
	0,
	310,
	234,
	2,
	310,
	234,
	2,
	310,
	234,
	4,
	310,
	234,
	4,
	310,
	234,
	5,
	310,
	234,
	5,
	310,
	234,
	0,
	310,
	234,
	0,
	0
};

uint16 sc42_jobs_point[] = {
	166*64,
	166*64,
	340,
	200,
	0,
	340,
	200,
	1,
	340,
	200,
	2,
	340,
	200,
	2,
	340,
	200,
	3,
	340,
	200,
	4,
	340,
	200,
	5,
	340,
	200,
	6,
	340,
	200,
	7,
	340,
	200,
	8,
	340,
	200,
	9,
	340,
	200,
	10,
	340,
	200,
	10,
	340,
	200,
	8,
	340,
	200,
	11,
	340,
	200,
	9,
	340,
	200,
	9,
	340,
	200,
	10,
	340,
	200,
	8,
	340,
	200,
	8,
	340,
	200,
	12,
	340,
	200,
	10,
	340,
	200,
	10,
	340,
	200,
	13,
	340,
	200,
	7,
	340,
	200,
	6,
	340,
	200,
	5,
	340,
	200,
	4,
	340,
	200,
	3,
	340,
	200,
	2,
	340,
	200,
	2,
	340,
	200,
	1,
	340,
	200,
	3,
	340,
	200,
	14,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	14,
	340,
	200,
	14,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	14,
	340,
	200,
	14,
	340,
	200,
	2,
	340,
	200,
	2,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	1,
	340,
	200,
	1,
	340,
	200,
	3,
	340,
	200,
	3,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	0,
	340,
	200,
	1,
	340,
	200,
	1,
	340,
	200,
	0,
	340,
	200,
	0,
	0
};

uint16 sc42_jdg_to_jobs[] = {
	168*64,
	168*64,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	4,
	269,
	186,
	2,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	4,
	269,
	186,
	3,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	5,
	269,
	186,
	1,
	269,
	186,
	0,
	269,
	186,
	3,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	2,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	2,
	269,
	186,
	3,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	0,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	1,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	2,
	269,
	186,
	2,
	269,
	186,
	5,
	269,
	186,
	5,
	269,
	186,
	0,
	269,
	186,
	0,
	269,
	186,
	4,
	269,
	186,
	4,
	269,
	186,
	0,
	269,
	186,
	0,
	0
};

void *data_4[] = {
	0,
	sc30_fast_list,
	sc30_chip_list,
	sc30_logic_list,
	sc30_mouse_list,
	sc30_palette,
	sc30_walk_grid,
	reset_start_31,
	&sc30_floor,
	&sc30_exit_31,
	&sc30_exit_33,
	sc38_dani_anim_1,
	sc31_chip_list,
	sc31_logic_list,
	sc31_mouse_list,
	sc31_palette,
	sc31_walk_grid,
	reset_30_31,
	&sc31_floor,
	&sc31_exit_30,
	sc33_fast_list,
	sc33_chip_list,
	sc33_logic_list,
	sc33_mouse_list,
	sc33_palette,
	sc33_walk_grid,
	reset_30_33,
	&sc33_floor,
	&sc33_exit_30,
	reset_31_30,
	reset_33_30,
	&sc31_exit_32,
	sc32_fast_list,
	sc32_chip_list,
	sc32_logic_list,
	sc32_mouse_list,
	sc32_palette,
	sc32_walk_grid,
	reset_31_32,
	&sc32_floor,
	&sc32_exit_31,
	reset_32_31,
	&sc32_exit_33,
	reset_32_33,
	&sc33_exit_32,
	reset_33_32,
	&sc33_shed_door,
	sc34_fast_list,
	sc34_chip_list,
	sc34_logic_list,
	sc34_mouse_list,
	sc34_palette,
	sc34_walk_grid,
	reset_33_34,
	&sc34_floor,
	&sc34_door,
	reset_34_33,
	&danielle,
	&sc32_lift,
	sc38_fast_list,
	sc38_chip_list,
	sc38_logic_list,
	sc38_mouse_list,
	sc38_palette,
	sc38_walk_grid,
	reset_32_38,
	&sc38_floor,
	&sc38_lift,
	reset_38_32,
	&sc31_exit_39,
	sc39_fast_list,
	sc39_chip_list,
	sc39_logic_list,
	sc39_mouse_list,
	sc39_palette,
	sc39_walk_grid,
	reset_31_39,
	&sc39_floor,
	&sc39_exit_31,
	reset_39_31,
	&sc39_exit_40,
	&sc39_exit_41,
	sc40_fast_list,
	sc40_chip_list,
	sc40_logic_list,
	sc40_mouse_list,
	sc40_palette,
	sc40_walk_grid,
	reset_39_40,
	&sc40_floor,
	&sc40_exit_39,
	reset_40_39,
	sc41_fast_list,
	sc41_chip_list,
	sc41_logic_list,
	sc41_mouse_list,
	sc41_palette,
	sc41_walk_grid,
	reset_39_41,
	&sc41_floor,
	&sc41_exit_39,
	reset_41_39,
	&spunky,
	&sc30_court_door,
	sc38_dani_anim_2,
	&sc30_notice,
	&sc30_statue_1,
	&sc30_statue_2,
	&sc30_exit_36,
	&sc31_lift_slot,
	&sc32_terminal,
	&sc32_buzzer,
	&sc32_plant_1,
	&sc32_plant_2,
	&sc32_plant_3,
	&sc33_lock,
	sc38_dani_anim_3,
	&sc34_secateurs,
	&sc34_tkt_machine,
	&sc34_map,
	&sc34_bricks,
	&sc38_statue,
	&sc38_monitor,
	&sc38_video,
	&sc38_sofa,
	sniff_left,
	sniff_right,
	piss_left,
	piss_right,
	&sc31_lift,
	sc31_lift_open,
	sc31_lift_close,
	&sc30_henri,
	sc30_henri_talk,
	sc30_henri_tie,
	sc30_hen_step_f,
	sc30_hen_step_b,
	sc30_hen_blink,
	sc30_push_door,
	sc31_use_card,
	sc32_use_card,
	sc32_use_com,
	sc33_use_card,
	sc33_push_door1,
	sc33_push_door2,
	sc33_door_open,
	sc36_fast_list,
	sc36_chip_list,
	sc36_logic_list,
	sc36_mouse_list,
	sc36_palette,
	sc36_walk_grid,
	reset_30_36,
	&sc36_floor,
	&sc36_exit_30,
	reset_36_30,
	sc32_lift_open,
	sc32_lift_close,
	sc38_lift_up,
	sc38_lift_down,
	sc34_get_secs,
	sc34_stairs1,
	sc34_stairs2,
	sc30_joey_list,
	sc31_joey_list,
	sc32_joey_list,
	sc33_joey_list,
	sc31_pull_rope,
	sc31_lower_rope,
	sc31_drop_rope,
	&sc31_end_of_rope,
	&sc31_rope,
	sc31_rope_pulled,
	sc31_rope_lower,
	sc31_rope_drop,
	&sc31_bricks,
	sc31_bricks_up,
	sc31_bricks_down,
	sc31_bricks_fall,
	&sc31_plank,
	sc31_plank_drop,
	sc31_plank_raise,
	sc31_plank_flick,
	&sc40_cabinet,
	&sc40_trolley,
	&sc40_locker_1,
	&sc40_locker_2,
	&sc40_locker_3,
	&sc40_locker_4,
	&sc40_locker_5,
	sc40_locker_open,
	sc40_locker_shut,
	&sc40_body_1,
	&sc40_body_2,
	&sc40_body_3,
	&sc40_body_4,
	&sc40_body_5,
	sc40_open_door,
	sc40_close_door,
	&sc36_door,
	sc37_fast_list,
	sc37_chip_list,
	sc37_logic_list,
	sc37_mouse_list,
	sc37_palette,
	sc37_walk_grid,
	reset_36_37,
	&sc37_floor,
	&sc37_door,
	reset_37_36,
	&sc36_sensor,
	&sc37_sensor,
	&sc36_low_floor,
	&sc36_jukebox,
	&sc36_band,
	&sc32_vincent,
	&sc32_gardener,
	&sc31_guard,
	sc32_vinc_anim,
	dani_conv,
	sc38_dani_sattlk,
	sc38_dani_get_up,
	sc32_vinc_talk,
	sc31_guard_talk,
	reset_dani_sit,
	reset_dani_stand,
	&sc38_hand_set,
	&sc38_ringer,
	sc38_ringer_anim,
	sc38_get_phone,
	sc38_phone_talk,
	&sc38_dog_tray,
	reset_spunky_38,
	&sc37_grill,
	&sc38_biscuits,
	&sc37_flimsy_box,
	&sc37_big_box,
	&sc37_lid,
	sc32_gardening1,
	sc32_gardening2,
	sc32_gardener_up,
	sc32_gardener_dn,
	sc32_gard_turn_d,
	sc32_gard_turn_u,
	sc32_garden_talk,
	reset_dani_32,
	reset_spunky_32,
	sc38_use_video,
	sc38_video_anim,
	sc38_screen_1,
	sc38_screen_2,
	sc38_screen_3,
	sc38_screen_4,
	bark,
	sc38_reach_food,
	sc38_get_food,
	sc44_fast_list,
	sc44_chip_list,
	sc44_logic_list,
	sc44_mouse_list,
	sc44_palette,
	sc44_walk_grid,
	reset_37_44,
	reset_45_44,
	&sc44_floor,
	&sc44_exit_45,
	sc45_fast_list,
	sc45_chip_list,
	sc45_logic_list,
	sc45_mouse_list,
	sc45_palette,
	sc45_walk_grid,
	reset_44_45,
	reset_46_45,
	reset_47_45,
	&sc45_floor,
	&sc45_exit_44,
	&sc45_exit_46,
	&sc45_exit_47,
	sc46_fast_list,
	sc46_chip_list,
	sc46_logic_list,
	sc46_mouse_list,
	sc46_palette,
	sc46_walk_grid,
	reset_45_46,
	&sc46_floor,
	&sc46_exit_45,
	sc47_fast_list,
	sc47_chip_list,
	sc47_logic_list,
	sc47_mouse_list,
	sc47_palette,
	sc47_walk_grid,
	reset_45_47,
	reset_48_47,
	&sc47_floor,
	&sc47_exit_45,
	&sc47_exit_48,
	sc31_get_bricks,
	sc31_climb_plank,
	sc31_dog_fly,
	sc36_band_anim,
	sc31_get_plank,
	sc31_put_bisc,
	sc31_bisc_placed,
	sc31_bisc_drop,
	sc31_bisc_raise,
	&sc31_biscuits,
	sc31_guard_blink,
	sc31_guard_move,
	sc31_guard_reach,
	sc31_guard_talk2,
	sc31_dog_rise,
	sc31_dog_swim,
	rs_guard_chat,
	rs_guard_avail,
	&sc36_barman,
	bar_blink,
	bar_get_drink,
	bar_drink,
	bar_get_cloth,
	bar_put_cloth,
	bar_wipe,
	bar_wipe2,
	barman_talk,
	sc48_fast_list,
	sc48_chip_list,
	sc48_logic_list,
	sc48_mouse_list,
	sc48_palette,
	sc48_walk_grid,
	reset_47_48,
	reset_65_48,
	&sc48_floor,
	&sc48_exit_47,
	&sc48_exit_65,
	sc65_fast_list,
	sc65_chip_list,
	sc65_logic_list,
	sc65_mouse_list,
	sc65_palette,
	sc65_walk_grid,
	reset_48_65,
	&sc65_floor,
	&sc65_exit_48,
	&sc65_exit_66,
	&sc36_colston,
	&sc36_col_feet,
	sc36_col_deal,
	sc36_col_think,
	sc36_col_blink1,
	sc36_col_blink2,
	&sc36_gallagher,
	&sc36_gal_legs,
	sc36_gal_deal,
	sc36_gal_look1,
	sc36_gal_look2,
	&sc36_cards,
	sc36_col_talk1,
	sc36_col_talk2,
	sc36_gal_talk,
	sc36_col_drink,
	&sc36_glass,
	sc36_fos_down1,
	sc36_fos_down2,
	sc36_fos_up1,
	sc36_fos_up2,
	sc36_press_plate,
	sc36_use_jukebox,
	sc36_jukebox_on,
	sc36_jukebox_off,
	sc36_juke_talk,
	&sc36_juke_light,
	sc36_juke_kicked,
	sc36_reach_glass,
	sc36_get_glass,
	sc36_col_down1,
	sc36_col_down2,
	sc36_col_down3,
	sc36_col_down4,
	sc36_col_up1,
	sc36_col_up2,
	sc36_col_up3,
	sc36_col_up4,
	sc36_col_kick,
	sc36_juke_stuck,
	sc36_juke_break,
	&sc36_babs,
	sc36_babs_talk,
	sc31_fast_list,
	sc37_crbarbox,
	sc37_getlid,
	sc37_putlid,
	sc37_uselid,
	sc37_stepup,
	sc37_footdrop,
	sc37_stepdown,
	sc37_usebar,
	sc37_usesec,
	sc37_climbout,
	sc37_thumbsup,
	sc37_lidup,
	sc37_liddown,
	sc37_lidused,
	sc37_grillopen,
	sc37_dooropen,
	sc37_doorshut,
	sc36_dooropen,
	sc36_doorshut,
	&sc37_holding_lid,
	&sc44_grill,
	&sc65_poster1,
	&sc65_poster2,
	&sc65_sign,
	&sc37_wine_rack,
	&sc44_rubble,
	&sc46_rubble,
	sc42_fast_list,
	sc42_chip_list,
	sc42_logic_list,
	sc42_mouse_list,
	sc42_palette,
	sc42_walk_grid,
	reset_30_42,
	&sc39_walters,
	sc31_get_board,
	reset_42_30,
	reset_colston,
	reset_court_open,
	sc30_court_close,
	&sc48_socket,
	&sc48_hole,
	&sc48_eyes,
	sc48_eyes_anim,
	sc48_put_bulb,
	sc48_light_pal,
	&sc42_judge,
	&sc42_clerk,
	&sc42_prosecution,
	&sc42_jobsworth,
	sc42_clerk_type,
	sc42_judge_talk,
	sc42_pros_talk,
	sc42_jobs_talk,
	sc42_jobs_enter,
	sc42_blunt_enter,
	sc42_blunt_talk,
	reset_guard_42,
	reset_dani_42,
	sc42_blunt_leave,
	sc42_fos_enter,
	sc42_fos_talk_l,
	sc42_fos_talk_r,
	sc42_fos_turn_lr,
	sc42_fos_turn_rl,
	sc42_dani_talk,
	sc42_fos_leave,
	sc42_judge_point,
	sc42_clerk_talk,
	sc42_jobs_point,
	sc42_jdg_turn,
	sc42_jdg_return,
	sc42_jdg_to_jobs,
	sc42_jdg_hammer,
	&sc42_sign,
	sc42_sign_anim,
	&sc31_joey,
	sc31_joey_fall,
	sc44_drop_down,
	sc36_juke_sing,
	&dog_bark_thing,
	&sc41_heat_1,
	&sc41_heat_2,
	&sc41_heat_3,
	sc41_heat_1_anim,
	sc41_heat_2_anim,
	sc41_heat_3_anim,
	sc38_scr_bark,
	sc39_descend,
	sc39_ascend,
	sc40_descend,
	sc40_ascend,
	reset_jukebox,
	reset_juke_light,
	sc31_guard_chat,
	&sc31_at_watcher
};

} // namespace SkyCompact

} // namespace Sky

#endif
