/* ScummVM - Scumm Interpreter
 * Copyright (C) 2005-2006 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/backends/ps2/iop/CoDyVDfs/iop/Attic/fiofs.h,v 1.1.2.3 2006/01/18 18:07:24 sev Exp $
 *
 */

#ifndef __FIOFS_H__
#define __FIOFS_H__

int initFio(void);

int cd_open(iop_file_t *handle, const char *name, int mode);
int cd_lseek(iop_file_t *handle, int ofs, int whence);
int cd_read(iop_file_t *handle, void *dest, int length);
int cd_close(iop_file_t *handle);
int cd_dopen(iop_file_t *handle, const char *path);
int cd_dread(iop_file_t *handle, fio_dirent_t *buf);
int cd_dclose(iop_file_t *handle);

#endif // __FIOFS_H__

