/* ScummVM - Scumm Interpreter
 * Copyright (C) 2002-2006 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/scumm/help.h,v 1.8.2.3 2006/01/20 23:03:18 kirben Exp $
 *
 */

#ifndef SCUMM_HELP_H
#define SCUMM_HELP_H

#include "common/str.h"

namespace Scumm {

#define HELP_NUM_LINES 15

class ScummHelp {
protected:
	typedef Common::String String;

public:
	static int numPages(byte gameId);
	static void updateStrings(byte gameId, byte version, Common::Platform platform,
			int page, String &title, String *&key, String *&dsc);
};

} // End of namespace Scumm

#endif

