#include "seaview.h"
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Choice.H>

/* included functions */
char* fl_file_chooser_save_as(const char* message, const char* pat, 
	const char* fname, void *view);
#ifdef __APPLE__
char* fl_file_chooser_plus(const char* message, const char* pat, 
	const char* fname, int use_only_button);
int MG_GetOutputFName_Popup(char *fname, int maxl, char *dfault, void *data, int defaultformat);
int MG_GetOutputFName_Plus(char *fname, int maxl, char *dfault, char *message, int);
#elif defined(WIN32)
char *MG_win32_file_chooser(const char* message,
        const char* pattern,
        const char* fname,
        const char* defext, // default filename extension or NULL
        bool save, int *pfilterindex);
#endif



// needed functions
extern void set_save_format(SEA_VIEW *view, int val);
#ifdef __APPLE__
extern int set_res_value(const char *name, const char *value);
extern "C" {  
	void MG_FSSpecToPathname (FSSpec *myFSS, char *fname, int maxl);
	void PtoC(const void *in, void *out);
	void CtoP(const void *in, void *out);
#if TARGET_RT_MAC_MACHO
#	define mac_os_x()  1
#else
	int mac_os_x(void);
#endif
	}
#endif

extern int nbr_formats;
extern char *f_format_names[];
extern int printout_block, printout_fontsize;
extern int printout_vary, printout_black;
extern paperformat printout_pageformat;


#ifdef __APPLE__
NavMenuItemSpecArrayHandle formatitems=NULL; /* pour MG_GetOutputFName_Popup et MyNavEventProc_popup */

static pascal void MyNavEventProc_popup (NavEventCallbackMessage callBackSelector,
                                   NavCBRecPtr callBackParms,
                                   NavCallBackUserData callBackUD)
{
NavMenuItemSpec *p;
SEA_VIEW *view;
int num;
OSErr err;

view = (SEA_VIEW *)callBackUD;
if(callBackSelector == kNavCBStart) { /* fixer la valeur montre du menu popup format: */
	HLock((Handle)formatitems);
	p = *formatitems;
	err = NavCustomControl(callBackParms->context, kNavCtlSelectCustomType, 
		p + view->format_for_save ); 
	HUnlock((Handle)formatitems);
	}
else if(callBackSelector == kNavCBPopupMenuSelect) { /* action sur le menu format: */
	p = (NavMenuItemSpec *)(callBackParms->eventData.eventDataParms.param);
	num = p->menuCreator;
	set_save_format(view, num);
	}
return;
}


int MG_GetOutputFName_Popup(char *fname, int maxl, char *dfault, void *data, int defaultformat)
{
    OSErr               anErr = noErr;
    NavReplyRecord      reply;
static NavDialogOptions    dialogOptions;
    OSType              fileTypeToSave = 'TEXT';
    OSType              creatorType;
static NavEventUPP  eventProc;
    NavMenuItemSpec 	*p;
    int  i, rsult = FALSE;

if(formatitems == NULL) { /* initialisation */
    anErr = NavGetDefaultDialogOptions (&dialogOptions);
    if (anErr != noErr) return FALSE;    
    CtoP("seaview: Choose file and format", dialogOptions.windowTitle);
    dialogOptions.dialogOptionFlags &= ~ kNavNoTypePopup;
    dialogOptions.dialogOptionFlags &= ~ kNavAllowStationery;
    formatitems = (NavMenuItemSpecArrayHandle)NewHandle(nbr_formats * sizeof(NavMenuItemSpec));
    if(formatitems == NULL) return FALSE;
    HLock((Handle)formatitems);
    p = *formatitems;
    for(i = 0; i < nbr_formats; i++) {
	p->version = kNavMenuItemSpecVersion;
	CtoP(f_format_names[i], p->menuItemName);
	p->menuCreator = i;  
	p->menuType = 11 ;  /* car les valeurs [-1,10] sont interdites pour menuType */
	p++;
	}
    HUnlock((Handle)formatitems);
    dialogOptions.popupExtension = formatitems;
    eventProc = NewNavEventUPP (MyNavEventProc_popup);
    }
reply.translationNeeded = false;
CtoP(dfault, dialogOptions.savedFileName);
creatorType = kNavGenericSignature;
anErr = NavPutFile(NULL, &reply, &dialogOptions, eventProc, fileTypeToSave, creatorType, data);
if (anErr == noErr && reply.validRecord)
            {
                AEKeyword   theKeyword;
                DescType    actualType;
                Size        actualSize;
                FSSpec      documentFSSpec;

                anErr = AEGetNthPtr(&(reply.selection), 1, typeFSS,
                                    &theKeyword, &actualType,
                                    &documentFSSpec, sizeof(documentFSSpec),
                                    &actualSize );
                if (anErr == noErr)
                {
                    if (reply.replacing)
                    { /* compute the pathname of the pre-existing file */
                        MG_FSSpecToPathname (&documentFSSpec, fname, maxl);
                        rsult = TRUE;
                    }
                    else
                    { /* the chosen file is new, compute pathname to its directory
                    and append new filename */
                        char empty[256];
                        FSSpec pfss;
                        empty[0] = 0;
                   /* make an FSSpec from volume + parentID of documentFSSpec
                   */
                        FSMakeFSSpec(documentFSSpec.vRefNum, documentFSSpec.parID,
                        	(StringPtr) empty, &pfss);
                   /* compute pathname for this FSSpec
                   */
                        MG_FSSpecToPathname (&pfss, fname, maxl);
                        /* append : new filename to this path
                        */
#if TARGET_RT_MAC_MACHO
                        strcat(fname, "/");
#else
                        strcat(fname, ":");
#endif
                        PtoC(documentFSSpec.name, fname + strlen(fname) );
         				anErr = FSpCreate(&documentFSSpec, 'ttxt', 'TEXT', smSystemScript);

                        rsult = TRUE;
                    }
                    anErr = NavCompleteSave(&reply, kNavTranslateInPlace); 
                }
            }
NavDisposeReply(&reply);
if(!rsult) set_save_format((SEA_VIEW *)data, defaultformat);
return rsult;
}


char* fl_file_chooser_save_as(const char* message, const char* pat, 
	const char* fname, void *data)
{
	static char pathname[FL_PATH_MAX];
	SEA_VIEW *view = (SEA_VIEW *)data;
	if( MG_GetOutputFName_Popup(pathname, FL_PATH_MAX, extract_filename((char *)fname), data, 
						view->format_for_save) ) return pathname;
	else return NULL;
}


static pascal void MyNavEventProc_Plus (NavEventCallbackMessage callBackSelector,
                                   NavCBRecPtr callBackParms,
                                   NavCallBackUserData callBackUD)
{
OSErr err;
static Handle gDitlList = NULL;
static DialogItemIndex index;
static DialogRef ref;
static ControlRef var_control = NULL;
Rect rect; Handle h; DialogItemType dtype; Str255 text; ControlRef control;
char text2[256];

if(callBackSelector == kNavCBCustomize) {
	if(callBackParms->customRect.bottom == 0) 
			callBackParms->customRect.bottom = callBackParms->customRect.top + 35;
	if(callBackParms->customRect.right == 0) 
			callBackParms->customRect.right = callBackParms->customRect.left + 425;
	}
else if(callBackSelector == kNavCBStart) {
	gDitlList = GetResource ('DITL', 128);
	if(gDitlList != NULL) err = NavCustomControl(callBackParms->context, 
                            kNavCtlAddControlList, gDitlList);
    err = NavCustomControl(callBackParms->context, kNavCtlGetFirstControlID, &index);
    index++;
    ref = GetDialogFromWindow(callBackParms->window);
	sprintf(text2,"%2d", printout_block);
	CtoP(text2, text);
	GetDialogItem(ref, index + 1, &dtype, &h, &rect);
	SetDialogItemText(h, text);
	sprintf(text2,"%2d", printout_fontsize);
	CtoP(text2, text);
	GetDialogItem(ref, index + 3, &dtype, &h, &rect);
	SetDialogItemText(h, text);
	err = GetDialogItemAsControl(ref, index + 4, &control);
	if(err == 0) SetControl32BitValue(control, printout_black);
	
	err = GetDialogItemAsControl(ref, index + 5, &control);
	if(err == 0) SetControl32BitValue(control, printout_pageformat == 0);
	err = GetDialogItemAsControl(ref, index + 6, &control);
	if(err == 0) SetControl32BitValue(control, printout_pageformat == 1);

	err = GetDialogItemAsControl(ref, index + 7, &var_control);
	if(err == 0) SetControl32BitValue(var_control, printout_vary);
	if(*(int *)callBackUD) ActivateControl(var_control);
	else DeactivateControl(var_control);
	}
else if(callBackSelector == kNavCBTerminate) {
	if(gDitlList != NULL) {
		GetDialogItem(ref, index + 1, &dtype, &h, &rect);
		GetDialogItemText(h, text);
		PtoC(text, text2);
		sscanf(text2,"%d", &printout_block);
		GetDialogItem(ref, index + 3, &dtype, &h, &rect);
		GetDialogItemText(h, text);
		PtoC(text, text2);
		sscanf(text2,"%d", &printout_fontsize);
		set_res_value("printoutfontsize", text2);
		ReleaseResource( gDitlList );
		}
	var_control = NULL;
	}
else if(callBackSelector == kNavCBEvent ) {
	if(var_control != NULL && callBackParms->eventData.itemHit == index + 7) {
		static int count = 0; /* MacOS 9: passe 2 fois a chaque click sur check box */
		if( mac_os_x() || (++count) % 2 == 0 ) {
			printout_vary = (printout_vary + 1) % 2;
			SetControl32BitValue(var_control, printout_vary);
			}
		}
	else if(callBackParms->eventData.itemHit == index + 4) {
		static int count = 0; /* MacOS 9: passe 2 fois a chaque click sur check box */
		if( mac_os_x() || (++count) % 2 == 0 ) {
			printout_black = (printout_black + 1) % 2;
			GetDialogItemAsControl(ref, index + 4, &control);
			SetControl32BitValue(control, printout_black);
			}
		}
	else if(callBackParms->eventData.itemHit == index + 5) {
		if(printout_pageformat == LETTER) {
				GetDialogItemAsControl(ref, index + 5, &control);
				SetControl32BitValue(control, 1);
				GetDialogItemAsControl(ref, index + 6, &control);
				SetControl32BitValue(control, 0);
				printout_pageformat = A4;
				}
		}
	else if(callBackParms->eventData.itemHit == index + 6) {
		if(printout_pageformat == A4) {
				GetDialogItemAsControl(ref, index + 6, &control);
				SetControl32BitValue(control, 1);
				GetDialogItemAsControl(ref, index + 5, &control);
				SetControl32BitValue(control, 0);
				printout_pageformat = LETTER;
				}
		}
	}
return;
}


int MG_GetOutputFName_Plus(char *fname, int maxl, char *dfault, char *message, int use_only_button)
{
    OSErr               anErr = noErr;
    NavReplyRecord      reply;
    NavDialogOptions    dialogOptions;
    OSType              fileTypeToSave = 'TEXT';
    OSType              creatorType;
    NavEventUPP         eventProc = NewNavEventUPP (MyNavEventProc_Plus);
	int    rsult = FALSE;
	static int *p_use;

    anErr = NavGetDefaultDialogOptions (&dialogOptions);
    if (anErr == noErr)
    {
    CtoP(message, dialogOptions.windowTitle);
    dialogOptions.dialogOptionFlags |= kNavNoTypePopup;
    dialogOptions.dialogOptionFlags &= ~ kNavAllowStationery;
    reply.translationNeeded = false;


            //  One way to get the name for the file to be saved.
			CtoP(dfault, dialogOptions.savedFileName);

            creatorType = kNavGenericSignature;
            p_use = &use_only_button;
            anErr = NavPutFile( NULL, &reply, &dialogOptions, eventProc,
                                fileTypeToSave, creatorType, p_use );
            if (anErr == noErr && reply.validRecord)
            {
                AEKeyword   theKeyword;
                DescType    actualType;
                Size        actualSize;
                FSSpec      documentFSSpec;

                anErr = AEGetNthPtr(&(reply.selection), 1, typeFSS,
                                    &theKeyword, &actualType,
                                    &documentFSSpec, sizeof(documentFSSpec),
                                    &actualSize );
                if (anErr == noErr)
                {
                    if (reply.replacing)
                    { /* compute the pathname of the pre-existing file */
                        MG_FSSpecToPathname (&documentFSSpec, fname, maxl);
                        rsult = TRUE;
                    }
                    else
                    { /* the chosen file is new, compute pathname to its directory
                    and append new filename */
                        char empty[256];
                        FSSpec pfss;
                        empty[0] = 0;
                   /* make an FSSpec from volume + parentID of documentFSSpec
                   */
                        FSMakeFSSpec(documentFSSpec.vRefNum, documentFSSpec.parID,
                        	(StringPtr) empty, &pfss);
                   /* compute pathname for this FSSpec
                   */
                        MG_FSSpecToPathname (&pfss, fname, maxl);
                        /* append : new filename to this path
                        */
#if TARGET_RT_MAC_MACHO
                        strcat(fname, "/");
#else
                        strcat(fname, ":");
#endif
                        PtoC(documentFSSpec.name, fname + strlen(fname) );

                        rsult = TRUE;
                    }

                        // DO NOT call NavCompleteSave() to complete
                         anErr = NavCompleteSave(&reply,
                                                kNavTranslateInPlace); 
                }
                (void) NavDisposeReply(&reply);
            }
        DisposeNavEventUPP(eventProc);
    }
    return rsult;
}


char* fl_file_chooser_plus(const char* message, const char* pat, 
	const char* fname, int use_only_button)
{
	static char pathname[FL_PATH_MAX];
	if( MG_GetOutputFName_Plus(pathname, FL_PATH_MAX, (char *)fname, (char *)message, use_only_button) 
		) return pathname;
	else return NULL;
}


#elif defined(WIN32)

extern char *f_format_names[];
extern char *f_format_exts[];
extern int nbr_formats;

char* fl_file_chooser_save_as(const char* message, const char* pat, 
	const char* fname, void *view)
{
int filterindex;
char *outfname, *p, types_list[500];

p = types_list;
for(int f = 0; f < nbr_formats; f++) {
	sprintf(p, "%s format (*.%s)%c*.%s%c", 
		f_format_names[f], f_format_exts[f], 0, f_format_exts[f], 0);
	p += strlen(p) + 1;
	p += strlen(p) + 1;
	}
*p = 0;

filterindex = ((SEA_VIEW *)view)->format_for_save + 1;
outfname = MG_win32_file_chooser(message, 
			types_list,
			fname, 
			memcmp(pat, "*.", 2) == 0 ? pat+2 : NULL,
			TRUE, &filterindex);
if(outfname != NULL) set_save_format((SEA_VIEW *)view, filterindex - 1);
return outfname;
}


#else



#define labelSize 10
#define calc_width(nom) \
	(fl_font(FL_HELVETICA, labelSize), (int)fl_width(nom) + 20)
	

void change_format(Fl_Widget *obj, void *data)
{
SEA_VIEW *view = (SEA_VIEW *)data;
int reponse = ((Fl_Choice *)obj)->value();
if(view->format_for_save != reponse) set_save_format(view, reponse);
return;
}


char *					// O - Filename or NULL
fl_file_chooser_save_as(const char *message,	// I - Message in titlebar
                const char *pat,	// I - Filename pattern
		const char *fname,	// I - Initial filename selection
		void        *data) 
{	
  static char	retname[1024];		// Returned filename
static Fl_File_Chooser *fc;
SEA_VIEW *view = (SEA_VIEW *)data;
static Fl_Choice *mychoice;

  if (!fc) {
      if (!fname || !*fname) fname = ".";

      fc = new Fl_File_Chooser(fname, pat, Fl_File_Chooser::CREATE, message);
 	  fc->preview(0);
 	  fc->previewButton->hide();
 	  static char c_label[] = "Format:";
 	  int y = fc->previewButton->y();
	  fc->previewButton->parent()->begin();
	  mychoice = new Fl_Choice(10 + calc_width(c_label), y, 150, fc->previewButton->h());
 	  fc->previewButton->parent()->end();
	  for(int i=0; i < nbr_formats; i++) mychoice->add(f_format_names[i], 0, 0, 0, 0);
      mychoice->label(c_label);
      mychoice->callback(change_format, view);
  } else {
    fc->type(Fl_File_Chooser::CREATE);
    fc->filter(pat);
    fc->label(message);

    if (!fname || !*fname) {
      if (fc->filter() != pat && (!pat || !fc->filter() ||
          strcmp(pat, fc->filter())) && fc->value()) {
	// if pattern is different, remove name but leave old directory:
//	strlcpy(retname, fc->value(), sizeof(retname));
	strcpy(retname, fc->value() );

	char *p = strrchr(retname, '/');

        if (p) {
	  // If the filename is "/foo", then the directory will be "/", not
	  // ""...
	  if (p == retname)
	    retname[1] = '\0';
	  else
	    *p = '\0';
	}

	// Set the directory...
	fc->directory(retname);
      }
    }
    else
      fc->value(fname);
  }

  mychoice->value(view->format_for_save);
  fc->show();

  while (fc->shown())
    Fl::wait();

  if (fc->value()) return (char *)fc->value();
  else return 0;
}


#endif
