/*
 * Decompiled with CFR 0.152.
 */
import com.wallyflint.one_point_one.collections.TernarySearchTreeModified;
import java.applet.Applet;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TSTDemo
extends Applet {
    private TernarySearchTreeModified tst = TSTLoader.getTST();
    private TextListenerAction lookupAction = new LookupAction();
    private TextListenerAction noAction = new NoAction();
    private TextListenerAction preAction = new PreAction();
    private TextListenerAction spellAction = new SpellAction();
    private TextListenerAction currentAction = this.lookupAction;
    private InfoPanel infoPanel;
    private TextField textField;
    private TextArea textArea;

    public static void main(String[] args) {
        DemoFrame app = new DemoFrame("Ternary Search Tree Demo");
        app.setSize(500, 600);
        app.show();
    }

    public void init() {
        Insets zeroInsets;
        Insets bottomRightInsets;
        Insets bottomLeftInsets;
        Insets topRightInsets;
        Insets topLeftInsets;
        Font defaultFont = new Font("SansSerif", 1, 12);
        this.setFont(defaultFont);
        FontMetrics fontMetrics = this.getFontMetrics(defaultFont);
        CheckboxGroup cbg = new CheckboxGroup();
        Checkbox lookupCheck = new Checkbox("lookup", cbg, true);
        Checkbox addCheck = new Checkbox("add", cbg, false);
        Checkbox preCheck = new Checkbox("match prefix", cbg, false);
        Checkbox spellCheck = new Checkbox("check spelling    ", cbg, false);
        Panel checkboxPanel = new Panel();
        checkboxPanel.setLayout(new GridLayout(2, 2));
        checkboxPanel.add(lookupCheck);
        checkboxPanel.add(preCheck);
        checkboxPanel.add(addCheck);
        checkboxPanel.add(spellCheck);
        FixedSizeLabel textFieldLabel = new FixedSizeLabel("word", fontMetrics);
        this.textField = new TextField(10);
        FixedSizeLabel textAreaLabel = new FixedSizeLabel("definition", fontMetrics);
        this.textArea = new TextArea(10, 10);
        Panel displayPanel = new Panel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        displayPanel.setLayout(gridbag);
        c.insets = topLeftInsets = new Insets(6, 0, 6, 4);
        c.fill = 0;
        c.anchor = 12;
        c.weightx = 0.0;
        c.weighty = 0.0;
        displayPanel.add((Component)textFieldLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = topRightInsets = new Insets(6, 0, 6, 0);
        displayPanel.add((Component)this.textField, c);
        c.insets = new Insets(6, 4, 0, 4);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        c.anchor = 12;
        c.insets = bottomLeftInsets = new Insets(6, 0, 0, 4);
        displayPanel.add((Component)textAreaLabel, c);
        c.weightx = 1.0;
        c.gridx = 1;
        c.fill = 1;
        c.insets = bottomRightInsets = new Insets(6, 0, 0, 0);
        displayPanel.add((Component)this.textArea, c);
        final Panel buttonPanel = new Panel();
        Panel blankPanel = new Panel();
        Panel addPanel = new Panel();
        Button addButton = new Button("add");
        SpacerLabel spacer = new SpacerLabel(textAreaLabel.getMinimumSize().width);
        addPanel.add(spacer);
        addPanel.add(addButton);
        final CardLayout cardLayout = new CardLayout();
        buttonPanel.setLayout(cardLayout);
        buttonPanel.add((Component)blankPanel, "blank");
        buttonPanel.add((Component)addPanel, "add");
        cardLayout.show(buttonPanel, "blank");
        this.infoPanel = new InfoPanel(fontMetrics);
        this.setLayout(new GridBagLayout());
        c.insets = zeroInsets = new Insets(0, 0, 0, 0);
        c.gridy = 0;
        c.gridx = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 12;
        this.add((Component)checkboxPanel, c);
        c.fill = 1;
        c.gridy = 1;
        c.weighty = 1.0;
        c.anchor = 10;
        this.add((Component)displayPanel, c);
        c.gridy = 2;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 0;
        c.insets = topRightInsets;
        this.add((Component)buttonPanel, c);
        c.gridy = 3;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 0;
        c.insets = zeroInsets;
        this.add((Component)this.infoPanel, c);
        lookupCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TSTDemo.this.textField.setText("");
                    TSTDemo.this.textArea.setText("");
                    TSTDemo.this.currentAction = TSTDemo.this.lookupAction;
                    cardLayout.show(buttonPanel, "blank");
                }
            }
        });
        addCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TSTDemo.this.textField.setText("");
                    TSTDemo.this.textArea.setText("");
                    cardLayout.show(buttonPanel, "add");
                    TSTDemo.this.currentAction = TSTDemo.this.noAction;
                }
            }
        });
        preCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TSTDemo.this.textField.setText("");
                    TSTDemo.this.textArea.setText("");
                    TSTDemo.this.currentAction = TSTDemo.this.preAction;
                    cardLayout.show(buttonPanel, "blank");
                }
            }
        });
        spellCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TSTDemo.this.textField.setText("");
                    TSTDemo.this.textArea.setText("");
                    TSTDemo.this.currentAction = TSTDemo.this.spellAction;
                    cardLayout.show(buttonPanel, "blank");
                }
            }
        });
        this.textField.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent textEvent) {
                String textFieldContents = TSTDemo.this.textField.getText();
                if (textFieldContents.equals("")) {
                    TSTDemo.this.textArea.setText("");
                    TSTDemo.this.infoPanel.setOpValues(0);
                    TSTDemo.this.infoPanel.setOpTime(0L);
                    TSTDemo.this.infoPanel.repaint();
                    return;
                }
                TSTDemo.this.currentAction.doAction(textFieldContents);
            }
        });
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String textFieldContents = TSTDemo.this.textField.getText();
                String textAreaContents = TSTDemo.this.textArea.getText();
                if (textFieldContents.equals("") || textAreaContents.equals("")) {
                    return;
                }
                long time = System.currentTimeMillis();
                TSTDemo.this.tst.put(textFieldContents, textAreaContents);
                time = System.currentTimeMillis() - time;
                TSTDemo.this.infoPanel.setNumWords(TSTDemo.this.tst.numDataNodes());
                TSTDemo.this.infoPanel.setOpTime(time);
                TSTDemo.this.infoPanel.setOpValues(0);
                TSTDemo.this.textField.setText("");
                TSTDemo.this.textArea.setText("");
                TSTDemo.this.infoPanel.repaint();
            }
        });
        this.infoPanel.setNumWords(this.tst.numDataNodes());
        this.setBackground(Color.white);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    private final class SpellAction
    extends TextListenerAction {
        private SpellAction() {
        }

        public final void doAction(String textFieldContents) {
            int returnValues = 0;
            boolean[] hasValue = new boolean[]{false, false, false, false};
            long time = System.currentTimeMillis();
            TSTDemo.this.tst.setMatchDiff(0);
            String[] intermediateResults = new String[]{"", "", "", ""};
            intermediateResults[0] = TSTDemo.this.tst.matchAlmostString(textFieldContents);
            int currentLastNum = TSTDemo.this.tst.getLastNumReturnValues();
            if (currentLastNum > 0) {
                hasValue[0] = true;
            }
            returnValues += currentLastNum;
            TSTDemo.this.tst.setMatchDiff(1);
            intermediateResults[1] = TSTDemo.this.tst.matchAlmostString(textFieldContents);
            currentLastNum = TSTDemo.this.tst.getLastNumReturnValues();
            if (currentLastNum > 0) {
                hasValue[1] = true;
            }
            returnValues += currentLastNum;
            if (textFieldContents.length() > 3) {
                String currentResult;
                String altered;
                TernarySearchTreeModified uniqueKeyTree = new TernarySearchTreeModified();
                Object keyMarker = new Object();
                for (int i = 0; i <= textFieldContents.length(); ++i) {
                    altered = textFieldContents.substring(0, i) + "*" + textFieldContents.substring(i);
                    currentResult = TSTDemo.this.tst.matchAlmostString(altered);
                    System.out.println("");
                    System.out.println("altered string: " + altered);
                    System.out.println("curent result: " + currentResult);
                    if (currentResult.length() <= 0) continue;
                    uniqueKeyTree.put(currentResult, keyMarker);
                }
                TSTDemo.this.tst.setMatchDiff(0);
                for (int i = 0; i < textFieldContents.length(); ++i) {
                    char holdChar = textFieldContents.charAt(i);
                    altered = textFieldContents.substring(0, i) + textFieldContents.substring(i + 1);
                    currentResult = TSTDemo.this.tst.matchAlmostString(altered);
                    if (currentResult.length() <= 0) continue;
                    uniqueKeyTree.put(currentResult, keyMarker);
                }
                intermediateResults[2] = uniqueKeyTree.sortKeysString();
                if (intermediateResults[2].length() > 0) {
                    hasValue[2] = true;
                }
                returnValues += uniqueKeyTree.numDataNodes();
            }
            if (textFieldContents.length() > 5) {
                TSTDemo.this.tst.setMatchDiff(2);
                intermediateResults[3] = TSTDemo.this.tst.matchAlmostString(textFieldContents);
                currentLastNum = TSTDemo.this.tst.getLastNumReturnValues();
                if (currentLastNum > 0) {
                    hasValue[3] = true;
                }
                returnValues += currentLastNum;
            }
            String finalResult = hasValue[0] ? intermediateResults[0] : "";
            for (int i = 0; i < 3; ++i) {
                if (hasValue[i] && hasValue[i]) {
                    finalResult = finalResult + "\n";
                }
                finalResult = finalResult + intermediateResults[i + 1];
            }
            time = System.currentTimeMillis() - time;
            TSTDemo.this.textArea.setText(finalResult);
            TSTDemo.this.infoPanel.setOpTime(time);
            TSTDemo.this.infoPanel.setOpValues(returnValues);
            TSTDemo.this.infoPanel.repaint();
        }
    }

    private final class PreAction
    extends TextListenerAction {
        private PreAction() {
        }

        public final void doAction(String textFieldContents) {
            long time = System.currentTimeMillis();
            String matchingKeys = TSTDemo.this.tst.matchPrefixString(textFieldContents);
            time = System.currentTimeMillis() - time;
            TSTDemo.this.textArea.setText(matchingKeys);
            TSTDemo.this.infoPanel.setOpValues(TSTDemo.this.tst.getLastNumReturnValues());
            TSTDemo.this.infoPanel.setOpTime(time);
            TSTDemo.this.infoPanel.repaint();
        }
    }

    private final class NoAction
    extends TextListenerAction {
        private NoAction() {
        }

        public final void doAction(String textFieldContents) {
        }
    }

    private final class LookupAction
    extends TextListenerAction {
        private LookupAction() {
        }

        public final void doAction(String textFieldContents) {
            long time = System.currentTimeMillis();
            String definition = (String)TSTDemo.this.tst.get(textFieldContents);
            time = System.currentTimeMillis() - time;
            TSTDemo.this.textArea.setText(definition);
            TSTDemo.this.infoPanel.setOpValues(1);
            TSTDemo.this.infoPanel.setOpTime(time);
            TSTDemo.this.infoPanel.repaint();
        }
    }

    private abstract class TextListenerAction {
        private TextListenerAction() {
        }

        public abstract void doAction(String var1);
    }

    private class InfoPanel
    extends Panel {
        private int lineHeight;
        private int leading;
        private int valueXCoordinate;
        private String[] messagePrefixes = new String[]{"Number of words in dictionary: ", "Time for last operation (milliseconds): ", "Values returned by last operation: "};
        private long[] messageValues = new long[this.messagePrefixes.length];
        private Dimension minSize;

        public InfoPanel(FontMetrics fm) {
            this.lineHeight = fm.getMaxAscent() + fm.getMaxDescent();
            this.leading = fm.getLeading();
            int maxLength = 0;
            for (int i = 0; i < this.messagePrefixes.length; ++i) {
                maxLength = Math.max(maxLength, fm.stringWidth(this.messagePrefixes[i]));
            }
            this.minSize = new Dimension(maxLength + fm.stringWidth("500000") + 4, this.leading * (this.messagePrefixes.length + 1) + this.lineHeight * this.messagePrefixes.length + 12);
            this.valueXCoordinate = this.minSize.width - fm.stringWidth("500000");
        }

        public void paint(Graphics g) {
            int currentY = this.leading + this.lineHeight + 6;
            for (int i = 0; i < this.messagePrefixes.length; ++i) {
                g.drawString(this.messagePrefixes[i], 0, currentY);
                g.drawString(String.valueOf(this.messageValues[i]), this.valueXCoordinate, currentY);
                currentY += this.lineHeight + this.leading;
            }
        }

        public Dimension getMinimumSize() {
            return this.minSize;
        }

        public Dimension getPreferredSize() {
            return this.minSize;
        }

        public Dimension getMaximumSize() {
            return this.minSize;
        }

        public void setNumWords(int num) {
            this.messageValues[0] = num;
        }

        public void setOpTime(long time) {
            this.messageValues[1] = time;
        }

        public void setOpValues(int numValues) {
            this.messageValues[2] = numValues;
        }
    }

    private class SpacerLabel
    extends Label {
        private Dimension minSize;

        public SpacerLabel(int width) {
            this.minSize = new Dimension(width, 0);
        }

        public Dimension getMinimumSize() {
            return this.minSize;
        }

        public Dimension getPreferredSize() {
            return this.minSize;
        }

        public Dimension getMaximumSize() {
            return this.minSize;
        }
    }

    private class FixedSizeLabel
    extends Label {
        private Dimension minSize;

        public FixedSizeLabel(String initialText, FontMetrics fm) {
            super(initialText, 2);
            this.minSize = new Dimension(fm.stringWidth("definition") + 4, fm.getMaxAscent() + fm.getMaxDescent() + fm.getLeading());
        }

        public Dimension getMinimumSize() {
            return this.minSize;
        }

        public Dimension getPreferredSize() {
            return this.minSize;
        }

        public Dimension getMaximumSize() {
            return this.minSize;
        }
    }
}

