/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.core;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.LayoutState;
import com.intellij.uiDesigner.core.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;

public abstract class DimensionInfo {
    private final int[] myCell;
    private final int[] mySpan;
    protected final LayoutState myLayoutState;
    private final int[] myStretches;
    private final int[] mySpansAfterElimination;
    private final int[] myCellSizePolicies;
    private final int myGap;

    public DimensionInfo(LayoutState layoutState, int gap) {
        int i;
        if (layoutState == null) {
            throw new IllegalArgumentException("layoutState cannot be null");
        }
        if (gap < 0) {
            throw new IllegalArgumentException("invalid gap: " + gap);
        }
        this.myLayoutState = layoutState;
        this.myGap = gap;
        this.myCell = new int[layoutState.getComponentCount()];
        this.mySpan = new int[layoutState.getComponentCount()];
        for (i = 0; i < layoutState.getComponentCount(); ++i) {
            GridConstraints c = layoutState.getConstraints(i);
            this.myCell[i] = this.getOriginalCell(c);
            this.mySpan[i] = this.getOriginalSpan(c);
        }
        this.myStretches = new int[this.getCellCount()];
        for (i = 0; i < this.myStretches.length; ++i) {
            this.myStretches[i] = 1;
        }
        ArrayList elimitated = new ArrayList();
        this.mySpansAfterElimination = (int[])this.mySpan.clone();
        Util.eliminate((int[])this.myCell.clone(), this.mySpansAfterElimination, elimitated);
        this.myCellSizePolicies = new int[this.getCellCount()];
        for (int i2 = 0; i2 < this.myCellSizePolicies.length; ++i2) {
            this.myCellSizePolicies[i2] = this.getCellSizePolicyImpl(i2, elimitated);
        }
    }

    public final int getComponentCount() {
        return this.myLayoutState.getComponentCount();
    }

    public final Component getComponent(int componentIndex) {
        return this.myLayoutState.getComponent(componentIndex);
    }

    public abstract int getCellCount();

    public abstract int getPreferredWidth(int var1);

    public abstract int getMinimumWidth(int var1);

    public final int getCell(int componentIndex) {
        return this.myCell[componentIndex];
    }

    public final int getSpan(int componentIndex) {
        return this.mySpan[componentIndex];
    }

    public final int getStretch(int cellIndex) {
        return this.myStretches[cellIndex];
    }

    protected abstract int getOriginalCell(GridConstraints var1);

    protected abstract int getOriginalSpan(GridConstraints var1);

    abstract int getSizePolicy(int var1);

    public final int getGap() {
        return this.myGap;
    }

    private boolean componentBelongsCell(int componentIndex, int cellIndex) {
        int componentStartCell = this.getCell(componentIndex);
        int span = this.getSpan(componentIndex);
        return componentStartCell <= cellIndex && cellIndex < componentStartCell + span;
    }

    public final int getCellSizePolicy(int cellIndex) {
        return this.myCellSizePolicies[cellIndex];
    }

    private int getCellSizePolicyImpl(int cellIndex, ArrayList eliminatedCells) {
        for (int i = eliminatedCells.size() - 1; i >= 0; --i) {
            if (cellIndex != (Integer)eliminatedCells.get(i)) continue;
            return 1;
        }
        boolean canShrink = true;
        boolean canGrow = false;
        boolean wantGrow = false;
        boolean weakCanGrow = true;
        boolean weakWantGrow = true;
        int countOfBelongingComponents = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            boolean thisWantGrow;
            if (!this.componentBelongsCell(i, cellIndex)) continue;
            ++countOfBelongingComponents;
            int p = this.getSizePolicy(i);
            boolean thisCanShrink = (p & 1) != 0;
            boolean thisCanGrow = (p & 2) != 0;
            boolean bl = thisWantGrow = (p & 4) != 0;
            if (this.getCell(i) == cellIndex && this.mySpansAfterElimination[i] == 1) {
                canShrink &= thisCanShrink;
                canGrow |= thisCanGrow;
                wantGrow |= thisWantGrow;
            }
            if (!thisCanGrow) {
                weakCanGrow = false;
            }
            if (thisWantGrow) continue;
            weakWantGrow = false;
        }
        return (canShrink ? 1 : 0) | (canGrow || countOfBelongingComponents > 0 && weakCanGrow ? 2 : 0) | (wantGrow || countOfBelongingComponents > 0 && weakWantGrow ? 4 : 0);
    }

    protected final Dimension getPreferredSize(int componentIndex) {
        Dimension size = this.myLayoutState.myPreferredSizes[componentIndex];
        if (size == null) {
            this.myLayoutState.myPreferredSizes[componentIndex] = size = Util.getPreferredSize(this.myLayoutState.getComponent(componentIndex), this.myLayoutState.getConstraints(componentIndex));
        }
        return size;
    }

    protected final Dimension getMinimumSize(int componentIndex) {
        Dimension size = this.myLayoutState.myMinimumSizes[componentIndex];
        if (size == null) {
            this.myLayoutState.myMinimumSizes[componentIndex] = size = Util.getMinimumSize(this.myLayoutState.getComponent(componentIndex), this.myLayoutState.getConstraints(componentIndex));
        }
        return size;
    }
}

