/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class SupportCode {
    private static final Method ourGetCallerClassLoaderMethod;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$String;

    public static TextWithMnemonic parseText(String textWithMnemonic) {
        if (textWithMnemonic == null) {
            throw new IllegalArgumentException("textWithMnemonic cannot be null");
        }
        int index = -1;
        StringBuffer plainText = new StringBuffer();
        for (int i = 0; i < textWithMnemonic.length(); ++i) {
            char ch = textWithMnemonic.charAt(i);
            if (ch == '&') {
                if (++i >= textWithMnemonic.length()) break;
                ch = textWithMnemonic.charAt(i);
                if (ch != '&') {
                    index = plainText.length();
                }
            }
            plainText.append(ch);
        }
        return new TextWithMnemonic(plainText.toString(), index);
    }

    public static void setTextFromBundle(JComponent component, String bundleName, String key) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (bundleName == null) {
            throw new IllegalArgumentException("bundleName cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        ClassLoader loader = null;
        try {
            loader = ourGetCallerClassLoaderMethod != null ? (ClassLoader)ourGetCallerClassLoaderMethod.invoke(null, EMPTY_OBJECT_ARRAY) : null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        String text = SupportCode.getResourceString(bundleName, key, loader);
        TextWithMnemonic textWithMnemonic = SupportCode.parseText(text);
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setText(textWithMnemonic.myText);
            if (textWithMnemonic.myMnemonicIndex != -1) {
                label.setDisplayedMnemonic(textWithMnemonic.getMnemonicChar());
                SupportCode.setDisplayedMnemonicIndex(label, textWithMnemonic.myMnemonicIndex);
            }
        } else if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            button.setText(textWithMnemonic.myText);
            if (textWithMnemonic.myMnemonicIndex != -1) {
                button.setMnemonic(textWithMnemonic.getMnemonicChar());
                SupportCode.setDisplayedMnemonicIndex(button, textWithMnemonic.myMnemonicIndex);
            }
        } else {
            throw new IllegalArgumentException("unexpected class: " + component.getClass());
        }
    }

    public static void setTextFromBundle(JComponent component, String setterName, String bundle, String key) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (setterName == null) {
            throw new IllegalArgumentException("setterName cannot be null");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("bundle cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        ClassLoader loader = null;
        try {
            loader = ourGetCallerClassLoaderMethod != null ? (ClassLoader)ourGetCallerClassLoaderMethod.invoke(null, EMPTY_OBJECT_ARRAY) : null;
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e11) {
            e11.printStackTrace();
        }
        String text = SupportCode.getResourceString(bundle, key, loader);
        TextWithMnemonic textWithMnemonic = SupportCode.parseText(text);
        try {
            Method setter = component.getClass().getMethod(setterName, class$java$lang$String == null ? (class$java$lang$String = SupportCode.class$("java.lang.String")) : class$java$lang$String);
            setter.invoke((Object)component, textWithMnemonic.myText);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        if (textWithMnemonic.myMnemonicIndex != -1 && setterName.equals("setText")) {
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                label.setDisplayedMnemonic(textWithMnemonic.getMnemonicChar());
                SupportCode.setDisplayedMnemonicIndex(label, textWithMnemonic.myMnemonicIndex);
            } else if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setMnemonic(textWithMnemonic.getMnemonicChar());
                SupportCode.setDisplayedMnemonicIndex(button, textWithMnemonic.myMnemonicIndex);
            }
        }
    }

    public static void setDisplayedMnemonicIndex(JComponent component, int index) {
        try {
            Method method = component.getClass().getMethod("setDisplayedMnemonicIndex", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)component, new Integer(index));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getResourceString(String bundleName, String key) {
        ClassLoader loader = null;
        try {
            loader = ourGetCallerClassLoaderMethod != null ? (ClassLoader)ourGetCallerClassLoaderMethod.invoke(null, EMPTY_OBJECT_ARRAY) : null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return SupportCode.getResourceString(bundleName, key, loader);
    }

    private static String getResourceString(String bundleName, String key, ClassLoader callerClassLoader) {
        ResourceBundle bundle = callerClassLoader != null ? ResourceBundle.getBundle(bundleName, Locale.getDefault(), callerClassLoader) : ResourceBundle.getBundle(bundleName, Locale.getDefault());
        return bundle.getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method method;
        EMPTY_OBJECT_ARRAY = new Object[0];
        try {
            method = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SupportCode.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("getCallerClassLoader", new Class[0]);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            method = null;
        }
        ourGetCallerClassLoaderMethod = method;
    }

    public static final class TextWithMnemonic {
        public final String myText;
        public final int myMnemonicIndex;

        private TextWithMnemonic(String text, int index) {
            if (text == null) {
                throw new IllegalArgumentException("text cannot be null");
            }
            if (index != -1 && (index < 0 || index >= text.length())) {
                throw new IllegalArgumentException("wrong index: " + index + "; text = '" + text + "'");
            }
            this.myText = text;
            this.myMnemonicIndex = index;
        }

        public char getMnemonicChar() {
            if (this.myMnemonicIndex == -1) {
                throw new IllegalStateException("text doesn't contain mnemonic");
            }
            return Character.toUpperCase(this.myText.charAt(this.myMnemonicIndex));
        }
    }
}

