/*
 * Decompiled with CFR 0.152.
 */
package com.wallyflint.one_point_one.collections;

import com.wallyflint.util.CharUtility;
import java.util.LinkedList;

public class TernarySearchTreeModified {
    private TSTNode rootNode;
    private int defaultNumReturnValues = -1;
    private int lastNumberOfReturnValues;
    private double minStringLengthSimilarity = 0.0;
    private LinkedList matchResult;
    private StringBuffer matchBuffer;
    private boolean matchListAction;
    private int matchNumReturnValues;
    private String matchKey;
    private int matchDiff;
    private int maxMatchDiff = 4;
    private int searchMaxDepth = -1;
    private LinkedList sortKeysResult;
    private boolean sortKeysList;
    private StringBuffer sortKeysBuffer;
    private int sortKeysNumReturnValues;
    private StringBuffer getKeyBuffer = new StringBuffer();
    private int numNodes;
    private boolean checkData;

    public void put(String key, Object value) {
        this.getOrCreateNode((String)key).data = value;
    }

    public Object get(String key) {
        TSTNode node = this.getNode(key);
        if (node == null) {
            return null;
        }
        return node.data;
    }

    public void remove(String key) {
        this.deleteNode(this.getNode(key));
    }

    public void setNumReturnValues(int num) {
        this.defaultNumReturnValues = num < 0 ? -1 : num;
    }

    private int checkNumberOfReturnValues(int numReturnValues) {
        return numReturnValues < 0 ? -1 : numReturnValues;
    }

    public int getLastNumReturnValues() {
        return this.lastNumberOfReturnValues;
    }

    public TSTNode getNode(String key) {
        return this.getNode(key, this.rootNode);
    }

    protected TSTNode getNode(String key, TSTNode startNode) {
        if (key == null || startNode == null || key.length() == 0) {
            return null;
        }
        TSTNode currentNode = startNode;
        int charIndex = 0;
        while (currentNode != null) {
            int charComp = CharUtility.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar);
            if (charComp == 0) {
                if (++charIndex == key.length()) {
                    return currentNode;
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                currentNode = currentNode.relatives[1];
                continue;
            }
            currentNode = currentNode.relatives[3];
        }
        return null;
    }

    public LinkedList matchPrefix(String prefix) {
        return this.matchPrefix(prefix, this.defaultNumReturnValues);
    }

    public LinkedList matchPrefix(String prefix, int numReturnValues) {
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.sortKeysResult = new LinkedList();
        TSTNode startNode = this.getNode(prefix);
        if (startNode == null) {
            return this.sortKeysResult;
        }
        if (startNode.data != null) {
            this.sortKeysResult.addLast(this.getKey(startNode));
            --this.sortKeysNumReturnValues;
        }
        this.sortKeysList = true;
        this.sortKeysRecursion(startNode.relatives[2]);
        return this.sortKeysResult;
    }

    public String matchPrefixString(String prefix) {
        return this.matchPrefixString(prefix, this.defaultNumReturnValues);
    }

    public String matchPrefixString(String prefix, int numReturnValues) {
        TSTNode startNode = this.getNode(prefix);
        if (startNode == null) {
            return "";
        }
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.lastNumberOfReturnValues = this.sortKeysNumReturnValues--;
        this.sortKeysBuffer = new StringBuffer();
        if (startNode.data != null) {
            this.sortKeysBuffer.append(this.getKey(startNode) + "\n");
        }
        this.sortKeysList = false;
        this.sortKeysRecursion(startNode.relatives[2]);
        int bufferLength = this.sortKeysBuffer.length();
        if (bufferLength > 0) {
            this.sortKeysBuffer.setLength(bufferLength - 1);
        }
        this.lastNumberOfReturnValues -= this.sortKeysNumReturnValues;
        return this.sortKeysBuffer.toString();
    }

    private void sortKeysRecursion(TSTNode currentNode) {
        if (currentNode == null) {
            return;
        }
        this.sortKeysRecursion(currentNode.relatives[1]);
        if (this.sortKeysNumReturnValues == 0) {
            return;
        }
        if (currentNode.data != null) {
            if (this.sortKeysList) {
                this.sortKeysResult.addLast(this.getKey(currentNode));
            } else {
                this.sortKeysBuffer.append(this.getKey(currentNode) + "\n");
            }
            --this.sortKeysNumReturnValues;
        }
        this.sortKeysRecursion(currentNode.relatives[2]);
        this.sortKeysRecursion(currentNode.relatives[3]);
    }

    protected LinkedList sortKeys(TSTNode startNode, int numReturnValues) {
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.sortKeysResult = new LinkedList();
        this.sortKeysRecursion(startNode);
        return this.sortKeysResult;
    }

    public String sortKeysString(int numReturnValues) {
        return this.sortKeysString(this.rootNode, numReturnValues);
    }

    public String sortKeysString() {
        return this.sortKeysString(this.rootNode, this.defaultNumReturnValues);
    }

    public String sortKeysString(TSTNode startNode, int numReturnValues) {
        if (startNode == null) {
            return new String("");
        }
        this.sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.lastNumberOfReturnValues = this.sortKeysNumReturnValues--;
        this.sortKeysBuffer = new StringBuffer();
        if (startNode.data != null) {
            this.sortKeysBuffer.append(this.getKey(startNode) + "\n");
        }
        this.sortKeysList = false;
        this.sortKeysRecursion(startNode);
        int bufferLength = this.sortKeysBuffer.length();
        if (bufferLength > 0) {
            this.sortKeysBuffer.setLength(bufferLength - 1);
        }
        this.lastNumberOfReturnValues -= this.sortKeysNumReturnValues;
        return this.sortKeysBuffer.toString();
    }

    public LinkedList matchAlmost(String key) {
        return this.matchAlmost(key, this.defaultNumReturnValues);
    }

    protected LinkedList matchAlmost(String key, int numReturnValues) {
        this.matchListAction = true;
        this.matchNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.matchResult = new LinkedList();
        this.matchKey = key;
        this.matchAlmostRecursion(this.rootNode, 0, this.matchDiff);
        return this.matchResult;
    }

    public String matchAlmostString(String key) {
        return this.matchAlmostString(key, this.defaultNumReturnValues);
    }

    protected String matchAlmostString(String key, int numReturnValues) {
        this.matchListAction = false;
        this.lastNumberOfReturnValues = this.matchNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.matchBuffer = new StringBuffer();
        this.matchKey = key;
        this.matchAlmostRecursion(this.rootNode, 0, this.matchDiff);
        int bufferLength = this.matchBuffer.length();
        if (bufferLength > 0) {
            this.matchBuffer.setLength(bufferLength - 1);
        }
        this.lastNumberOfReturnValues -= this.matchNumReturnValues;
        return this.matchBuffer.toString();
    }

    private void matchAlmostRecursion(TSTNode currentNode, int charIndex, int d) {
        int nextD;
        if (currentNode == null || d < 0 || this.matchNumReturnValues == 0 || charIndex >= this.matchKey.length()) {
            return;
        }
        int charComp = CharUtility.compareCharsAlphabetically(this.matchKey.charAt(charIndex), currentNode.splitchar);
        if (d > 0 || charComp < 0) {
            this.matchAlmostRecursion(currentNode.relatives[1], charIndex, d);
        }
        int n = nextD = charComp == 0 ? d : d - 1;
        if (this.matchKey.length() == charIndex + 1 && nextD == 0 && currentNode.data != null) {
            if (this.matchListAction) {
                this.matchResult.addLast(this.getKey(currentNode));
            } else {
                this.matchBuffer.append(this.getKey(currentNode) + "\n");
            }
            --this.matchNumReturnValues;
        }
        this.matchAlmostRecursion(currentNode.relatives[2], charIndex + 1, nextD);
        if (d > 0 || charComp > 0) {
            this.matchAlmostRecursion(currentNode.relatives[3], charIndex, d);
        }
    }

    public void setMatchDiff(int diff) {
        this.matchDiff = diff < 0 ? 0 : (diff > this.maxMatchDiff ? this.maxMatchDiff : diff);
    }

    protected TSTNode getOrCreateNode(String key) throws NullPointerException, IllegalArgumentException {
        if (key == null) {
            throw new NullPointerException("attempt to get or create node with null key");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("attempt to get or create node with key of zero length");
        }
        if (this.rootNode == null) {
            this.rootNode = new TSTNode(key.charAt(0), null);
        }
        TSTNode currentNode = this.rootNode;
        int charIndex = 0;
        while (true) {
            int charComp;
            if ((charComp = CharUtility.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar)) == 0) {
                if (++charIndex == key.length()) {
                    return currentNode;
                }
                if (currentNode.relatives[2] == null) {
                    currentNode.relatives[2] = new TSTNode(key.charAt(charIndex), currentNode);
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                if (currentNode.relatives[1] == null) {
                    currentNode.relatives[1] = new TSTNode(key.charAt(charIndex), currentNode);
                }
                currentNode = currentNode.relatives[1];
                continue;
            }
            if (currentNode.relatives[3] == null) {
                currentNode.relatives[3] = new TSTNode(key.charAt(charIndex), currentNode);
            }
            currentNode = currentNode.relatives[3];
        }
    }

    private void deleteNode(TSTNode nodeToDelete) {
        if (nodeToDelete == null) {
            return;
        }
        nodeToDelete.data = null;
        while (nodeToDelete != null) {
            nodeToDelete = this.deleteNodeRecursion(nodeToDelete);
        }
    }

    private TSTNode deleteNodeRecursion(TSTNode currentNode) {
        TSTNode targetNode;
        int movingKid;
        int childType;
        boolean hikidNull;
        if (currentNode == null) {
            return null;
        }
        if (currentNode.relatives[2] != null || currentNode.data != null) {
            return null;
        }
        TSTNode currentParent = currentNode.relatives[0];
        boolean lokidNull = currentNode.relatives[1] == null;
        boolean bl = hikidNull = currentNode.relatives[3] == null;
        if (currentParent.relatives[1] == currentNode) {
            childType = 1;
        } else if (currentParent.relatives[2] == currentNode) {
            childType = 2;
        } else if (currentParent.relatives[3] == currentNode) {
            childType = 3;
        } else {
            this.rootNode = null;
            return null;
        }
        if (lokidNull && hikidNull) {
            currentParent.relatives[childType] = null;
            return currentParent;
        }
        if (lokidNull) {
            currentParent.relatives[childType] = currentNode.relatives[3];
            currentNode.relatives[3].relatives[0] = currentParent;
            return currentParent;
        }
        if (hikidNull) {
            currentParent.relatives[childType] = currentNode.relatives[1];
            currentNode.relatives[1].relatives[0] = currentParent;
            return currentParent;
        }
        int deltaHi = currentNode.relatives[3].splitchar - currentNode.splitchar;
        int deltaLo = currentNode.splitchar - currentNode.relatives[1].splitchar;
        if (deltaHi == deltaLo) {
            if (Math.random() < 0.5) {
                ++deltaHi;
            } else {
                ++deltaLo;
            }
        }
        if (deltaHi > deltaLo) {
            movingKid = 3;
            targetNode = currentNode.relatives[1];
        } else {
            movingKid = 1;
            targetNode = currentNode.relatives[3];
        }
        while (targetNode.relatives[movingKid] != null) {
            targetNode = targetNode.relatives[movingKid];
        }
        targetNode.relatives[movingKid] = currentNode.relatives[movingKid];
        currentParent.relatives[childType] = targetNode;
        targetNode.relatives[0] = currentParent;
        if (!lokidNull) {
            currentNode.relatives[1] = null;
        }
        if (!hikidNull) {
            currentNode.relatives[3] = null;
        }
        return currentParent;
    }

    protected String getKey(TSTNode node) {
        this.getKeyBuffer.setLength(0);
        this.getKeyBuffer.append(node.splitchar);
        TSTNode currentNode = node.relatives[0];
        TSTNode lastNode = node;
        while (currentNode != null) {
            if (currentNode.relatives[2] == lastNode) {
                this.getKeyBuffer.append(currentNode.splitchar);
            }
            lastNode = currentNode;
            currentNode = currentNode.relatives[0];
        }
        this.getKeyBuffer.reverse();
        return this.getKeyBuffer.toString();
    }

    public int numNodes() {
        return this.numNodes(this.rootNode);
    }

    protected int numNodes(TSTNode startingNode) {
        this.numNodes = 0;
        this.checkData = false;
        this.recursiveNodeCalculator(startingNode);
        return this.numNodes;
    }

    public int numDataNodes() {
        return this.numDataNodes(this.rootNode);
    }

    protected int numDataNodes(TSTNode startingNode) {
        this.numNodes = 0;
        this.checkData = true;
        this.recursiveNodeCalculator(startingNode);
        return this.numNodes;
    }

    private void recursiveNodeCalculator(TSTNode currentNode) {
        if (currentNode == null) {
            return;
        }
        this.recursiveNodeCalculator(currentNode.relatives[1]);
        this.recursiveNodeCalculator(currentNode.relatives[2]);
        this.recursiveNodeCalculator(currentNode.relatives[3]);
        if (this.checkData) {
            if (currentNode.data != null) {
                ++this.numNodes;
            }
        } else {
            ++this.numNodes;
        }
    }

    public void printTree() {
        System.out.println("");
        if (this.rootNode == null) {
            System.out.println("tree is empty");
            return;
        }
        System.out.println("Here's the entire tree structure:");
        this.printNodeRecursion(this.rootNode);
    }

    protected void printTree(TSTNode startingNode) {
        System.out.println("");
        if (this.rootNode == null) {
            System.out.println("subtree is empty");
            return;
        }
        System.out.println("Here's the entire subtree structure:");
        this.printNodeRecursion(startingNode);
    }

    private void printNodeRecursion(TSTNode currentNode) {
        if (currentNode == null) {
            return;
        }
        System.out.println("");
        System.out.println("( keys are delimited by vertical lines: |example key| )");
        System.out.println("info for node   |" + this.getKey(currentNode) + "|         node data: " + currentNode.data);
        if (currentNode.relatives[0] == null) {
            System.out.println("parent null");
        } else {
            System.out.println("parent key   |" + this.getKey(currentNode.relatives[0]) + "|       parent data: " + currentNode.relatives[0].data);
        }
        if (currentNode.relatives[1] == null) {
            System.out.println("lokid null");
        } else {
            System.out.println("lokid key   |" + this.getKey(currentNode.relatives[1]) + "|       lo kid data: " + currentNode.relatives[1].data);
        }
        if (currentNode.relatives[2] == null) {
            System.out.println("eqkid null");
        } else {
            System.out.println("eqkid key   |" + this.getKey(currentNode.relatives[2]) + "|       equal kid data: " + currentNode.relatives[2].data);
        }
        if (currentNode.relatives[3] == null) {
            System.out.println("hikid null");
        } else {
            System.out.println("hikid key   |" + this.getKey(currentNode.relatives[3]) + "|       hi kid data: " + currentNode.relatives[3].data);
        }
        this.printNodeRecursion(currentNode.relatives[1]);
        this.printNodeRecursion(currentNode.relatives[2]);
        this.printNodeRecursion(currentNode.relatives[3]);
    }

    public LinkedList matchDeep(String key) {
        return this.matchDeep(key, this.defaultNumReturnValues, 0.0);
    }

    public LinkedList matchDeep(String key, int maxDepth, double minSimilarity) {
        return this.matchDeep(key, this.defaultNumReturnValues, maxDepth, minSimilarity);
    }

    public LinkedList matchDeep(String key, int numReturnValues, int maxDepth, double minSimilarity) {
        this.matchResult = new LinkedList();
        this.matchNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        this.matchKey = key;
        this.searchMaxDepth = maxDepth;
        this.minStringLengthSimilarity = minSimilarity;
        if (this.searchMaxDepth == 0) {
            this.collectPrefix(key, numReturnValues);
        } else {
            this.matchDeepRecursion(this.rootNode, 0, 0, MatchDeepState.search);
        }
        this.matchInsidePath();
        return this.matchResult;
    }

    private void collectPrefix(String key, int numReturnValues) {
        LinkedList keys = this.matchPrefix(key, numReturnValues);
        for (Object o : keys) {
            String currKey = (String)o;
            if (!this.checkStringLengthSimilarity(currKey.length(), key.length())) continue;
            this.matchResult.addLast(this.get(currKey));
        }
    }

    private void matchInsidePath() {
        int n = this.matchKey.length();
        for (int i = 1; i < n; ++i) {
            this.matchInsidePath(i, n, n);
        }
        for (int j = n - 1; j >= 1; --j) {
            this.matchInsidePath(0, j, n);
        }
    }

    private void matchInsidePath(int i, int j, int n) {
        if (!this.checkStringLengthSimilarity(n, j - i)) {
            return;
        }
        String path = this.matchKey.substring(i, j);
        TSTNode currentNode = this.rootNode;
        int charIndex = 0;
        while (currentNode != null && this.matchNumReturnValues != 0) {
            int charComp = CharUtility.compareCharsAlphabetically(path.charAt(charIndex), currentNode.splitchar);
            if (charComp == 0) {
                ++charIndex;
                if (currentNode.data != null) {
                    String key = this.getKey(currentNode);
                    if (this.checkStringLengthSimilarity(this.matchKey.length(), key.length()) && !this.matchResult.contains(currentNode.data)) {
                        this.matchResult.addLast(currentNode.data);
                        --this.matchNumReturnValues;
                    }
                }
                if (charIndex == path.length()) {
                    return;
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                currentNode = currentNode.relatives[1];
                continue;
            }
            currentNode = currentNode.relatives[3];
        }
        return;
    }

    private void matchDeepRecursion(TSTNode currentNode, int currentDepth, int charIndex, MatchDeepState state) {
        if (currentNode == null || this.matchNumReturnValues == 0 || charIndex >= this.matchKey.length()) {
            return;
        }
        if (state == MatchDeepState.search && this.searchMaxDepth >= 0 && currentDepth > this.searchMaxDepth) {
            return;
        }
        if (state == MatchDeepState.collect) {
            if (currentNode.data != null) {
                String key = this.getKey(currentNode);
                if (this.checkStringLengthSimilarity(this.matchKey.length(), key.length())) {
                    this.matchResult.addLast(currentNode.data);
                    --this.matchNumReturnValues;
                }
            }
            this.matchDeepRecursion(currentNode.relatives[2], -1, -1, MatchDeepState.collect);
            this.matchDeepRecursion(currentNode.relatives[1], -1, -1, MatchDeepState.collect);
            this.matchDeepRecursion(currentNode.relatives[3], -1, -1, MatchDeepState.collect);
            return;
        }
        int charComp = CharUtility.compareCharsAlphabetically(this.matchKey.charAt(charIndex), currentNode.splitchar);
        if (charComp < 0) {
            if (currentNode.relatives[1] == null && state == MatchDeepState.scan) {
                this.matchDeepRecursion(currentNode.relatives[2], currentDepth + 1, 0, MatchDeepState.search);
                this.matchDeepRecursion(currentNode.relatives[3], currentDepth, 0, MatchDeepState.search);
            } else if (state == MatchDeepState.scan) {
                this.matchDeepRecursion(currentNode.relatives[1], currentDepth, charIndex, state);
                this.matchDeepRecursion(currentNode.relatives[2], currentDepth + 1, charIndex, state);
            } else {
                this.matchDeepRecursion(currentNode.relatives[1], currentDepth, 0, MatchDeepState.search);
                this.matchDeepRecursion(currentNode.relatives[2], currentDepth + 1, 0, MatchDeepState.search);
                this.matchDeepRecursion(currentNode.relatives[3], currentDepth, 0, MatchDeepState.search);
            }
        } else if (charComp > 0) {
            if (currentNode.relatives[3] == null && state == MatchDeepState.scan) {
                this.matchDeepRecursion(currentNode.relatives[2], currentDepth + 1, 0, MatchDeepState.search);
                this.matchDeepRecursion(currentNode.relatives[1], currentDepth, 0, MatchDeepState.search);
            } else if (state == MatchDeepState.scan) {
                this.matchDeepRecursion(currentNode.relatives[3], currentDepth, charIndex, state);
                this.matchDeepRecursion(currentNode.relatives[2], currentDepth + 1, charIndex, state);
            } else {
                this.matchDeepRecursion(currentNode.relatives[3], currentDepth, 0, MatchDeepState.search);
                this.matchDeepRecursion(currentNode.relatives[2], currentDepth + 1, 0, MatchDeepState.search);
                this.matchDeepRecursion(currentNode.relatives[1], currentDepth, 0, MatchDeepState.search);
            }
        } else if (charComp == 0) {
            if (this.matchKey.length() == charIndex + 1) {
                String key;
                if (currentNode.data != null && this.checkStringLengthSimilarity(charIndex + 1, (key = this.getKey(currentNode)).length())) {
                    this.matchResult.addLast(currentNode.data);
                    --this.matchNumReturnValues;
                }
                this.matchDeepRecursion(currentNode.relatives[2], -1, -1, MatchDeepState.collect);
                this.matchDeepRecursion(currentNode.relatives[1], currentDepth, 0, MatchDeepState.search);
                this.matchDeepRecursion(currentNode.relatives[3], currentDepth, 0, MatchDeepState.search);
            } else {
                this.matchDeepRecursion(currentNode.relatives[2], currentDepth + 1, charIndex + 1, MatchDeepState.scan);
                this.matchDeepRecursion(currentNode.relatives[1], currentDepth, 0, MatchDeepState.search);
                this.matchDeepRecursion(currentNode.relatives[3], currentDepth, 0, MatchDeepState.search);
            }
        }
    }

    private boolean checkStringLengthSimilarity(int len1, int len2) {
        int minLen = len1 > len2 ? len2 : len1;
        int maxLen = len1 > len2 ? len1 : len2;
        return (double)((float)minLen / (float)maxLen) >= this.minStringLengthSimilarity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchDeepState {
        search,
        scan,
        collect;

    }

    protected class TSTNode {
        protected static final int PARENT = 0;
        protected static final int LOKID = 1;
        protected static final int EQKID = 2;
        protected static final int HIKID = 3;
        protected char splitchar;
        protected TSTNode[] relatives = new TSTNode[4];
        protected Object data;

        protected TSTNode(char splitchar, TSTNode parent) {
            this.splitchar = splitchar;
            this.relatives[0] = parent;
        }
    }
}

