/*
 * Decompiled with CFR 0.152.
 */
package com.wallyflint.test.ut;

import com.wallyflint.one_point_one.collections.TernarySearchTreeModified;
import java.util.LinkedList;
import junit.framework.TestCase;

public class TernarySearchTreeModifiedTest
extends TestCase {
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMatchSubstring() throws Exception {
        TernarySearchTreeModified tree = new TernarySearchTreeModified();
        tree.put("predvsem samo brez panike", "predvsem samo brez panike");
        tree.put("samo brez panike", "samo brez panike");
        tree.put("predvsem", "predvsem");
        tree.put("prosim", "prosim");
        tree.put("predvsem samo", "predvsem samo");
        LinkedList match = tree.matchDeep("predvsem");
        System.out.println("tree[predvsem]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 3);
        match = tree.matchDeep("predvsem", -1, 0.5);
        System.out.println("tree[predvsem(0.5)]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 2);
        match = tree.matchDeep("samo");
        System.out.println("tree[samo]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 3);
        match = tree.matchDeep("pred");
        System.out.println("tree[pred]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 3);
        match = tree.matchDeep("panike");
        System.out.println("tree[panike]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 2);
        match = tree.matchDeep("predvsem drugo");
        System.out.println("tree[predvsem drugo]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 1);
        match = tree.matchDeep("predvsem samooo");
        System.out.println("tree[predvsem samooo]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 2);
        match = tree.matchDeep("predvsem samooo", -1, 0.8);
        System.out.println("tree[predvsem samooo(0.8)]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 1);
        match = tree.matchDeep("drugo predvsem samooo");
        System.out.println("tree[drugo predvsem samooo]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 2);
        match = tree.matchDeep("prosim");
        System.out.println("tree[prosim]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 1);
    }

    public void testProsim() throws Exception {
        TernarySearchTreeModified tree = new TernarySearchTreeModified();
        tree.put("predvsem", "predvsem");
        tree.put("prosim", "prosim");
        LinkedList match = tree.matchDeep("prosim");
        System.out.println("tree[prosim]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 1);
    }

    public void testA() throws Exception {
        TernarySearchTreeModified tree = new TernarySearchTreeModified();
        tree.put("ca", "ca");
        tree.put("cb", "cb");
        tree.put("cc", "cc");
        tree.put("ccde", "ccde");
        tree.put("ccdede", "ccdede");
        tree.put("ccdf", "ccdf");
        tree.put("ccdfde", "ccdfde");
        LinkedList match = tree.matchDeep("a");
        System.out.println("tree[a]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 1);
        match = tree.matchDeep("de", 2, 0.0);
        System.out.println("tree[de]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 2);
        match = tree.matchDeep("de", 4, 0.0);
        System.out.println("tree[de]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 3);
        match = tree.matchDeep("d");
        System.out.println("tree[d]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 4);
        match = tree.matchDeep("c");
        System.out.println("tree[c]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 7);
        match = tree.matchDeep("cc");
        System.out.println("tree[cc]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 5);
        match = tree.matchDeep("b");
        System.out.println("tree[b]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 1);
    }

    public void testB() throws Exception {
        TernarySearchTreeModified tree = new TernarySearchTreeModified();
        tree.put("ca", "ca");
        tree.put("cb", "cb");
        tree.put("cc", "cc");
        LinkedList match = tree.matchDeep("b");
        System.out.println("tree[b]=" + match);
        TernarySearchTreeModifiedTest.assertTrue(match.size() == 1);
    }
}

