/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;

public class AlawFormatConversionProvider
extends TEncodingFormatConversionProvider {
    private static final int ALL = -1;
    public static AudioFormat.Encoding ENC_PCM_SIGNED = new AudioFormat.Encoding("PCM_SIGNED");
    public static AudioFormat.Encoding ENC_PCM_UNSIGNED = new AudioFormat.Encoding("PCM_UNSIGNED");
    public static AudioFormat.Encoding ENC_ULAW = new AudioFormat.Encoding("ULAW");
    public static AudioFormat.Encoding ENC_ALAW = new AudioFormat.Encoding("ALAW");
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(ENC_PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(ENC_ULAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_ULAW, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_ALAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_ALAW, -1.0f, 8, -1, -1, -1.0f, true)};
    private static final int UNSIGNED8 = 1;
    private static final int SIGNED8 = 2;
    private static final int BIG_ENDIAN16 = 3;
    private static final int LITTLE_ENDIAN16 = 4;
    private static final int ULAW = 5;

    public AlawFormatConversionProvider() {
        super(Arrays.asList(OUTPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (AudioFormats.matches(sourceFormat, targetFormat)) {
            return sourceStream;
        }
        if (AlawFormatConversionProvider.doMatch(targetFormat.getFrameRate(), sourceFormat.getFrameRate()) && AlawFormatConversionProvider.doMatch(targetFormat.getChannels(), sourceFormat.getChannels())) {
            if (AlawFormatConversionProvider.doMatch(targetFormat.getSampleSizeInBits(), 8) && targetFormat.getEncoding() == ENC_ALAW) {
                return new ToAlawStream(sourceStream);
            }
            if (AlawFormatConversionProvider.doMatch(sourceFormat.getSampleSizeInBits(), 8) && sourceFormat.getEncoding() == ENC_ALAW) {
                return new FromAlawStream(sourceStream, targetFormat);
            }
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    private boolean isSupportedFormat(AudioFormat format) {
        return this.getConvertType(format) != 0;
    }

    protected int getConvertType(AudioFormat af) {
        int result = 0;
        AudioFormat.Encoding encoding = af.getEncoding();
        boolean bigEndian = af.isBigEndian();
        int ssib = af.getSampleSizeInBits();
        if (encoding.equals(ENC_PCM_SIGNED)) {
            if (ssib == 16) {
                result = bigEndian ? 3 : 4;
            } else if (ssib == 8) {
                result = 2;
            }
        } else if (encoding.equals(ENC_PCM_UNSIGNED)) {
            if (ssib == 8) {
                result = 1;
            }
        } else if (encoding.equals(ENC_ULAW)) {
            result = 5;
        }
        return result;
    }

    class FromAlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public FromAlawStream(AudioInputStream sourceStream, AudioFormat targetFormat) {
            super(sourceStream, new AudioFormat(targetFormat.getEncoding(), sourceStream.getFormat().getSampleRate(), targetFormat.getSampleSizeInBits(), sourceStream.getFormat().getChannels(), targetFormat.getSampleSizeInBits() * sourceStream.getFormat().getChannels() / 8, sourceStream.getFormat().getFrameRate(), targetFormat.isBigEndian()));
            this.convertType = AlawFormatConversionProvider.this.getConvertType(this.getFormat());
            if (targetFormat.getSampleSizeInBits() == 8) {
                this.enableConvertInPlace();
            }
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.alaw2pcm8(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.alaw2pcm8(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 3: {
                    TConversionTool.alaw2pcm16(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 4: {
                    TConversionTool.alaw2pcm16(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 5: {
                    TConversionTool.alaw2ulaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                }
            }
            return inFrameCount;
        }

        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.format.getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.alaw2pcm8(buffer, byteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.alaw2pcm8(buffer, byteOffset, sampleCount, true);
                    break;
                }
                case 5: {
                    TConversionTool.alaw2ulaw(buffer, byteOffset, sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("FromAlawStream: Call to convertInPlace, but it cannot convert in place.");
                }
            }
        }
    }

    class ToAlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public ToAlawStream(AudioInputStream sourceStream) {
            super(sourceStream, new AudioFormat(ENC_ALAW, sourceStream.getFormat().getSampleRate(), 8, sourceStream.getFormat().getChannels(), sourceStream.getFormat().getChannels(), sourceStream.getFormat().getFrameRate(), sourceStream.getFormat().isBigEndian()));
            this.convertType = AlawFormatConversionProvider.this.getConvertType(sourceStream.getFormat());
            if (sourceStream.getFormat().getSampleSizeInBits() == 8) {
                this.enableConvertInPlace();
            }
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 3: {
                    TConversionTool.pcm162alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 4: {
                    TConversionTool.pcm162alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 5: {
                    TConversionTool.ulaw2alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                }
            }
            return inFrameCount;
        }

        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82alaw(buffer, byteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82alaw(buffer, byteOffset, sampleCount, true);
                    break;
                }
                case 5: {
                    TConversionTool.ulaw2alaw(buffer, byteOffset, sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("ToAlawStream: Call to convertInPlace, but it cannot convert in place.");
                }
            }
        }
    }
}

