/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;

public class ImaAdpcmFormatConversionProvider
extends TEncodingFormatConversionProvider {
    private static final AudioFormat.Encoding IMA_ADPCM = new AudioFormat.Encoding("IMA_ADPCM");
    private static final AudioFormat.Encoding PCM_SIGNED = new AudioFormat.Encoding("PCM_SIGNED");
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(IMA_ADPCM, -1.0f, 4, 1, -1, -1.0f, false), new AudioFormat(IMA_ADPCM, -1.0f, 4, 1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true)};
    static final int[] indexTable = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
    static final int[] stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};

    public ImaAdpcmFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(INPUT_FORMATS));
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream) {
        TSynchronousFilteredAudioInputStream convertedAudioInputStream = null;
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">ImaAdpcmFormatConversionProvider.getAudioInputStream(): begin");
            TDebug.out("checking if conversion supported");
            TDebug.out("from: " + audioInputStream.getFormat());
            TDebug.out("to: " + targetFormat);
        }
        if (this.isConversionSupported(targetFormat = this.getDefaultTargetFormat(targetFormat, audioInputStream.getFormat()), audioInputStream.getFormat())) {
            if (targetFormat.getEncoding().equals(IMA_ADPCM)) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("conversion supported; trying to create EncodedImaAdpcmAudioInputStream");
                }
                convertedAudioInputStream = new EncodedImaAdpcmAudioInputStream(audioInputStream, targetFormat);
            } else {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("conversion supported; trying to create DecodedImaAdpcmAudioInputStream");
                }
                convertedAudioInputStream = new DecodedImaAdpcmAudioInputStream(audioInputStream, targetFormat);
            }
        } else {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<conversion not supported; throwing IllegalArgumentException");
            }
            throw new IllegalArgumentException("conversion not supported");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<ImaAdpcmFormatConversionProvider.getAudioInputStream(): end");
        }
        return convertedAudioInputStream;
    }

    protected AudioFormat getDefaultTargetFormat(AudioFormat targetFormat, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("ImaAdpcmFormatConversionProvider.getDefaultTargetFormat(): target format: " + targetFormat);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("ImaAdpcmFormatConversionProvider.getDefaultTargetFormat(): source format: " + sourceFormat);
        }
        AudioFormat newTargetFormat = null;
        for (AudioFormat format : this.getCollectionTargetFormats()) {
            if (!AudioFormats.matches(targetFormat, format)) continue;
            newTargetFormat = format;
        }
        if (newTargetFormat == null) {
            throw new IllegalArgumentException("conversion not supported");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("ImaAdpcmFormatConversionProvider.getDefaultTargetFormat(): new target format: " + newTargetFormat);
        }
        newTargetFormat = new AudioFormat(targetFormat.getEncoding(), sourceFormat.getSampleRate(), newTargetFormat.getSampleSizeInBits(), newTargetFormat.getChannels(), newTargetFormat.getFrameSize(), sourceFormat.getSampleRate(), newTargetFormat.isBigEndian());
        if (TDebug.TraceAudioConverter) {
            TDebug.out("ImaAdpcmFormatConversionProvider.getDefaultTargetFormat(): really new target format: " + newTargetFormat);
        }
        return newTargetFormat;
    }

    private static class ImaAdpcmState {
        public int valprev;
        public int index;

        private ImaAdpcmState() {
        }
    }

    public static class EncodedImaAdpcmAudioInputStream
    extends TSynchronousFilteredAudioInputStream {
        private ImaAdpcmState m_state;

        public EncodedImaAdpcmAudioInputStream(AudioInputStream decodedStream, AudioFormat outputFormat) {
            super(decodedStream, outputFormat);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("EncodedImaAdpcmAudioInputStream.<init>(): begin");
            }
            this.m_state = new ImaAdpcmState();
            if (TDebug.TraceAudioConverter) {
                TDebug.out("EncodedImaAdpcmAudioInputStream.<init>(): end");
            }
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("EncodedImaAdpcmAudioInputStream.convert(): begin");
            }
            int outputbuffer = 0;
            int inp = 0;
            int outp = outByteOffset;
            int valpred = this.m_state.valprev;
            int index = this.m_state.index;
            int step = stepsizeTable[index];
            boolean bufferstep = true;
            for (int len = inFrameCount; len > 0; --len) {
                int sign;
                int val = this.isBigEndian() ? inBuffer[inp] << 8 | inBuffer[inp + 1] & 0xFF : inBuffer[inp + 1] << 8 | inBuffer[inp] & 0xFF;
                inp += 2;
                int diff = val - valpred;
                int n = sign = diff < 0 ? 8 : 0;
                if (sign != 0) {
                    diff = -diff;
                }
                int delta = 0;
                int vpdiff = step >> 3;
                if (diff >= step) {
                    delta = 4;
                    diff -= step;
                    vpdiff += step;
                }
                if (diff >= (step >>= 1)) {
                    delta |= 2;
                    diff -= step;
                    vpdiff += step;
                }
                if (diff >= (step >>= 1)) {
                    delta |= 1;
                    vpdiff += step;
                }
                valpred = sign != 0 ? (valpred -= vpdiff) : (valpred += vpdiff);
                if (valpred > Short.MAX_VALUE) {
                    valpred = Short.MAX_VALUE;
                } else if (valpred < Short.MIN_VALUE) {
                    valpred = Short.MIN_VALUE;
                }
                if ((index += indexTable[delta |= sign]) < 0) {
                    index = 0;
                }
                if (index > 88) {
                    index = 88;
                }
                step = stepsizeTable[index];
                if (bufferstep) {
                    outputbuffer = delta << 4 & 0xF0;
                } else {
                    outBuffer[outp++] = (byte)(delta & 0xF | outputbuffer);
                }
                bufferstep = !bufferstep;
            }
            if (!bufferstep) {
                outBuffer[outp++] = (byte)outputbuffer;
            }
            this.m_state.valprev = valpred;
            this.m_state.index = index;
            if (TDebug.TraceAudioConverter) {
                TDebug.out("EncodedImaAdpcmAudioInputStream.convert(): end");
            }
            return inFrameCount;
        }

        private int getSampleSizeInBytes() {
            return this.getFormat().getFrameSize() / this.getFormat().getChannels();
        }

        private int getFrameSize() {
            return this.getFormat().getFrameSize();
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }
    }

    public static class DecodedImaAdpcmAudioInputStream
    extends TSynchronousFilteredAudioInputStream {
        private ImaAdpcmState m_state;

        public DecodedImaAdpcmAudioInputStream(AudioInputStream encodedStream, AudioFormat outputFormat) {
            super(encodedStream, outputFormat);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedImaAdpcmAudioInputStream.<init>(): begin");
            }
            this.m_state = new ImaAdpcmState();
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedImaAdpcmAudioInputStream.<init>(): end");
            }
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedImaAdpcmAudioInputStream.convert(): begin");
            }
            int inputbuffer = 0;
            int inp = 0;
            int outp = outByteOffset;
            int valpred = this.m_state.valprev;
            int index = this.m_state.index;
            int step = stepsizeTable[index];
            boolean bufferstep = false;
            for (int len = inFrameCount; len > 0; --len) {
                int delta;
                if (bufferstep) {
                    delta = inputbuffer & 0xF;
                } else {
                    inputbuffer = inBuffer[inp];
                    ++inp;
                    delta = inputbuffer >> 4 & 0xF;
                }
                boolean bl = bufferstep = !bufferstep;
                if ((index += indexTable[delta]) < 0) {
                    index = 0;
                }
                if (index > 88) {
                    index = 88;
                }
                int sign = delta & 8;
                int vpdiff = step >> 3;
                if (((delta &= 7) & 4) != 0) {
                    vpdiff += step;
                }
                if ((delta & 2) != 0) {
                    vpdiff += step >> 1;
                }
                if ((delta & 1) != 0) {
                    vpdiff += step >> 2;
                }
                valpred = sign != 0 ? (valpred -= vpdiff) : (valpred += vpdiff);
                if (valpred > Short.MAX_VALUE) {
                    valpred = Short.MAX_VALUE;
                } else if (valpred < Short.MIN_VALUE) {
                    valpred = Short.MIN_VALUE;
                }
                step = stepsizeTable[index];
                if (this.isBigEndian()) {
                    outBuffer[outp++] = (byte)(valpred >> 8);
                    outBuffer[outp++] = (byte)(valpred & 0xFF);
                    continue;
                }
                outBuffer[outp++] = (byte)(valpred & 0xFF);
                outBuffer[outp++] = (byte)(valpred >> 8);
            }
            this.m_state.valprev = valpred;
            this.m_state.index = index;
            if (TDebug.TraceAudioConverter) {
                TDebug.out("DecodedImaAdpcmAudioInputStream.convert(): end");
            }
            return inFrameCount;
        }

        private int getSampleSizeInBytes() {
            return this.getFormat().getFrameSize() / this.getFormat().getChannels();
        }

        private int getFrameSize() {
            return this.getFormat().getFrameSize();
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }
    }
}

