/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.FloatSampleBuffer;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

public class SampleRateConversionProvider
extends TSimpleFormatConversionProvider {
    public static AudioFormat.Encoding PCM_SIGNED = AudioFormat.Encoding.PCM_SIGNED;
    public static AudioFormat.Encoding PCM_UNSIGNED = AudioFormat.Encoding.PCM_UNSIGNED;
    private static final boolean DEBUG_STREAM = false;
    private static final boolean DEBUG_STREAM_PROBLEMS = false;
    private static final int ALL = -1;
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, true)};
    private static final float[] commonSampleRates = new float[]{8000.0f, 11025.0f, 12000.0f, 16000.0f, 22050.0f, 24000.0f, 32000.0f, 44100.0f, 48000.0f, 64000.0f, 88200.0f, 96000.0f};

    public SampleRateConversionProvider() {
        super(Arrays.asList(OUTPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (AudioFormats.matches(sourceFormat, targetFormat)) {
            return sourceStream;
        }
        if ((targetFormat = this.replaceNotSpecified(sourceFormat, targetFormat)).getSampleRate() != -1.0f && sourceFormat.getSampleRate() != -1.0f && targetFormat.getChannels() != -1 && sourceFormat.getChannels() != -1 && targetFormat.getSampleSizeInBits() != -1 && sourceFormat.getSampleSizeInBits() != -1 && this.isConversionSupported(sourceFormat, targetFormat)) {
            return new SampleRateConverterStream(sourceStream, targetFormat);
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    private static AudioFormat replaceSampleRate(AudioFormat format, float newSampleRate) {
        if (format.getSampleRate() == newSampleRate) {
            return format;
        }
        return new AudioFormat(format.getEncoding(), newSampleRate, format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), newSampleRate, format.isBigEndian());
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">SampleRateConversionProvider.getTargetFormats(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("checking out possible target formats");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to  : " + targetEncoding);
        }
        float sourceSampleRate = sourceFormat.getSampleRate();
        if (this.isConversionSupported(targetEncoding, sourceFormat = SampleRateConversionProvider.replaceSampleRate(sourceFormat, -1.0f))) {
            ArraySet<AudioFormat> result = new ArraySet<AudioFormat>();
            for (AudioFormat targetFormat : this.getCollectionTargetFormats()) {
                if (!this.isConversionSupported(targetFormat = this.replaceNotSpecified(sourceFormat, targetFormat), sourceFormat)) continue;
                result.add(targetFormat);
            }
            if (result.size() > 0 && sourceSampleRate != -1.0f) {
                int count = result.size();
                for (int i = 0; i < count; ++i) {
                    AudioFormat format = (AudioFormat)result.get(i);
                    for (int j = 0; j < commonSampleRates.length; ++j) {
                        if (SampleRateConversionProvider.doMatch(sourceSampleRate, commonSampleRates[j])) continue;
                        result.add(SampleRateConversionProvider.replaceSampleRate(format, commonSampleRates[j]));
                    }
                }
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<found " + result.size() + " matching formats.");
            }
            return result.toArray(EMPTY_FORMAT_ARRAY);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<returning empty array.");
        }
        return EMPTY_FORMAT_ARRAY;
    }

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        boolean result;
        boolean bl = result = (targetFormat.getSampleRate() == -1.0f || targetFormat.getSampleRate() == -1.0f || !SampleRateConversionProvider.doMatch(targetFormat.getSampleRate(), sourceFormat.getSampleRate()) && SampleRateConversionProvider.doMatch(targetFormat.getChannels(), sourceFormat.getChannels())) && AudioUtils.containsFormat(sourceFormat, this.getCollectionSourceFormats().iterator()) && AudioUtils.containsFormat(targetFormat, this.getCollectionTargetFormats().iterator());
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">SampleRateConverter: isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to  : " + targetFormat);
            TDebug.out("< result : " + result);
        }
        return result;
    }

    protected static long convertLength(AudioFormat sourceFormat, AudioFormat targetFormat, long sourceLength) {
        if (sourceLength == -1L) {
            return sourceLength;
        }
        return Math.round(targetFormat.getSampleRate() / sourceFormat.getSampleRate() * (float)sourceLength);
    }

    public static class SRCAudioFormat
    extends AudioFormat {
        private float sampleRate;

        public SRCAudioFormat(AudioFormat targetFormat) {
            super(targetFormat.getEncoding(), targetFormat.getSampleRate(), targetFormat.getSampleSizeInBits(), targetFormat.getChannels(), targetFormat.getChannels() * targetFormat.getSampleSizeInBits() / 8, targetFormat.getSampleRate(), targetFormat.isBigEndian());
            this.sampleRate = targetFormat.getSampleRate();
        }

        public void setSampleRate(float sr) {
            if (sr > 0.0f) {
                this.sampleRate = sr;
            }
        }

        public float getSampleRate() {
            return this.sampleRate;
        }

        public float getFrameRate() {
            return this.sampleRate;
        }
    }

    public static class SampleRateConverterStream
    extends AudioInputStream {
        private FloatSampleBuffer thisBuffer = null;
        private FloatSampleBuffer writeBuffer = null;
        private byte[] byteBuffer;
        private AudioInputStream sourceStream;
        private float sourceSampleRate;
        private float targetSampleRate;
        private double dPos;
        public static final int SAMPLE_AND_HOLD = 1;
        public static final int LINEAR_INTERPOLATION = 2;
        public static final int RESAMPLE = 3;
        private int sourceBufferTime;
        private int conversionAlgorithm = 2;
        private FloatSampleBuffer historyBuffer = null;
        private int minimumSamplesInHistory = 1;
        private boolean thisBufferValid = false;
        private long testInFramesRead = 0L;
        private long testOutFramesReturned = 0L;

        public SampleRateConverterStream(AudioInputStream sourceStream, AudioFormat targetFormat) {
            super(sourceStream, new SRCAudioFormat(targetFormat), SampleRateConversionProvider.convertLength(sourceStream.getFormat(), targetFormat, sourceStream.getFrameLength()));
            if (TDebug.TraceAudioConverter) {
                TDebug.out("SampleRateConverterStream: <init>");
            }
            this.sourceStream = sourceStream;
            this.sourceSampleRate = sourceStream.getFormat().getSampleRate();
            this.targetSampleRate = targetFormat.getSampleRate();
            this.dPos = 0.0;
            this.sourceBufferTime = 100;
            this.resizeBuffers();
            this.flush();
        }

        private synchronized void resizeBuffers() {
            int bufferSize = (int)AudioUtils.millis2Frames((long)this.sourceBufferTime, this.sourceSampleRate);
            if (bufferSize < this.minimumSamplesInHistory) {
                bufferSize = this.minimumSamplesInHistory;
            }
            if ((double)bufferSize < this.outSamples2inSamples(1.0)) {
                bufferSize = this.roundUp(this.outSamples2inSamples(1.0));
            }
            if (this.historyBuffer == null) {
                this.historyBuffer = new FloatSampleBuffer(this.sourceStream.getFormat().getChannels(), bufferSize, this.sourceSampleRate);
                this.historyBuffer.makeSilence();
            }
            this.historyBuffer.changeSampleCount(bufferSize, true);
            if (this.thisBuffer == null) {
                this.thisBuffer = new FloatSampleBuffer(this.sourceStream.getFormat().getChannels(), bufferSize, this.sourceSampleRate);
            }
            this.thisBuffer.changeSampleCount(bufferSize, true);
        }

        private synchronized void readFromByteSourceStream() throws IOException {
            int thisRead;
            int byteCount = this.thisBuffer.getByteArrayBufferSize(this.getFormat());
            if (this.byteBuffer == null || this.byteBuffer.length < byteCount) {
                this.byteBuffer = new byte[byteCount];
            }
            int bytesRead = 0;
            do {
                if ((thisRead = this.sourceStream.read(this.byteBuffer, bytesRead, byteCount - bytesRead)) <= 0) continue;
                bytesRead += thisRead;
            } while (bytesRead < byteCount && thisRead > 0);
            if (bytesRead == 0) {
                this.close();
            } else {
                this.thisBuffer.initFromByteArray(this.byteBuffer, 0, bytesRead, this.sourceStream.getFormat());
            }
        }

        private synchronized void readFromFloatSourceStream() throws IOException {
        }

        private synchronized void readFromSourceStream() throws IOException {
            if (this.isClosed()) {
                return;
            }
            int oldSampleCount = this.thisBuffer.getSampleCount();
            FloatSampleBuffer newBuffer = this.historyBuffer;
            this.historyBuffer = this.thisBuffer;
            this.thisBuffer = newBuffer;
            if (this.sourceStream.getFrameLength() != -1L && (long)this.thisBuffer.getSampleCount() + this.testInFramesRead > this.sourceStream.getFrameLength()) {
                if (this.sourceStream.getFrameLength() - this.testInFramesRead <= 0L) {
                    this.close();
                    return;
                }
                this.thisBuffer.changeSampleCount((int)(this.sourceStream.getFrameLength() - this.testInFramesRead), false);
            }
            this.readFromByteSourceStream();
            if (TDebug.TraceAudioConverter) {
                this.testInFramesRead += (long)this.thisBuffer.getSampleCount();
            }
            double inc = this.outSamples2inSamples(1.0);
            if (!this.thisBufferValid) {
                this.thisBufferValid = true;
                this.dPos = 0.0;
            } else {
                double temp = this.dPos;
                this.dPos -= (double)oldSampleCount;
                if ((this.dPos > inc || this.dPos < -inc) && this.roundDown(this.dPos) != 0) {
                    this.dPos = 0.0;
                }
            }
        }

        private int roundDown(double a) {
            return (int)Math.floor(a);
        }

        private int roundUp(double a) {
            return (int)Math.ceil(a);
        }

        private void convertSampleAndHold(float[] inSamples, double inSampleOffset, int inSampleCount, double increment, float[] outSamples, int outSampleOffset, int outSampleCount, float[] history, int historyLength) {
            for (int i = 0; i < outSampleCount; ++i) {
                int iInIndex = this.roundDown(inSampleOffset + increment * (double)i);
                if (iInIndex < 0) {
                    outSamples[i + outSampleOffset] = history[iInIndex + historyLength];
                    continue;
                }
                if (iInIndex >= inSampleCount) continue;
                outSamples[i + outSampleOffset] = inSamples[iInIndex];
            }
        }

        private void convertLinearInterpolation(float[] inSamples, double inSampleOffset, int inSampleCount, double increment, float[] outSamples, int outSampleOffset, int outSampleCount, float[] history, int historyLength) {
            for (int i = 0; i < outSampleCount; ++i) {
                try {
                    double dInIndex = inSampleOffset + increment * (double)i - 1.0;
                    int iInIndex = (int)Math.floor(dInIndex);
                    double factor = 1.0 - (dInIndex - (double)iInIndex);
                    float value = 0.0f;
                    for (int x = 0; x < 2; ++x) {
                        if (iInIndex < inSampleCount) {
                            if (iInIndex < 0) {
                                int histIndex = iInIndex + historyLength;
                                if (histIndex >= 0) {
                                    value = (float)((double)value + (double)history[histIndex] * factor);
                                }
                            } else {
                                value = (float)((double)value + (double)inSamples[iInIndex] * factor);
                            }
                        }
                        factor = 1.0 - factor;
                        ++iInIndex;
                    }
                    outSamples[i + outSampleOffset] = value;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    // empty catch block
                }
            }
        }

        private double inSamples2outSamples(double inSamples) {
            return inSamples * (double)this.targetSampleRate / (double)this.sourceSampleRate;
        }

        private double outSamples2inSamples(double outSamples) {
            return outSamples * (double)this.sourceSampleRate / (double)this.targetSampleRate;
        }

        public synchronized int read(FloatSampleBuffer outBuffer) throws IOException {
            int writeCount;
            if (this.isClosed()) {
                return -1;
            }
            if (outBuffer.getChannelCount() != this.thisBuffer.getChannelCount()) {
                throw new IllegalArgumentException("passed buffer has different channel count");
            }
            if (outBuffer.getSampleCount() == 0) {
                return 0;
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out(">SamplerateConverterStream.read(" + outBuffer.getSampleCount() + "frames)");
            }
            double increment = this.outSamples2inSamples(1.0);
            int writtenSamples = 0;
            do {
                int inSampleCount = this.thisBuffer.getSampleCount();
                if (this.roundDown(this.dPos) >= inSampleCount || !this.thisBufferValid) {
                    this.readFromSourceStream();
                    if (this.isClosed()) break;
                    inSampleCount = this.thisBuffer.getSampleCount();
                }
                if (this.roundDown(this.outSamples2inSamples(writeCount = outBuffer.getSampleCount() - writtenSamples) + this.dPos) >= inSampleCount) {
                    int lastOutIndex = this.roundUp(this.inSamples2outSamples((double)inSampleCount - this.dPos));
                    while (this.roundDown(this.outSamples2inSamples(lastOutIndex) + this.dPos) >= inSampleCount) {
                        --lastOutIndex;
                    }
                    writeCount = lastOutIndex + 1;
                }
                block6: for (int channel = 0; channel < outBuffer.getChannelCount(); ++channel) {
                    float[] inSamples = this.thisBuffer.getChannel(channel);
                    float[] outSamples = outBuffer.getChannel(channel);
                    float[] history = this.historyBuffer.getChannel(channel);
                    switch (this.conversionAlgorithm) {
                        case 1: {
                            this.convertSampleAndHold(inSamples, this.dPos, inSampleCount, increment, outSamples, writtenSamples, writeCount, history, this.historyBuffer.getSampleCount());
                            continue block6;
                        }
                        case 2: {
                            this.convertLinearInterpolation(inSamples, this.dPos, inSampleCount, increment, outSamples, writtenSamples, writeCount, history, this.historyBuffer.getSampleCount());
                        }
                    }
                }
                this.dPos += this.outSamples2inSamples(writeCount);
            } while (!this.isClosed() && (writtenSamples += writeCount) < outBuffer.getSampleCount());
            if (writtenSamples < outBuffer.getSampleCount()) {
                outBuffer.changeSampleCount(writtenSamples, true);
            }
            if (TDebug.TraceAudioConverter) {
                this.testOutFramesReturned += (long)outBuffer.getSampleCount();
                TDebug.out("< return " + outBuffer.getSampleCount() + "frames. Total=" + this.testOutFramesReturned + " frames. Read total " + this.testInFramesRead + " frames from source stream");
            }
            return outBuffer.getSampleCount();
        }

        protected double sourceFrames2targetFrames(double sourceFrames) {
            return (double)(this.targetSampleRate / this.sourceSampleRate) * sourceFrames;
        }

        protected double targetFrames2sourceFrames(double targetFrames) {
            return (double)(this.sourceSampleRate / this.targetSampleRate) * targetFrames;
        }

        protected long sourceBytes2targetBytes(long sourceBytes) {
            long sourceFrames = sourceBytes / (long)this.getSourceFrameSize();
            long targetFrames = (long)this.sourceFrames2targetFrames(sourceFrames);
            return targetFrames * (long)this.getFrameSize();
        }

        protected long targetBytes2sourceBytes(long targetBytes) {
            long targetFrames = targetBytes / (long)this.getFrameSize();
            long sourceFrames = (long)this.targetFrames2sourceFrames(targetFrames);
            return sourceFrames * (long)this.getSourceFrameSize();
        }

        public int getFrameSize() {
            return this.getFormat().getFrameSize();
        }

        public int getSourceFrameSize() {
            return this.sourceStream.getFormat().getFrameSize();
        }

        public int read() throws IOException {
            if (this.getFormat().getFrameSize() != 1) {
                throw new IOException("frame size must be 1 to read a single byte");
            }
            byte[] temp = new byte[1];
            int result = this.read(temp);
            if (result <= 0) {
                return -1;
            }
            return temp[0] & 0xFF;
        }

        public int read(byte[] abData) throws IOException {
            return this.read(abData, 0, abData.length);
        }

        public int read(byte[] abData, int nOffset, int nLength) throws IOException {
            if (this.isClosed()) {
                return -1;
            }
            int frameCount = nLength / this.getFrameSize();
            if (this.writeBuffer == null) {
                this.writeBuffer = new FloatSampleBuffer(this.getFormat().getChannels(), frameCount, this.getFormat().getSampleRate());
            } else {
                this.writeBuffer.changeSampleCount(frameCount, false);
            }
            int writtenSamples = this.read(this.writeBuffer);
            if (writtenSamples == -1) {
                return -1;
            }
            int written = this.writeBuffer.convertToByteArray(abData, nOffset, this.getFormat());
            return written;
        }

        public synchronized long skip(long nSkip) throws IOException {
            long sourceSkip = this.targetBytes2sourceBytes(nSkip);
            long sourceSkipped = this.sourceStream.skip(sourceSkip);
            this.flush();
            return this.sourceBytes2targetBytes(sourceSkipped);
        }

        public int available() throws IOException {
            return (int)this.sourceBytes2targetBytes(this.sourceStream.available());
        }

        public void mark(int readlimit) {
            this.sourceStream.mark((int)this.targetBytes2sourceBytes(readlimit));
        }

        public synchronized void reset() throws IOException {
            this.sourceStream.reset();
            this.flush();
        }

        public boolean markSupported() {
            return this.sourceStream.markSupported();
        }

        public void close() throws IOException {
            if (this.isClosed()) {
                return;
            }
            this.sourceStream.close();
            this.thisBuffer = null;
            this.historyBuffer = null;
            this.byteBuffer = null;
        }

        public boolean isClosed() {
            return this.thisBuffer == null;
        }

        public synchronized void flush() {
            if (!this.isClosed()) {
                this.thisBufferValid = false;
                this.historyBuffer.makeSilence();
            }
        }

        public synchronized void setTargetSampleRate(float sr) {
            if (sr > 0.0f) {
                this.targetSampleRate = sr;
                this.resizeBuffers();
            }
        }

        public synchronized void setConversionAlgorithm(int algo) {
            if ((algo == 1 || algo == 2) && algo != this.conversionAlgorithm) {
                this.conversionAlgorithm = algo;
                this.resizeBuffers();
            }
        }

        public synchronized float getTargetSampleRate() {
            return this.targetSampleRate;
        }

        public synchronized int getConversionAlgorithm() {
            return this.conversionAlgorithm;
        }
    }
}

