/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import org.tritonus.lowlevel.esd.EsdSample;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

public class EsdClip
extends TDataLine
implements Clip {
    private static final Class[] CONTROL_CLASSES = new Class[0];
    private static final int BUFFER_FRAMES = 16384;
    private Mixer m_mixer;
    private EsdSample m_esdSample;

    public EsdClip(TMixer mixer) {
        super(mixer, null);
        this.m_mixer = mixer;
        this.m_esdSample = new EsdSample();
    }

    public void open(AudioFormat audioFormat, byte[] abData, int nOffset, int nNumFrames) throws LineUnavailableException {
        int nBufferLength = nNumFrames * audioFormat.getFrameSize();
        ByteArrayInputStream bais = new ByteArrayInputStream(abData, nOffset, nBufferLength);
        try {
            AudioInputStream audioInputStream = new AudioInputStream(bais, audioFormat, nNumFrames);
            this.open(audioInputStream);
        }
        catch (IOException e) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(e);
            }
            throw new LineUnavailableException();
        }
    }

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        AudioFormat audioFormat = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, audioFormat, -1);
        this.setLineInfo(info);
        int nFrameSize = audioFormat.getFrameSize();
        long lTotalLength = audioInputStream.getFrameLength() * (long)nFrameSize;
        int nFormat = 0x1000 | EsdUtils.getEsdFormat(audioFormat);
        if (TDebug.TraceClip) {
            TDebug.out("format: " + nFormat);
            TDebug.out("sample rate: " + audioFormat.getSampleRate());
        }
        this.m_esdSample.open(nFormat, (int)audioFormat.getSampleRate(), (int)lTotalLength);
        if (TDebug.TraceClip) {
            TDebug.out("size in esd: " + audioInputStream.getFrameLength() * (long)nFrameSize);
        }
        int nBufferLength = 16384 * nFrameSize;
        byte[] abData = new byte[nBufferLength];
        int nBytesRead = 0;
        int nTotalBytes = 0;
        while (nBytesRead != -1) {
            block6: {
                try {
                    nBytesRead = audioInputStream.read(abData, 0, abData.length);
                }
                catch (IOException e) {
                    if (!TDebug.TraceClip && !TDebug.TraceAllExceptions) break block6;
                    TDebug.out(e);
                }
            }
            if (nBytesRead < 0) continue;
            nTotalBytes += nBytesRead;
            if (TDebug.TraceClip) {
                TDebug.out("EsdClip.open(): total bytes: " + nTotalBytes);
                TDebug.out("EsdClip.open(): Trying to write: " + nBytesRead);
            }
            int nBytesWritten = this.m_esdSample.write(abData, 0, nBytesRead);
            if (!TDebug.TraceClip) continue;
            TDebug.out("EsdClip.open(): Written: " + nBytesWritten);
        }
        this.open();
    }

    public int getFrameLength() {
        return -1;
    }

    public long getMicrosecondLength() {
        return -1L;
    }

    public void setFramePosition(int nPosition) {
    }

    public void setMicrosecondPosition(long lPosition) {
    }

    public int getFramePosition() {
        return -1;
    }

    public long getMicrosecondPosition() {
        return -1L;
    }

    public void setLoopPoints(int nStart, int nEnd) {
    }

    public void loop(int nCount) {
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.loop(int): called; count = " + nCount);
        }
        if (nCount == 0) {
            if (TDebug.TraceClip) {
                TDebug.out("EsdClip.loop(int): starting sample (once)");
            }
            this.m_esdSample.play();
        } else {
            if (TDebug.TraceClip) {
                TDebug.out("EsdClip.loop(int): starting sample (forever)");
            }
            this.m_esdSample.loop();
        }
    }

    public void flush() {
    }

    public void drain() {
    }

    public void close() {
        this.m_esdSample.free();
        this.m_esdSample.close();
    }

    public void open() {
    }

    public void start() {
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.start(): called");
        }
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.start(): calling 'loop(0)' [hack]");
        }
        this.loop(0);
    }

    public void stop() {
        this.m_esdSample.kill();
    }

    public int available() {
        return -1;
    }
}

