/*
 * Decompiled with CFR 0.152.
 */
package tigor.music.tags;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import tigor.music.tags.Tags;

public class MP3Tags
implements Tags {
    private int channels = -1;
    private String channelsMode;
    private String version;
    private int rate;
    private String layer;
    private int bitrate;
    private long total;
    private String path;
    private long size;
    private boolean vbr = false;
    private String artist;
    private String album;
    private String track;
    private String title;

    public void load(File file, AudioFileFormat format) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.path = file.getPath();
        this.loadInfo(format);
    }

    public boolean getVBR() {
        return this.vbr;
    }

    public int getChannels() {
        return this.channels;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLayer() {
        return this.layer;
    }

    public long getSize() {
        return this.size;
    }

    public String getPath() {
        return this.path;
    }

    public int getSamplingRate() {
        return this.rate;
    }

    public int getBitRate() {
        return this.bitrate;
    }

    public long getPlayTime() {
        return this.total;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getTrack() {
        return this.track;
    }

    public String getChannelsMode() {
        return this.channelsMode;
    }

    private void loadInfo(AudioFileFormat audiofileformat) throws UnsupportedAudioFileException {
        String string = audiofileformat.getType().toString();
        if (!string.equalsIgnoreCase("mp3")) {
            throw new UnsupportedAudioFileException("Not MP3 audio format!");
        }
        if (audiofileformat instanceof TAudioFileFormat) {
            Map<String, Object> map = ((TAudioFileFormat)audiofileformat).properties();
            if (map.containsKey("mp3.channels")) {
                this.channels = (Integer)map.get("mp3.channels");
            }
            if (map.containsKey("mp3.frequency.hz")) {
                this.rate = (Integer)map.get("mp3.frequency.hz");
            }
            if (map.containsKey("mp3.bitrate.nominal.bps")) {
                this.bitrate = (Integer)map.get("mp3.bitrate.nominal.bps");
            }
            if (map.containsKey("mp3.version.layer")) {
                this.layer = "Layer " + map.get("mp3.version.layer");
            }
            if (map.containsKey("mp3.version.mpeg")) {
                this.version = (String)map.get("mp3.version.mpeg");
                if (this.version.equals("1")) {
                    this.version = "MPEG1";
                } else if (this.version.equals("2")) {
                    this.version = "MPEG2-LSF";
                } else if (this.version.equals("2.5")) {
                    this.version = "MPEG2.5-LSF";
                }
            }
            if (map.containsKey("mp3.mode")) {
                int i = (Integer)map.get("mp3.mode");
                if (i == 0) {
                    this.channelsMode = "Stereo";
                } else if (i == 1) {
                    this.channelsMode = "Joint Stereo";
                } else if (i == 2) {
                    this.channelsMode = "Dual Channel";
                } else if (i == 3) {
                    this.channelsMode = "Single Channel";
                }
            }
            if (map.containsKey("mp3.vbr")) {
                this.vbr = (Boolean)map.get("mp3.vbr");
            }
            if (map.containsKey("title")) {
                this.title = (String)map.get("title");
            }
            if (map.containsKey("author")) {
                this.artist = (String)map.get("author");
            }
            if (map.containsKey("album")) {
                this.album = (String)map.get("album");
            }
            if (map.containsKey("duration")) {
                this.total = Math.round((Long)map.get("duration") / 1000000L);
            }
            if (map.containsKey("mp3.id3tag.track")) {
                this.track = (String)map.get("mp3.id3tag.track");
            }
        }
    }
}

