/*
 * Decompiled with CFR 0.152.
 */
package tigor.music.tags;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import tigor.music.tags.Tags;

public class OGGTags
implements Tags {
    private int channels = -1;
    private int version;
    private int rate;
    private int bitrate;
    private int maxbBtrate;
    private int minBitrate;
    private long total;
    private String path;
    private long size;
    private String artist;
    private String album;
    private String track;
    private String title;

    public void load(File file, AudioFileFormat format) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.path = file.getPath();
        this.loadInfo(format);
    }

    public int getChannels() {
        return this.channels;
    }

    public int getVersion() {
        return this.version;
    }

    public long getSize() {
        return this.size;
    }

    public String getPath() {
        return this.path;
    }

    public int getSamplingRate() {
        return this.rate;
    }

    public int getBitRate() {
        return this.bitrate;
    }

    public long getPlayTime() {
        return this.total;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getTrack() {
        return this.track;
    }

    public int getMaxBitrate() {
        return this.maxbBtrate;
    }

    public int getMinBitrate() {
        return this.minBitrate;
    }

    private void loadInfo(AudioFileFormat audiofileformat) throws UnsupportedAudioFileException {
        String string = audiofileformat.getType().toString();
        if (!string.equalsIgnoreCase("ogg")) {
            throw new UnsupportedAudioFileException("Not Ogg audio format!");
        }
        if (audiofileformat instanceof TAudioFileFormat) {
            Map<String, Object> map = ((TAudioFileFormat)audiofileformat).properties();
            if (map.containsKey("ogg.channels")) {
                this.channels = (Integer)map.get("ogg.channels");
            }
            if (map.containsKey("ogg.frequency.hz")) {
                this.rate = (Integer)map.get("ogg.frequency.hz");
            }
            if (map.containsKey("ogg.bitrate.nominal.bps")) {
                this.bitrate = (Integer)map.get("ogg.bitrate.nominal.bps");
            }
            if (map.containsKey("ogg.bitrate.max.bps")) {
                this.maxbBtrate = (Integer)map.get("ogg.bitrate.max.bps");
            }
            if (map.containsKey("ogg.bitrate.min.bps")) {
                this.minBitrate = (Integer)map.get("ogg.bitrate.min.bps");
            }
            if (map.containsKey("ogg.version")) {
                this.version = (Integer)map.get("ogg.version");
            }
            if (map.containsKey("title")) {
                this.title = (String)map.get("title");
            }
            if (map.containsKey("author")) {
                this.artist = (String)map.get("author");
            }
            if (map.containsKey("album")) {
                this.album = (String)map.get("album");
            }
            if (map.containsKey("duration")) {
                this.total = Math.round((Long)map.get("duration") / 1000000L);
            }
            if (map.containsKey("ogg.comment.track")) {
                this.track = (String)map.get("ogg.comment.track");
            }
        }
    }
}

