/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import tigor.srdmusicduplicates.common.PersistentPreferences;
import tigor.srdmusicduplicates.logic.DuplicateMover;
import tigor.srdmusicduplicates.logic.DuplicateScanner;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.logic.Root;
import tigor.srdmusicduplicates.logic.Session;
import tigor.srdmusicduplicates.logic.Strategy;
import tigor.srdmusicduplicates.logic.event.GroupChangeEvent;
import tigor.srdmusicduplicates.logic.event.ItemAddedToGroupEvent;
import tigor.srdmusicduplicates.logic.event.MoverEvent;
import tigor.srdmusicduplicates.logic.event.MoverEventListener;
import tigor.srdmusicduplicates.logic.event.ScannerEvent;
import tigor.srdmusicduplicates.logic.event.ScannerEventListener;
import tigor.srdmusicduplicates.logic.event.ScannerStatusEvent;
import tigor.srdmusicduplicates.logic.event.StatisticsEvent;
import tigor.srdmusicduplicates.ui.AboutDialog;
import tigor.srdmusicduplicates.ui.CheckPanel;
import tigor.srdmusicduplicates.ui.DuplicateMoverProgressMonitor;
import tigor.srdmusicduplicates.ui.DuplicatesTableCellRenderer;
import tigor.srdmusicduplicates.ui.DuplicatesTableModel;
import tigor.srdmusicduplicates.ui.HelpWindow;
import tigor.srdmusicduplicates.ui.ItemRow;
import tigor.srdmusicduplicates.ui.JComponentCellEditor;
import tigor.srdmusicduplicates.ui.RootsDialog;
import tigor.srdmusicduplicates.ui.Settings;
import tigor.srdmusicduplicates.ui.StrategyPanel;
import tigor.srdmusicduplicates.ui.TeaseDialog;
import tigor.srdmusicduplicates.ui.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private JFrame frame;
    private HelpWindow qaWindow;
    private HelpWindow rnWindow;
    private JPanel mainPanel;
    private JButton pauseResumeButton;
    private JButton startStopButton;
    private JButton clearButton;
    private JButton removeButton;
    private JButton rootsButton;
    private JButton strategyButton;
    private JButton checkButton;
    private JLabel numberOfDuplicatesLabel;
    private JPanel progressBarContainer;
    private JProgressBar progressBar;
    private DuplicatesTableModel model;
    private JTable table;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private DuplicateScanner scanner;
    private DuplicateMover mover;
    private File lastDir;
    private Session session;
    private PersistentPreferences preferences;
    private List<File> recentFiles;
    private JMenu recentFilesMenu;
    private JTextField scanDirectoryTextField;
    private File saveToFile;
    private JLabel descriptionLabel;
    private StrategyPanel strategyPanel;
    private CheckPanel checkPanel;
    private static final Log log = LogFactory.getLog(Application.class);
    private static final String CHANGE_DESTINATION_DIRECTORY_OPTION = "Change Destination Directory";
    private static final String YES_OPTION = "Yes";
    private static final String NO_OPTION = "No";
    private static final String OPEN_MENU = "Open Session...";
    private static final String SAVE_MENU = "Save Session";
    private static final String SAVE_AS_MENU = "Save Session As...";
    private static final String RECENT_MENU = "Recent Sessions";
    private static final int MAX_RECENT_FILE_SIE = 8;
    private static final String APP_TITLE = "Seek & Destroy Music Duplicates";
    private static final String RECENT_FILES_PROPERTY = "recent";
    private static final String MAINFRAME_SIZE_PROPERTY = "mainframe-size";
    private static final String TABLE_COLUMNS_PROPERTY = "table-columns";

    public static void main(String[] args) {
        DOMConfigurator.configure(Application.class.getResource("log4j.xml"));
        Application app = new Application();
        JFrame frame = new JFrame(APP_TITLE);
        app.setFrame(frame);
        frame.setContentPane(app.mainPanel);
        app.setup();
        frame.pack();
        app.setupFrame(frame);
        frame.setVisible(true);
    }

    public Application() {
        Strategy q;
        this.$$$setupUI$$$();
        this.session = new Session();
        this.preferences = new PersistentPreferences();
        Settings.Repository rep = Settings.Repository.readFromPreferences(this.preferences);
        if (rep != null) {
            rep.establishSettings();
        }
        if ((q = Strategy.readFromPreferneces(this.preferences)) != null) {
            DuplicateScanner.setStrategy(q);
        }
        this.updateDescription();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    private void setup() {
        this.setupLogic();
        this.setupUI();
    }

    private void setupUI() {
        this.startStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Application.this.scanner.isNotStartedOrIsStopScheduled()) {
                    Application.this.scanner.startRunning();
                } else {
                    Application.this.scanner.stopRunning();
                }
                Application.this.updateButtons();
            }
        });
        this.pauseResumeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Application.this.scanner.isRunning() && Application.this.scanner.isPauseScheduled()) {
                    Application.this.scanner.resumeRunning();
                } else {
                    Application.this.scanner.pauseRunning();
                }
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.this.scanner.reset();
                Application.this.model.clear();
                Application.this.updateButtons();
            }
        });
        this.rootsButton.addActionListener(new RootsButtonActionListener());
        this.removeButton.addActionListener(new RemoveButtonActionListener());
        this.strategyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Application.this.strategyPanel == null) {
                    Application.this.strategyPanel = new StrategyPanel(Application.this.preferences);
                    Application.this.strategyPanel.load();
                    Application.this.strategyPanel.addEventListener(new ApplyQualityActionListener());
                }
                Application.this.strategyPanel.show();
            }
        });
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Application.this.checkPanel == null) {
                    Application.this.checkPanel = new CheckPanel();
                    Application.this.checkPanel.addEventListener(new CheckPanel.CheckEventListener(){

                        public void applyCheckEvent(CheckPanel.CheckEvent e) {
                            if (Application.this.scanner.isRunning()) {
                                Application.this.scanner.stopRunning();
                            }
                            Application.this.table.getDefaultEditor(JComponent.class).stopCellEditing();
                            if (e.getType() == CheckPanel.CheckEvent.Type.recheckAll) {
                                Application.this.model.recheckRows();
                            } else if (e.getType() == CheckPanel.CheckEvent.Type.uncheckAll) {
                                Application.this.model.uncheckAllRows();
                            } else if (e.getType() == CheckPanel.CheckEvent.Type.uncheckProblems) {
                                Application.this.model.uncheckDeviantRows();
                            }
                        }
                    });
                }
                Application.this.checkPanel.show();
            }
        });
        this.progressBar = new JProgressBar();
        this.progressBarContainer.add(this.progressBar);
        this.progressBar.setStringPainted(true);
        this.numberOfDuplicatesLabel.setText("0");
        this.progressBar.setString("0/0");
        this.setupResultTable();
        this.setupMenus();
        this.updateButtons();
        this.updateMenus();
    }

    private void setupFrame(JFrame frame) {
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if ((Application.this.scanner.isDirty() || Application.this.mover.isDirty()) && !Application.this.exitApproval()) {
                    return;
                }
                Application.this.scanner.reset();
                Window win = e.getWindow();
                win.setVisible(false);
                win.dispose();
                System.exit(0);
            }
        });
        Dimension size = (Dimension)this.preferences.get(MAINFRAME_SIZE_PROPERTY);
        if (size != null) {
            frame.setPreferredSize(size);
            frame.setSize(size);
        }
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                Dimension size = c.getSize();
                Application.this.preferences.put(Application.MAINFRAME_SIZE_PROPERTY, size);
            }
        });
        Utilities.center(frame);
    }

    private void setupLogic() {
        this.scanner = new DuplicateScanner(new Root[0]);
        this.scanner.addEventListener(new MyScannerEventListener());
        this.mover = new DuplicateMover(null);
        this.mover.addEventListener(new MyMoverEventListener());
    }

    private void setupMenus() {
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem(OPEN_MENU);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser(Application.this.lastDir);
                fc.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().endsWith(Application.this.session.getFileType());
                    }

                    public String getDescription() {
                        return Application.this.session.getFileDesciption();
                    }
                });
                fc.addActionListener(new OpenSessionActionListener(fc));
                fc.showOpenDialog(Application.this.frame);
            }
        });
        menu.add(item);
        this.saveMenuItem = new JMenuItem(SAVE_MENU, 83);
        this.saveMenuItem.setMnemonic(83);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.this.saveAction();
            }
        });
        menu.add(this.saveMenuItem);
        this.saveAsMenuItem = new JMenuItem(SAVE_AS_MENU, 83);
        this.saveAsMenuItem.setMnemonic(83);
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.this.chooseFileAndSave(false);
            }
        });
        menu.add(this.saveAsMenuItem);
        this.recentFilesMenu = new JMenu(RECENT_MENU);
        try {
            this.recentFiles = (List)this.preferences.get(RECENT_FILES_PROPERTY);
        }
        catch (Exception e) {
            log.error(RECENT_FILES_PROPERTY, e);
            this.recentFiles = null;
        }
        if (this.recentFiles == null) {
            this.recentFiles = new ArrayList<File>();
        }
        this.setRecentFilesMenu(this.recentFilesMenu, this.recentFiles);
        menu.add(this.recentFilesMenu);
        menu.addSeparator();
        item = new JMenuItem("Export To XML...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.this.chooseFileAndSave(true);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Settings...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Settings settings = new Settings((Frame)Application.this.frame, "S&D: Settings", Application.this.preferences);
                int retValue = settings.run();
                if (retValue == 0 && settings.anyScannerPropertiesChanged()) {
                    Application.this.scanner.reset();
                    Application.this.model.clear();
                    Application.this.updateButtons();
                    Application.this.updateDescription();
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Exit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if ((Application.this.scanner.isDirty() || Application.this.mover.isDirty()) && !Application.this.exitApproval()) {
                    return;
                }
                Application.this.scanner.reset();
                Application.this.frame.setVisible(false);
                Application.this.frame.dispose();
                System.exit(0);
            }
        });
        menu.add(item);
        bar.add(menu);
        menu = new JMenu("Help");
        item = new JMenuItem("Q & A");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Application.this.qaWindow == null) {
                    Application.this.qaWindow = HelpWindow.createQAWindow();
                    Application.this.qaWindow.load();
                    Application.this.qaWindow.pack();
                    Utilities.center(Application.this.qaWindow);
                }
                Application.this.qaWindow.setVisible(true);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Release Notes");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Application.this.rnWindow == null) {
                    Application.this.rnWindow = HelpWindow.createRNWindow();
                    Application.this.rnWindow.load();
                    Application.this.rnWindow.pack();
                    Utilities.center(Application.this.rnWindow);
                }
                Application.this.rnWindow.setVisible(true);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("About");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.open(Application.this.frame);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Donate");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TeaseDialog.open(Application.this.frame, Application.this.preferences, Application.this.mover, false);
            }
        });
        menu.add(item);
        bar.add(menu);
        this.frame.setJMenuBar(bar);
    }

    private void saveAction() {
        if (this.saveToFile != null) {
            try {
                this.saveToFile.delete();
                this.save(this.saveToFile, false);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.frame, "Operation failed! Exception: " + ex.getMessage(), "Saving sessiont", 0);
                log.error("Can't save!", ex);
            }
            return;
        }
        this.chooseFileAndSave(false);
    }

    private void chooseFileAndSave(final boolean toXML) {
        JFileChooser fc = new JFileChooser(this.lastDir);
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(Application.this.session.getFileType(toXML));
            }

            public String getDescription() {
                return Application.this.session.getFileDesciption(toXML);
            }
        });
        fc.setSelectedFile(new File(this.scanner.getRootsTitle()));
        fc.addActionListener(new SaveSessionActionListener(fc, toXML));
        fc.showSaveDialog(this.frame);
    }

    private void updateRecentFiles(File f, boolean remove) {
        if (!this.recentFiles.contains(f) && !remove) {
            this.recentFiles.add(0, f);
            if (this.recentFiles.size() > 8) {
                this.recentFiles.remove(this.recentFiles.size() - 1);
            }
            this.setRecentFilesMenu(this.recentFilesMenu, this.recentFiles);
            this.preferences.put(RECENT_FILES_PROPERTY, this.recentFiles);
        } else if (this.recentFiles.contains(f) && remove) {
            this.recentFiles.remove(f);
            this.setRecentFilesMenu(this.recentFilesMenu, this.recentFiles);
            this.preferences.put(RECENT_FILES_PROPERTY, this.recentFiles);
        }
    }

    private void setRecentFilesMenu(JMenu menu, List<File> files) {
        this.recentFilesMenu.removeAll();
        for (File file : files) {
            JMenuItem recentItem = new JMenuItem(file.getPath());
            recentItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File file = new File(((JMenuItem)e.getSource()).getText());
                    if (!file.canRead()) {
                        return;
                    }
                    Application.this.open(file);
                }
            });
            menu.add(recentItem);
        }
        menu.addSeparator();
        JMenuItem clearRecentItem = new JMenuItem("Clear List");
        clearRecentItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.this.recentFiles.clear();
                Application.this.preferences.put(Application.RECENT_FILES_PROPERTY, Application.this.recentFiles);
                Application.this.setRecentFilesMenu(Application.this.recentFilesMenu, Application.this.recentFiles);
            }
        });
        menu.add(clearRecentItem);
        this.recentFilesMenu.validate();
    }

    private void setupResultTable() {
        this.table.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        this.table.setDefaultRenderer(JComponent.class, new DuplicatesTableCellRenderer());
        this.table.setDefaultRenderer(String.class, new DuplicatesTableCellRenderer());
        this.table.setSelectionMode(0);
        this.model = new DuplicatesTableModel();
        this.table.setModel(this.model);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Application.this.model.launchPlayer(Application.this.table.getSelectedRow());
                }
            }
        });
        this.table.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.this.model.launchFolderExplorer(Application.this.table.getSelectedRow());
            }
        }, KeyStroke.getKeyStroke(69, 0), 1);
        ItemRow.setLayout(this.table);
        this.readTableColumns(this.preferences);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
                Application.this.writeTableColumns(Application.this.preferences);
            }

            public void columnMarginChanged(ChangeEvent e) {
                Application.this.writeTableColumns(Application.this.preferences);
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private void writeTableColumns(PersistentPreferences preferences) {
        ArrayList<TableColumn> cols = new ArrayList<TableColumn>();
        Enumeration<TableColumn> e = this.table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn used = e.nextElement();
            TableColumn fresh = new TableColumn();
            fresh.setModelIndex(used.getModelIndex());
            fresh.setMinWidth(used.getMinWidth());
            fresh.setMaxWidth(used.getMaxWidth());
            fresh.setWidth(used.getWidth());
            fresh.setPreferredWidth(used.getPreferredWidth());
            fresh.setResizable(used.getResizable());
            fresh.setHeaderValue(used.getHeaderValue());
            fresh.setIdentifier(used.getIdentifier());
            cols.add(fresh);
        }
        preferences.put(TABLE_COLUMNS_PROPERTY, cols);
    }

    private void readTableColumns(PersistentPreferences preferences) {
        List columns = (List)preferences.get(TABLE_COLUMNS_PROPERTY);
        if (columns != null) {
            DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
            for (TableColumn col : columns) {
                columnModel.addColumn(col);
            }
            this.table.setColumnModel(columnModel);
        }
    }

    private void updateDescription() {
        this.descriptionLabel.setText("Match: " + Item.getCompareDescription());
        this.scanDirectoryTextField.setText(DuplicateScanner.getStrategy().getDescription());
    }

    private void updateButtons() {
        this.startStopButton.setText(this.scanner.isNotStartedOrIsStopScheduled() ? "Scan" : "Stop");
        this.startStopButton.setEnabled(this.scanner.getRoots().size() > 0);
        this.pauseResumeButton.setEnabled(this.scanner.isRunning());
        this.pauseResumeButton.setText(this.scanner.isPauseScheduled() ? "Resume" : "Pause");
        this.removeButton.setEnabled(this.scanner.hasDuplicates() && this.scanner.isNotStartedOrIsStopScheduled());
        this.clearButton.setEnabled(this.scanner.hasScanned() && !this.scanner.isRunning());
        this.rootsButton.setEnabled(this.scanner.isNotStartedOrIsStopScheduled());
    }

    private void updateMenus() {
        this.saveAsMenuItem.setEnabled(this.saveToFile != null);
    }

    private void updateTitle() {
        this.frame.setTitle(this.saveToFile != null ? "SRD: " + this.saveToFile.getPath() : APP_TITLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(File file) {
        boolean failed = false;
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.scanner.stopRunning();
            Session.Record r = this.session.deserializeFromFile(file);
            this.scanner.setFrom(r.getRoots(), r.getItems(), true);
            this.mover.setupFromMover(r.getMover());
            this.saveToFile = file;
        }
        catch (InvalidClassException ex) {
            log.error("file=" + file, ex);
            JOptionPane.showMessageDialog(this.frame, "Sorry, can't open session. File format has changed in new release and old file format is not compatible with the new one. (Solution: rescan the folders.)", "Opening session", 0);
            failed = true;
        }
        catch (Exception ex) {
            log.error("file=" + file, ex);
            JOptionPane.showMessageDialog(this.frame, "Operation failed! Exception: " + ex.getMessage(), "Opening session", 0);
            failed = true;
        }
        finally {
            this.frame.setCursor(Cursor.getDefaultCursor());
        }
        this.lastDir = file.getParentFile();
        this.updateRecentFiles(file, failed);
        this.updateMenus();
        this.updateTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File file, boolean toXML) throws IOException {
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.scanner.stopRunning();
            List<ItemRow> modified = this.model.collectRowsModifiedByUser();
            Session.Record r = new Session.Record(this.scanner.getRoots(), this.scanner.getItems(), this.mover, modified);
            this.session.serializeToFile(r, file, toXML);
            if (!toXML) {
                this.updateRecentFiles(file, false);
                this.saveToFile = file;
                this.updateMenus();
                this.updateTitle();
                this.scanner.clearDirty();
                this.mover.clearDirty();
            }
        }
        finally {
            this.frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean exitApproval() {
        int retValue = JOptionPane.showConfirmDialog(this.mainPanel, "Save session before exit?");
        switch (retValue) {
            case 2: {
                return false;
            }
            case 0: {
                this.saveAction();
                break;
            }
        }
        return true;
    }

    private void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel;
        JTextField jTextField;
        JTable jTable;
        JPanel jPanel;
        JLabel jLabel2;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 13, new Insets(2, 2, 1, 1), 2, 2, false, false));
        this.startStopButton = jButton7 = new JButton();
        jButton7.setText("Button");
        jPanel2.add((Component)jButton7, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.pauseResumeButton = jButton6 = new JButton();
        jButton6.setText("Button");
        jPanel2.add((Component)jButton6, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.clearButton = jButton5 = new JButton();
        jButton5.setText("Clear");
        jPanel2.add((Component)jButton5, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        this.rootsButton = jButton4 = new JButton();
        jButton4.setText("Roots");
        jPanel2.add((Component)jButton4, new GridConstraints(0, 3, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Duplicates:");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 8, 1, 1, 8, 0, 0, 0, null, null, null));
        this.numberOfDuplicatesLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 9, 1, 1, 8, 0, 0, 0, null, null, null));
        this.progressBarContainer = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 7, 1, 1, 0, 3, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 13, 0, 3, 7, 7, null, null, null));
        this.table = jTable = new JTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(800, 600));
        jTable.setShowHorizontalLines(true);
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jTable.setShowVerticalLines(true);
        jScrollPane.setViewportView(jTable);
        this.scanDirectoryTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setEnabled(true);
        jPanel2.add((Component)jTextField, new GridConstraints(2, 0, 1, 13, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 10, 1, 1, 0, 1, 3, 1, null, new Dimension(100, -1), null));
        this.descriptionLabel = jLabel = new JLabel();
        jLabel.setText(" Label");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 11, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 12, 1, 1, 0, 3, 0, 0, null, null, null));
        this.removeButton = jButton3 = new JButton();
        jButton3.setText("Remove");
        jPanel2.add((Component)jButton3, new GridConstraints(0, 4, 1, 1, 0, 1, 0, 0, null, null, null));
        this.strategyButton = jButton2 = new JButton();
        jButton2.setText("Strategy");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 5, 1, 1, 0, 1, 0, 0, null, null, null));
        this.checkButton = jButton = new JButton();
        jButton.setText("Check");
        jPanel2.add((Component)jButton, new GridConstraints(0, 6, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    private class RootsButtonActionListener
    implements ActionListener {
        private RootsButtonActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            RootsDialog dialog = new RootsDialog((Frame)Application.this.frame, "S&D: Manage Roots", Application.this.scanner.getRoots());
            int result = dialog.run();
            if (result == 0) {
                Application.this.frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Application.this.scanner.setRoots(dialog.getRoots());
                    Application.this.updateButtons();
                    if (dialog.anyChanges()) {
                        Application.this.saveToFile = null;
                        Application.this.updateMenus();
                        Application.this.updateTitle();
                    }
                }
                finally {
                    Application.this.frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class ApplyQualityActionListener
    implements StrategyPanel.ApplyQualityListener {
        private ApplyQualityActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyQuality(StrategyPanel.ApplyQualityEvent e) {
            Application.this.frame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (Application.this.scanner.isRunning()) {
                    Application.this.scanner.stopRunning();
                }
                Application.this.updateDescription();
                Application.this.scanner.validateContent();
            }
            finally {
                Application.this.frame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class RemoveButtonActionListener
    implements ActionListener {
        private RemoveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            while (true) {
                List<ItemRow> rows;
                if ((rows = Application.this.model.getCheckedRows()).size() == 0) {
                    JOptionPane.showMessageDialog(((JComponent)e.getSource()).getRootPane(), "Sorry, nothing to remove (all rows are unchecked).", "Removing canceled.", 1);
                    return;
                }
                if (!Application.this.mover.hasValidPath(Application.this.scanner.getRoots())) {
                    JFileChooser chooser = new JFileChooser(Application.this.lastDir);
                    chooser.setFileSelectionMode(1);
                    chooser.setDialogTitle("Choose destination directory where duplicates (checked rows) will be moved.");
                    int result = chooser.showDialog(((JComponent)e.getSource()).getRootPane(), "Choose");
                    if (result == 0) {
                        Application.this.mover.setDestinationDirectory(chooser.getSelectedFile());
                    } else {
                        return;
                    }
                }
                if (!Application.this.mover.hasValidPath(Application.this.scanner.getRoots())) {
                    JOptionPane.showMessageDialog(((JComponent)e.getSource()).getRootPane(), "Sorry! Choosen directory " + Application.this.mover.getDestinationDirectory() + " is inside the root directory. Choose directory outside 'Roots'!", "Prohibited input: directory inside root path.", 1);
                    continue;
                }
                Object[] options = new Object[]{Application.CHANGE_DESTINATION_DIRECTORY_OPTION, Application.YES_OPTION, Application.NO_OPTION};
                int choosen = JOptionPane.showOptionDialog(((JComponent)e.getSource()).getRootPane(), String.valueOf(rows.size()) + " duplicates will be moved to " + Application.this.mover.getDestinationDirectory() + ". Do you agree?", "Confirmation message", -1, 3, null, options, Application.YES_OPTION);
                if (choosen < 0) {
                    return;
                }
                if (Application.YES_OPTION.equals(options[choosen])) {
                    if (log.isDebugEnabled()) {
                        log.debug("Start (re)moving " + rows.size() + " files to " + Application.this.mover.getDestinationDirectory());
                    }
                    ArrayList<Item> items = new ArrayList<Item>();
                    for (ItemRow row : rows) {
                        items.add(row.getItem());
                    }
                    Application.this.mover.setItemsToMove(items);
                    DuplicateMoverProgressMonitor.run(Application.this.frame, Application.this.mover);
                    break;
                }
                if (!Application.CHANGE_DESTINATION_DIRECTORY_OPTION.equals(options[choosen])) break;
                Application.this.mover.setDestinationDirectory(null);
            }
        }
    }

    private class MyMoverEventListener
    implements MoverEventListener {
        private MyMoverEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moverEvent(MoverEvent e) {
            if (MoverEvent.Type.start.equals((Object)e.getType())) {
                Application.this.scanner.itemsWillRemove();
            } else if (e.getType().isTerminator()) {
                Application.this.frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Application.this.scanner.itemsDidRemove();
                    Application.this.mover.updateTotalMovedBytes(Application.this.preferences);
                    if (TeaseDialog.wantsTease(Application.this.preferences, Application.this.mover)) {
                        TeaseDialog.open(Application.this.frame, Application.this.preferences, Application.this.mover, true);
                    }
                }
                finally {
                    Application.this.frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class MyScannerEventListener
    implements ScannerEventListener {
        private MyScannerEventListener() {
        }

        public void scannerEvent(ScannerEvent e0) {
            if (e0 instanceof ItemAddedToGroupEvent) {
                ItemAddedToGroupEvent e = (ItemAddedToGroupEvent)e0;
                Application.this.table.getDefaultEditor(JComponent.class).stopCellEditing();
                Application.this.model.itemAddedToGroup(e.getGroup(), e.getItem());
            } else if (e0 instanceof StatisticsEvent) {
                StatisticsEvent e = (StatisticsEvent)e0;
                if (e.getScannerDirectory() != null) {
                    Application.this.scanDirectoryTextField.setText("Scanning: " + e.getScannerDirectory().getPath());
                } else {
                    Application.this.progressBar.setMaximum(e.getNumberOfFiles());
                    Application.this.progressBar.setValue(e.getNumberOfScannedFiles());
                    Application.this.numberOfDuplicatesLabel.setText(e.getNumberOfDuplicatesAsString());
                    Application.this.progressBar.setString(String.valueOf(e.getNumberOfScannedFiles()) + "/" + String.valueOf(e.getNumberOfFiles()));
                }
            } else if (e0 instanceof ScannerStatusEvent) {
                ScannerStatusEvent e = (ScannerStatusEvent)e0;
                if (ScannerStatusEvent.Status.set.equals((Object)e.getStatus())) {
                    Application.this.table.getDefaultEditor(JComponent.class).stopCellEditing();
                    Application.this.model.setDuplicates(Application.this.scanner.getDuplicates(), Application.this.model.collectRowsModifiedByUser());
                } else if (ScannerStatusEvent.Status.end.equals((Object)e.getStatus())) {
                    Application.this.updateDescription();
                }
                Application.this.updateButtons();
            } else if (e0 instanceof GroupChangeEvent) {
                GroupChangeEvent e = (GroupChangeEvent)e0;
                Application.this.table.getDefaultEditor(JComponent.class).stopCellEditing();
                Application.this.model.setDuplicates(e.getDuplicates(), Application.this.model.collectRowsModifiedByUser());
                Application.this.updateButtons();
            }
        }
    }

    class OpenSessionActionListener
    implements ActionListener {
        private final JFileChooser fc;

        public OpenSessionActionListener(JFileChooser fc) {
            this.fc = fc;
        }

        public void actionPerformed(ActionEvent e) {
            if (Application.this.scanner.isRunning()) {
                Application.this.scanner.stopRunning();
            }
            if ("ApproveSelection".equals(e.getActionCommand())) {
                File f = this.fc.getSelectedFile();
                Application.this.open(f);
            } else if ("CancelSelection".equals(e.getActionCommand())) {
                Application.this.lastDir = this.fc.getCurrentDirectory();
            }
        }
    }

    class SaveSessionActionListener
    implements ActionListener {
        private JFileChooser fc;
        private boolean toXML;

        public SaveSessionActionListener(JFileChooser fc, boolean toXML) {
            this.fc = fc;
            this.toXML = toXML;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (Application.this.scanner.isRunning()) {
                Application.this.scanner.stopRunning();
            }
            if ("ApproveSelection".equals(e.getActionCommand())) {
                File selection = Application.this.session.addFileExtension(this.fc.getSelectedFile(), this.toXML);
                if (selection != null) {
                    try {
                        if (selection.canRead()) {
                            int retValue = JOptionPane.showConfirmDialog(Application.this.frame, selection + " already exists. Do you want to replace it?", "Confirmation message", 0);
                            if (retValue == 0) {
                                if (!selection.delete()) {
                                    JOptionPane.showMessageDialog(Application.this.frame, "Operation failed! Can't delete " + selection, "Deleting existing file", 0);
                                    return;
                                }
                            } else {
                                return;
                            }
                        }
                        Application.this.save(selection, this.toXML);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(Application.this.frame, "Operation failed! Exception: " + ex.getMessage(), "Saving session", 0);
                    }
                    finally {
                        Application.this.lastDir = this.fc.getSelectedFile().getParentFile();
                    }
                }
            } else if ("CancelSelection".equals(e.getActionCommand())) {
                Application.this.lastDir = this.fc.getCurrentDirectory();
            }
        }
    }
}

