/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.launcher.BrowserLauncher;
import tigor.srdmusicduplicates.launcher.PlayerLauncher;

public class OSProcessLauncher {
    private String template;
    private static final Log log = LogFactory.getLog(PlayerLauncher.class);
    public static final long WAIT_ON_EXEC_MILLS = 5000L;
    public static final String FILE_TAG = "$FILE$";
    public static final String URI_TAG = "$URI$";
    public static final String URL_TAG = "$URL$";
    public static final String BROWSER_TAG = "browser";
    public static final String EXEC_TAG = "exec";

    public String getDefaultTemplate() {
        return "unknown";
    }

    public String getTemplate() {
        if (this.template == null) {
            this.template = this.getDefaultTemplate();
        }
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template != null ? template : this.getDefaultTemplate();
    }

    public int exec(final String path) {
        Thread executionThread = new Thread(){
            public int result;

            public void run() {
                if (path == null || !new File(path).canRead()) {
                    log.warn("Can't execute! Filepath=" + path);
                    return;
                }
                try {
                    String longCommand = OSProcessLauncher.this.parseCommand(path);
                    if (longCommand.toLowerCase().startsWith(OSProcessLauncher.BROWSER_TAG)) {
                        try {
                            String command = longCommand.substring(OSProcessLauncher.BROWSER_TAG.length()).trim();
                            BrowserLauncher.openURL(command);
                        }
                        catch (IOException e) {
                            log.error("command:" + longCommand, e);
                            return;
                        }
                        return;
                    }
                    String command = longCommand.toLowerCase().startsWith(OSProcessLauncher.EXEC_TAG) ? longCommand.substring(OSProcessLauncher.EXEC_TAG.length()).trim() : longCommand.trim();
                    Process proc = null;
                    Runtime rt = Runtime.getRuntime();
                    try {
                        String line;
                        if (log.isInfoEnabled()) {
                            log.info("executing command:" + command);
                        }
                        proc = rt.exec(command);
                        BufferedReader read = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        while ((line = read.readLine()) != null) {
                            if (!log.isInfoEnabled()) continue;
                            log.info(line);
                        }
                        read = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        while ((line = read.readLine()) != null) {
                            log.error(line);
                        }
                    }
                    catch (IOException e) {
                        log.error("command:" + command, e);
                        return;
                    }
                    if (log.isInfoEnabled()) {
                        log.info("done: " + longCommand);
                    }
                }
                catch (Exception e) {
                    log.error("exception raised in: " + OSProcessLauncher.this.template, e);
                }
            }
        };
        executionThread.start();
        try {
            executionThread.join(5000L);
        }
        catch (InterruptedException e) {
            if (log.isInfoEnabled()) {
                log.info("timeout for execution");
            }
            if (executionThread.isAlive()) {
                executionThread.interrupt();
            }
            return -1;
        }
        return 0;
    }

    private String parseCommand(String path) throws MalformedURLException {
        File f;
        String command = this.getTemplate();
        if (command.indexOf(FILE_TAG) >= 0) {
            command = command.replace(FILE_TAG, path);
        }
        if (command.indexOf(URI_TAG) >= 0) {
            f = new File(path);
            command = command.replace(URI_TAG, f.toURI().toString());
        }
        if (command.indexOf(URL_TAG) >= 0) {
            f = new File(path);
            command = command.replace(URL_TAG, f.toURL().toString());
        }
        return command;
    }
}

