/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.logic.ItemDescriptors;

public class DataDescriptors
extends ItemDescriptors {
    private long contentChecksum;
    public static final String[] SUPPORTED_FILE_TYPES = new String[]{"mp3", "ogg", "aac", "m4a", "wma"};
    public static String[] FileTypes = SUPPORTED_FILE_TYPES;
    private static final int CHECKSUM_SKIP_SIZE = 196608;
    private static final int CHECKSUM_CHUNK_SIZE = 262144;
    private static final CRC32 checksumComputer = new CRC32();
    private static byte[] CHECKSUM_CHUNK = new byte[262144];
    private static final Log log = LogFactory.getLog(DataDescriptors.class);

    public DataDescriptors(File file) {
        super(file);
    }

    public static void SetFileTypes(String[] types) {
        FileTypes = types;
    }

    public static String[] FileTypes() {
        return FileTypes;
    }

    public String[] getFileTypes() {
        return DataDescriptors.FileTypes();
    }

    public long getContentChecksum() {
        return this.contentChecksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataDescriptors descriptors = (DataDescriptors)o;
        return this.contentChecksum != -1L && this.contentChecksum == descriptors.contentChecksum;
    }

    public int hashCode() {
        return (int)(this.contentChecksum ^ this.contentChecksum >>> 32);
    }

    protected boolean setup(File file) {
        if (!super.setup(file)) {
            return false;
        }
        this.contentChecksum = -1L;
        try {
            this.contentChecksum = this.computeContentChecksum(file);
            return true;
        }
        catch (IOException e) {
            this.contentChecksum = -1L;
            log.error(file, e);
            return false;
        }
    }

    private long computeContentChecksum(File file) throws IOException {
        checksumComputer.reset();
        int len = this.getFileChunk(file);
        checksumComputer.update(CHECKSUM_CHUNK, 0, len);
        return checksumComputer.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFileChunk(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            long skipped;
            long fileLen = file.length();
            long skip = 196608L;
            int size = 262144;
            if (skip > fileLen - (long)size) {
                skip = fileLen - (long)size;
            }
            if (skip < 0L) {
                skip = 0L;
                size = (int)fileLen;
            }
            if (skip > 0L && skip != (skipped = fis.skip(skip))) {
                throw new IOException("Skipping: premature end of file. File=" + file);
            }
            int read = fis.read(CHECKSUM_CHUNK, 0, size);
            if (read != size) {
                throw new IOException("Premature end of file. File=" + file);
            }
            int n = size;
            return n;
        }
        finally {
            fis.close();
        }
    }
}

