/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.common.FileIntersection;
import tigor.srdmusicduplicates.common.PersistentPreferences;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.logic.Root;
import tigor.srdmusicduplicates.logic.event.MoverEvent;
import tigor.srdmusicduplicates.logic.event.MoverEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateMover
implements Serializable {
    private File destinationDirectory;
    private boolean dirty;
    private transient int numberOfMovedFiles;
    private transient Long totalMovedBytes;
    private transient Long totalMovedBytesMark;
    private transient long movedBytes;
    private transient Worker worker;
    private transient List<Item> items;
    private transient EventListenerList listenerList = new EventListenerList();
    private static final Log log = LogFactory.getLog(DuplicateMover.class);
    public static final String TOTAL_MOVED_BYTES_PROPERTY = "total-moved-bytes";
    public static final String TOTAL_MOVED_BYTES_MARK_PROPERTY = "total-moved-bytes-mark";

    public DuplicateMover(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public synchronized void incrementNumberOfMovedFiles(long movedBytes) {
        ++this.numberOfMovedFiles;
        this.movedBytes += movedBytes;
    }

    public synchronized long getMovedBytes() {
        return this.movedBytes;
    }

    public long getTotalMovedBytesMark(PersistentPreferences prefs) {
        if (this.totalMovedBytesMark == null) {
            this.totalMovedBytesMark = (Long)prefs.get(TOTAL_MOVED_BYTES_MARK_PROPERTY);
        }
        return this.totalMovedBytesMark != null ? this.totalMovedBytesMark : 0L;
    }

    public long getTotalMovedBytes(PersistentPreferences prefs) {
        if (this.totalMovedBytes == null) {
            this.totalMovedBytes = (Long)prefs.get(TOTAL_MOVED_BYTES_PROPERTY);
        }
        return this.totalMovedBytes != null ? this.totalMovedBytes : 0L;
    }

    public void updateTotalMovedBytesMark(PersistentPreferences prefs) {
        prefs.put(TOTAL_MOVED_BYTES_MARK_PROPERTY, new Long(this.getTotalMovedBytes(prefs)));
    }

    public void updateTotalMovedBytes(PersistentPreferences prefs) {
        this.totalMovedBytes = new Long(this.getMovedBytes() + this.getTotalMovedBytes(prefs));
        prefs.put(TOTAL_MOVED_BYTES_PROPERTY, this.totalMovedBytes);
    }

    public synchronized int getNumberOfMovedFiles() {
        return this.numberOfMovedFiles;
    }

    public int getNumberOfFiles() {
        return this.items.size();
    }

    public boolean isNotStartedOrIsStopScheduled() {
        return this.worker != null ? this.worker.isStopScheduled() : true;
    }

    public boolean isRunning() {
        return this.worker != null && !this.worker.isStopScheduled();
    }

    public void setItemsToMove(List<Item> items) {
        this.items = items;
    }

    public void startRunning() {
        this.worker = new Worker();
        this.numberOfMovedFiles = 0;
        this.movedBytes = 0L;
        this.worker.start();
    }

    public void stopRunning() {
        if (this.worker != null && !this.worker.isStopScheduled()) {
            try {
                if (log.isInfoEnabled()) {
                    log.info("thread " + Thread.currentThread() + " is stopping a worker thread...");
                }
                this.worker.setStopScheduled(true);
                this.worker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.worker = null;
            if (log.isInfoEnabled()) {
                log.info("... worker thread is stopped.");
            }
        }
    }

    public void addEventListener(MoverEventListener listener) {
        this.listenerList.add(MoverEventListener.class, listener);
    }

    public void removeEventListener(MoverEventListener listener) {
        this.listenerList.remove(MoverEventListener.class, listener);
    }

    public File getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void setDestinationDirectory(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
        this.setDirty();
    }

    public void setupFromMover(DuplicateMover mover) {
        this.destinationDirectory = mover.destinationDirectory;
        this.clearDirty();
    }

    public String toString() {
        return "DuplicateMover{destinationDirectory=" + this.destinationDirectory + '}';
    }

    public boolean hasValidPath(Collection<Root> rootDirectories) {
        if (this.destinationDirectory == null) {
            return false;
        }
        for (Root root : rootDirectories) {
            if (!FileIntersection.inTree(this.destinationDirectory, root)) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    private void setDirty() {
        this.dirty = true;
    }

    private void scheduleEvent(final MoverEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DuplicateMover.this.fireEvent(event);
            }
        });
    }

    private void fireEvent(MoverEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MoverEventListener.class) continue;
            ((MoverEventListener)listeners[i + 1]).moverEvent(event);
        }
    }

    public static class WorkerException
    extends Exception {
        public WorkerException() {
        }

        public WorkerException(String message) {
            super(message);
        }

        public WorkerException(String message, Throwable cause) {
            super(message, cause);
        }

        public WorkerException(Throwable cause) {
            super(cause);
        }
    }

    class Worker
    extends Thread {
        private boolean stopScheduled;
        private byte[] buffer = new byte[32768];
        public static final int COPY_FILE_BUFFER_SIZE = 32768;

        public void start() {
            this.stopScheduled = false;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Error {
            Exception exception = null;
            try {
                DuplicateMover.this.scheduleEvent(new MoverEvent((Object)this, MoverEvent.Type.start));
                for (Item item : DuplicateMover.this.items) {
                    Worker.sleep(20L);
                    if (this.isStopScheduled()) {
                        throw new InterruptedException("stop is scheduled");
                    }
                    boolean copy = false;
                    File toFile = this.renameFile(item);
                    if (toFile != null) {
                        if (log.isInfoEnabled()) {
                            log.info("moved: " + item.getFile() + ", to: " + toFile);
                        }
                    } else {
                        toFile = this.copyFile(item);
                        if (log.isInfoEnabled()) {
                            log.info("copied: " + item.getFile() + ", to: " + toFile);
                        }
                        copy = true;
                    }
                    if (copy) {
                        this.deleteFile(item);
                        if (log.isInfoEnabled()) {
                            log.info("deleted: " + item.getFile());
                        }
                    }
                    if (this.isStopScheduled()) {
                        throw new InterruptedException("stop is scheduled");
                    }
                    DuplicateMover.this.incrementNumberOfMovedFiles(toFile.length());
                    DuplicateMover.this.scheduleEvent(new MoverEvent(this, MoverEvent.Type.moved, item, toFile));
                }
            }
            catch (InterruptedException e) {
                DuplicateMover.this.worker = null;
                if (log.isInfoEnabled()) {
                    log.info("Moving interrupted.");
                }
                DuplicateMover.this.scheduleEvent(new MoverEvent((Object)this, MoverEvent.Type.interrupted));
                return;
            }
            catch (Throwable th) {
                log.error("Worker rasied: ", th);
                if (th instanceof Error) {
                    throw (Error)th;
                }
                if (th instanceof Exception) {
                    exception = (Exception)th;
                }
            }
            finally {
                DuplicateMover.this.worker = null;
            }
            if (exception != null) {
                DuplicateMover.this.scheduleEvent(new MoverEvent((Object)this, exception));
            } else {
                DuplicateMover.this.scheduleEvent(new MoverEvent((Object)this, MoverEvent.Type.end));
            }
        }

        private File renameFile(Item item) {
            File toFile = this.destinationFile(item);
            if (!item.getFile().renameTo(toFile)) {
                return null;
            }
            return toFile;
        }

        private File copyFile(Item item) throws IOException {
            File toFile = this.destinationFile(item);
            this.copyFile(item.getFile(), toFile);
            return toFile;
        }

        private void deleteFile(Item item) {
            if (!item.getFile().delete()) {
                log.warn("Can't delete: " + item.getFile());
            }
        }

        private File destinationFile(Item item) {
            File toFile;
            File toDir = new File(DuplicateMover.this.destinationDirectory, item.getRelativeDirectoryPath());
            toDir.mkdirs();
            String tag = "";
            while ((toFile = new File(toDir, tag + item.getFile().getName())).canRead()) {
                tag = tag + "_";
            }
            return toFile;
        }

        public synchronized boolean isStopScheduled() {
            return this.stopScheduled;
        }

        public synchronized void setStopScheduled(boolean b) {
            this.stopScheduled = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyFile(File src, File dst) throws IOException {
            FileInputStream in = new FileInputStream(src);
            try {
                FileOutputStream out = new FileOutputStream(dst);
                try {
                    int len;
                    while ((len = ((InputStream)in).read(this.buffer)) > 0) {
                        ((OutputStream)out).write(this.buffer, 0, len);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }
}

