/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.logic.Group;
import tigor.srdmusicduplicates.logic.Item;
import tigor.srdmusicduplicates.logic.PatternPlant;
import tigor.srdmusicduplicates.logic.Root;
import tigor.srdmusicduplicates.logic.Strategy;
import tigor.srdmusicduplicates.logic.event.GroupChangeEvent;
import tigor.srdmusicduplicates.logic.event.ItemAddedToGroupEvent;
import tigor.srdmusicduplicates.logic.event.ScannerEvent;
import tigor.srdmusicduplicates.logic.event.ScannerEventListener;
import tigor.srdmusicduplicates.logic.event.ScannerStatusEvent;
import tigor.srdmusicduplicates.logic.event.StatisticsEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateScanner {
    private List<Root> roots;
    private Map<Item, Group> duplicates;
    private Set<Item> items;
    private Set<File> scannedFiles;
    private int directoryCounter;
    private int numberOfFiles;
    private int numberOfScannedFiles;
    private int numberOfDuplicates;
    private long duplicateBytes;
    private int numberOInvalidID3Tags;
    private boolean validNumberOfFiles;
    private transient PatternPlant patternPlant;
    private transient Worker worker;
    private transient EventListenerList listenerList = new EventListenerList();
    private static final String[] fileTypes = Item.FileTypes();
    private static final int STATISTICS_INTERVAL = 5;
    private static final int INITIAL_CAPACITY = 1000;
    private boolean dirty;
    private static final Log log = LogFactory.getLog(DuplicateScanner.class);
    private static Strategy strategy = Strategy.defaultStrategy();

    public DuplicateScanner(Root[] fileRoots) {
        this.roots = Arrays.asList(fileRoots);
        this.patternPlant = new PatternPlant(1000);
        this.duplicates = new LinkedHashMap<Item, Group>(1000);
        this.scannedFiles = new HashSet<File>(1000);
        this.items = new LinkedHashSet<Item>(1000);
    }

    public void reset() {
        this.stopRunning();
        this.dirty = false;
        this.validNumberOfFiles = false;
        this.numberOfFiles = 0;
        this.directoryCounter = 0;
        this.numberOfScannedFiles = 0;
        this.numberOfDuplicates = 0;
        this.duplicateBytes = 0L;
        this.numberOInvalidID3Tags = 0;
        this.patternPlant.clear();
        this.duplicates.clear();
        this.scannedFiles.clear();
        this.items.clear();
        this.scheduleEvent(new StatisticsEvent(this, this.numberOfFiles, this.numberOfScannedFiles, this.numberOfDuplicates, this.duplicateBytes, this.numberOInvalidID3Tags));
    }

    public static Strategy getStrategy() {
        return strategy;
    }

    public static void setStrategy(Strategy strategy) {
        DuplicateScanner.strategy = strategy;
    }

    public String getRootsTitle() {
        if (this.roots.size() == 0) {
            return "session";
        }
        String title = "";
        for (Root root : this.roots) {
            title = title + (title.length() > 0 ? "_" : "");
            title = title + root.getName();
        }
        return title;
    }

    public void setFrom(List<Root> roots, Set<Item> items, boolean disableEvents) {
        this.roots = roots;
        this.setFrom(items, disableEvents);
    }

    public Set<Item> getItems() {
        return this.items;
    }

    public Set<Item> getCopyOfItems() {
        return new LinkedHashSet<Item>(this.items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFrom(Set<Item> source, boolean disableEvents) {
        boolean dirty = false;
        this.reset();
        for (Item item : source) {
            item.resetEquality();
            if (item.isValid()) {
                try {
                    if (item.getTagDescriptors() != null && !item.getTagDescriptors().isValid()) {
                        ++this.numberOInvalidID3Tags;
                    }
                    this.processItem(item, disableEvents);
                    this.scannedFiles.add(item.getFile());
                    this.items.add(item);
                    continue;
                }
                catch (Exception e) {
                    ++this.numberOInvalidID3Tags;
                    continue;
                }
                finally {
                    this.incrementNumberOfScannedFiles();
                    continue;
                }
            }
            dirty = true;
        }
        this.dirty = dirty;
        this.validNumberOfFiles = true;
        this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.set));
        this.scheduleEvent(new StatisticsEvent(this, this.numberOfFiles, this.numberOfScannedFiles, this.numberOfDuplicates, this.duplicateBytes, this.numberOInvalidID3Tags));
        return dirty;
    }

    public void joinWorker(long mills) {
        if (this.worker != null) {
            try {
                if (log.isInfoEnabled()) {
                    log.info("thread " + Thread.currentThread() + " is joining a worker thread...");
                }
                this.worker.join(mills);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void startRunning() {
        this.worker = new Worker();
        this.worker.start();
    }

    public void pauseRunning() {
        if (this.worker != null && !this.worker.isPauseScheduled() && !this.worker.isStopScheduled()) {
            if (log.isInfoEnabled()) {
                log.info("thread " + Thread.currentThread() + " is scheduling pause of a worker thread...");
            }
            this.worker.setPauseScheduled(true);
            if (log.isInfoEnabled()) {
                log.info("... worker thread pause is scheduled.");
            }
        }
    }

    public void resumeRunning() {
        if (this.worker != null && this.worker.isPauseScheduled()) {
            if (log.isInfoEnabled()) {
                log.info("thread " + Thread.currentThread() + " is resuming a worker thread...");
            }
            this.worker.setPauseScheduled(false);
            this.worker.interrupt();
            if (log.isInfoEnabled()) {
                log.info("... worker thread is resumed.");
            }
        }
    }

    public void stopRunning() {
        if (this.worker != null && !this.worker.isStopScheduled()) {
            block6: {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("thread " + Thread.currentThread() + " is stopping a worker thread...");
                    }
                    if (this.worker.isPauseScheduled()) {
                        this.worker.setPauseScheduled(false);
                        this.worker.interrupt();
                    }
                    this.worker.setStopScheduled(true);
                    this.worker.join();
                }
                catch (InterruptedException e) {
                    if (!log.isInfoEnabled()) break block6;
                    log.info("thread " + Thread.currentThread() + " is continue running...");
                }
            }
            this.worker = null;
            if (log.isInfoEnabled()) {
                log.info("... worker thread is stopped.");
            }
        }
    }

    public boolean isNotStartedOrIsStopScheduled() {
        return this.worker != null ? this.worker.isStopScheduled() : true;
    }

    public boolean isPauseScheduled() {
        return this.worker != null ? this.worker.isPauseScheduled() : false;
    }

    public boolean isRunning() {
        return this.worker != null && !this.worker.isStopScheduled();
    }

    public boolean hasScanned() {
        return this.scannedFiles.size() > 0;
    }

    public boolean hasDuplicates() {
        return this.duplicates.size() > 0;
    }

    public void addEventListener(ScannerEventListener listener) {
        this.listenerList.add(ScannerEventListener.class, listener);
    }

    public List<Root> getRoots() {
        return this.roots;
    }

    public void setRoots(List<Root> roots) {
        boolean anyLockDifferences = false;
        this.roots = roots;
        this.setDirty();
        for (Item item : this.items) {
            for (Root root : roots) {
                if (!item.getRoot().equlasPath(root)) continue;
                anyLockDifferences = item.setRoot(root) || anyLockDifferences;
            }
        }
        if (anyLockDifferences) {
            HashSet processed = new HashSet();
            for (Group group : this.duplicates.values()) {
                if (processed.contains(group)) continue;
                long diff = group.sortMembers();
                this.duplicateBytes -= diff;
            }
            this.dirty = true;
            this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.set));
            this.scheduleEvent(new StatisticsEvent(this, this.numberOfFiles, this.numberOfScannedFiles, this.numberOfDuplicates, this.duplicateBytes, this.numberOInvalidID3Tags));
        }
    }

    public Map<Item, Group> getDuplicates() {
        return this.duplicates;
    }

    public PatternPlant getPatternPlant() {
        return this.patternPlant;
    }

    public Set<File> getScannedFiles() {
        return this.scannedFiles;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public int getDirectoryCounter() {
        return this.directoryCounter;
    }

    public boolean shouldCountBeforeScan() {
        return !this.validNumberOfFiles || this.numberOfFiles <= 0;
    }

    public int getNumberOfScannedFiles() {
        return this.numberOfScannedFiles;
    }

    public int getNumberOfDuplicates() {
        return this.numberOfDuplicates;
    }

    public long getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public int getNumberOInvalidID3Tags() {
        return this.numberOInvalidID3Tags;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void itemsWillRemove() {
    }

    public void itemsDidRemove() {
        this.validateContent();
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void validateContent() {
        Set<Item> items = this.getCopyOfItems();
        boolean memDirty = this.dirty;
        this.setFrom(items, true);
        this.dirty = this.dirty || memDirty;
        this.scheduleEvent(new GroupChangeEvent(this, this.duplicates));
    }

    private Group findDuplicates(Item item) {
        return this.duplicates.get(item);
    }

    public void removeItem(File file) {
        Iterator<Item> pit = this.items.iterator();
        while (pit.hasNext()) {
            Item p = pit.next();
            if (!file.equals(p.getFile())) continue;
            pit.remove();
        }
        ArrayList<Item> remove = new ArrayList<Item>();
        for (Item item : this.duplicates.keySet()) {
            Group g = this.duplicates.get(item);
            Item m = g.getMember(file);
            if (m == null) continue;
            g.removeMember(m);
            --this.numberOfDuplicates;
            remove.add(m);
            if (g.anyDuplicates()) continue;
            remove.add(g.getBestItem());
        }
        for (Item item : remove) {
            this.duplicates.remove(item);
        }
    }

    private void processItem(Item item, boolean disableEvents) {
        Set<Item> patternItems;
        Item patternItem = null;
        if (Item.isCompareData() && DuplicateScanner.getStrategy().isCompareData() && item.getDataDescriptors() != null) {
            patternItem = this.patternPlant.match(item.getDataDescriptors());
            if (patternItem != null && patternItem != item) {
                this.setDuplicates(patternItem, item, disableEvents);
                item.setDataEquality(true);
                patternItem.setDataEquality(true);
                if (Item.isCompareTags() && DuplicateScanner.getStrategy().isCompareTags() && item.getTagDescriptors() != null) {
                    this.patternPlant.put(item.getTagDescriptors(), item);
                }
                return;
            }
            this.patternPlant.put(item.getDataDescriptors(), item);
        }
        if (Item.isCompareTags() && DuplicateScanner.getStrategy().isCompareTags() && item.getTagDescriptors() != null) {
            patternItems = this.patternPlant.match(item.getTagDescriptors(), DuplicateScanner.getStrategy(), true);
            Item item2 = patternItem = patternItems != null && patternItems.size() > 0 ? patternItems.iterator().next() : null;
            if (patternItem != null && patternItem != item) {
                this.setDuplicates(patternItem, item, disableEvents);
                item.setTagsEquality(true);
                patternItem.setTagsEquality(true);
                return;
            }
            this.patternPlant.put(item.getTagDescriptors(), item);
        }
        if (Item.isCompareSound() && DuplicateScanner.getStrategy().isCompareSound() && item.getSoundDescriptors() != null) {
            patternItems = this.patternPlant.match(item.getSoundDescriptors(), DuplicateScanner.getStrategy(), true);
            Item item3 = patternItem = patternItems != null && patternItems.size() > 0 ? patternItems.iterator().next() : null;
            if (patternItem != null && patternItem != item) {
                this.setDuplicates(patternItem, item, disableEvents);
                item.setSoundEquality(true);
                patternItem.setSoundEquality(true);
                return;
            }
            this.patternPlant.put(item.getSoundDescriptors(), item);
        }
    }

    private void setDuplicates(Item patternItem, Item item, boolean disableEvents) {
        Group group = this.findDuplicates(patternItem);
        if (group == null) {
            group = new Group(patternItem);
            this.duplicates.put(patternItem, group);
        }
        try {
            if (item != null) {
                long length = group.addMember(item);
                this.duplicates.put(item, group);
                ++this.numberOfDuplicates;
                this.duplicateBytes += length;
            }
            if (!disableEvents) {
                this.scheduleEvent(new ItemAddedToGroupEvent(this, group, item));
                this.scheduleEvent(new StatisticsEvent(this, this.numberOfFiles, this.numberOfScannedFiles, this.numberOfDuplicates, this.duplicateBytes, this.numberOInvalidID3Tags));
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void incrementNumberOfScannedFiles() {
        ++this.numberOfScannedFiles;
        if (this.numberOfScannedFiles > this.numberOfFiles) {
            this.numberOfFiles = this.numberOfScannedFiles;
        }
    }

    private void decrementNumberOfFiles() {
        if (this.numberOfFiles > 0) {
            --this.numberOfFiles;
        }
        if (this.numberOfScannedFiles > this.numberOfFiles) {
            this.numberOfScannedFiles = this.numberOfFiles;
        }
    }

    private void setDirty() {
        this.dirty = true;
    }

    private void scheduleEvent(final ScannerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DuplicateScanner.this.fireEvent(event);
            }
        });
    }

    private void fireEvent(ScannerEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ScannerEventListener.class) continue;
            ((ScannerEventListener)listeners[i + 1]).scannerEvent(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Worker
    extends Thread {
        boolean stopScheduled;
        boolean pauseScheduled;
        public static final int LONG_TIME_MILLIS = 1000000000;

        Worker() {
        }

        @Override
        public void start() {
            this.stopScheduled = false;
            this.pauseScheduled = false;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() throws Error {
            block18: {
                block17: {
                    block16: {
                        try {
                            try {
                                if (DuplicateScanner.this.shouldCountBeforeScan()) {
                                    DuplicateScanner.this.numberOfFiles = 0;
                                    if (log.isInfoEnabled()) {
                                        log.info("Counting started...");
                                    }
                                    StatisticsEvent.resetStopwatch();
                                    for (Root root : DuplicateScanner.this.roots) {
                                        this.count(root);
                                    }
                                    StatisticsEvent event = new StatisticsEvent(this, DuplicateScanner.this.numberOfFiles, DuplicateScanner.this.numberOfScannedFiles, DuplicateScanner.this.numberOfDuplicates, DuplicateScanner.this.duplicateBytes, DuplicateScanner.this.numberOInvalidID3Tags);
                                    DuplicateScanner.this.scheduleEvent(event);
                                    if (log.isInfoEnabled()) {
                                        log.info("Statistics: " + event);
                                        log.info("Counting ended.");
                                    }
                                }
                                if (this.stopScheduled) {
                                    Object var5_4 = null;
                                    break block16;
                                }
                                DuplicateScanner.this.validNumberOfFiles = true;
                                if (log.isInfoEnabled()) {
                                    log.info("Scanning started...");
                                }
                                HashSet<File> remainder = new HashSet<File>(DuplicateScanner.this.scannedFiles);
                                for (Root root : DuplicateScanner.this.roots) {
                                    if (log.isInfoEnabled()) {
                                        log.info("Scanning from: " + root);
                                    }
                                    this.scan(root, root, remainder);
                                }
                                if (this.stopScheduled) {
                                    break block17;
                                }
                                if (remainder.size() > 0 && this.removeItemsIfInvalid(remainder)) {
                                    DuplicateScanner.this.setDirty();
                                    DuplicateScanner.this.scheduleEvent(new GroupChangeEvent(this, DuplicateScanner.this.duplicates));
                                }
                                break block18;
                            }
                            catch (Throwable th) {
                                log.error("Worker aborted by: ", th);
                                if (th instanceof Error) {
                                    throw (Error)th;
                                }
                                Object var5_7 = null;
                                DuplicateScanner.this.worker = null;
                                StatisticsEvent event = new StatisticsEvent(this, DuplicateScanner.this.numberOfFiles, DuplicateScanner.this.numberOfScannedFiles, DuplicateScanner.this.numberOfDuplicates, DuplicateScanner.this.duplicateBytes, DuplicateScanner.this.numberOInvalidID3Tags);
                                DuplicateScanner.this.scheduleEvent(event);
                                DuplicateScanner.this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.end));
                                if (!log.isInfoEnabled()) return;
                                log.info("Statistics: " + event);
                                log.info("Scanning ended.");
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            DuplicateScanner.this.worker = null;
                            StatisticsEvent event = new StatisticsEvent(this, DuplicateScanner.this.numberOfFiles, DuplicateScanner.this.numberOfScannedFiles, DuplicateScanner.this.numberOfDuplicates, DuplicateScanner.this.duplicateBytes, DuplicateScanner.this.numberOInvalidID3Tags);
                            DuplicateScanner.this.scheduleEvent(event);
                            DuplicateScanner.this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.end));
                            if (!log.isInfoEnabled()) throw throwable;
                            log.info("Statistics: " + event);
                            log.info("Scanning ended.");
                            throw throwable;
                        }
                    }
                    DuplicateScanner.this.worker = null;
                    StatisticsEvent event = new StatisticsEvent(this, DuplicateScanner.this.numberOfFiles, DuplicateScanner.this.numberOfScannedFiles, DuplicateScanner.this.numberOfDuplicates, DuplicateScanner.this.duplicateBytes, DuplicateScanner.this.numberOInvalidID3Tags);
                    DuplicateScanner.this.scheduleEvent(event);
                    DuplicateScanner.this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.end));
                    if (!log.isInfoEnabled()) return;
                    log.info("Statistics: " + event);
                    log.info("Scanning ended.");
                    return;
                }
                Object var5_5 = null;
                DuplicateScanner.this.worker = null;
                StatisticsEvent event = new StatisticsEvent(this, DuplicateScanner.this.numberOfFiles, DuplicateScanner.this.numberOfScannedFiles, DuplicateScanner.this.numberOfDuplicates, DuplicateScanner.this.duplicateBytes, DuplicateScanner.this.numberOInvalidID3Tags);
                DuplicateScanner.this.scheduleEvent(event);
                DuplicateScanner.this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.end));
                if (!log.isInfoEnabled()) return;
                log.info("Statistics: " + event);
                log.info("Scanning ended.");
                return;
            }
            Object var5_6 = null;
            DuplicateScanner.this.worker = null;
            StatisticsEvent event = new StatisticsEvent(this, DuplicateScanner.this.numberOfFiles, DuplicateScanner.this.numberOfScannedFiles, DuplicateScanner.this.numberOfDuplicates, DuplicateScanner.this.duplicateBytes, DuplicateScanner.this.numberOInvalidID3Tags);
            DuplicateScanner.this.scheduleEvent(event);
            DuplicateScanner.this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.end));
            if (!log.isInfoEnabled()) return;
            log.info("Statistics: " + event);
            log.info("Scanning ended.");
        }

        private void count(File dir) {
            if (this.pauseScheduled) {
                this.pause();
            }
            if (this.stopScheduled) {
                return;
            }
            if (DuplicateScanner.this.directoryCounter % 5 == 0) {
                DuplicateScanner.this.scheduleEvent(new StatisticsEvent(this, dir));
            }
            DuplicateScanner.this.directoryCounter++;
            File[] content = dir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String n = file.getName().toLowerCase();
                    for (String type : fileTypes) {
                        if (!n.endsWith("." + type)) continue;
                        return true;
                    }
                    return false;
                }
            });
            if (content == null) {
                return;
            }
            for (File file : content) {
                if (this.pauseScheduled) {
                    this.pause();
                }
                if (this.stopScheduled) break;
                if (file.isDirectory()) {
                    this.count(file);
                    continue;
                }
                if (!Item.accepts(file)) continue;
                if (DuplicateScanner.this.numberOfFiles % 100 == 0) {
                    StatisticsEvent e = new StatisticsEvent(this, DuplicateScanner.this.numberOfFiles, DuplicateScanner.this.numberOfScannedFiles, DuplicateScanner.this.numberOfDuplicates, DuplicateScanner.this.duplicateBytes, DuplicateScanner.this.numberOInvalidID3Tags);
                    DuplicateScanner.this.scheduleEvent(e);
                }
                DuplicateScanner.this.numberOfFiles++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scan(File dir, Root root, Set<File> remainder) {
            if (this.pauseScheduled) {
                this.pause();
            }
            if (this.stopScheduled) {
                return;
            }
            if (DuplicateScanner.this.directoryCounter % 5 == 0) {
                DuplicateScanner.this.scheduleEvent(new StatisticsEvent(this, dir));
            }
            DuplicateScanner.this.directoryCounter++;
            File[] content = dir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String n = file.getName().toLowerCase();
                    for (String type : fileTypes) {
                        if (!n.endsWith("." + type)) continue;
                        return true;
                    }
                    return false;
                }
            });
            if (content == null) {
                return;
            }
            for (File file : content) {
                if (this.pauseScheduled) {
                    this.pause();
                }
                if (this.stopScheduled) break;
                if (file.isDirectory()) {
                    this.scan(file, root, remainder);
                    continue;
                }
                if (Item.accepts(file)) {
                    remainder.remove(file);
                    if (this.alreadyScanned(file)) continue;
                    try {
                        Item item = new Item(file, root);
                        if (item.getTagDescriptors() != null && !item.getTagDescriptors().isValid()) {
                            DuplicateScanner.this.numberOInvalidID3Tags++;
                        }
                        if (DuplicateScanner.this.numberOfScannedFiles % 5 == 0) {
                            StatisticsEvent e = new StatisticsEvent(this, DuplicateScanner.this.numberOfFiles, DuplicateScanner.this.numberOfScannedFiles, DuplicateScanner.this.numberOfDuplicates, DuplicateScanner.this.duplicateBytes, DuplicateScanner.this.numberOInvalidID3Tags);
                            DuplicateScanner.this.scheduleEvent(e);
                        }
                        DuplicateScanner.this.processItem(item, false);
                        DuplicateScanner.this.scannedFiles.add(file);
                        DuplicateScanner.this.items.add(item);
                        DuplicateScanner.this.setDirty();
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Can't initialize item for file:" + file, e);
                        DuplicateScanner.this.numberOInvalidID3Tags++;
                        continue;
                    }
                    finally {
                        DuplicateScanner.this.incrementNumberOfScannedFiles();
                    }
                }
                if (!log.isInfoEnabled()) continue;
                log.info("... skipping insufficient file: " + file);
            }
        }

        private boolean removeItemsIfInvalid(Set<File> files) {
            boolean anyRemoved = false;
            for (File file : files) {
                if (file.canRead() || !DuplicateScanner.this.scannedFiles.remove(file)) continue;
                DuplicateScanner.this.removeItem(file);
                anyRemoved = true;
                DuplicateScanner.this.decrementNumberOfFiles();
                if (!log.isDebugEnabled()) continue;
                log.debug("removed file:  " + file);
            }
            return anyRemoved;
        }

        private boolean alreadyScanned(File file) {
            return DuplicateScanner.this.scannedFiles.contains(file);
        }

        private void pause() {
            try {
                DuplicateScanner.this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.sleep));
                Worker.sleep(1000000000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DuplicateScanner.this.scheduleEvent(new ScannerStatusEvent(this, ScannerStatusEvent.Status.recure));
        }

        private synchronized void setPauseScheduled(boolean pauseScheduled) {
            this.pauseScheduled = pauseScheduled;
        }

        private synchronized void setStopScheduled(boolean stopScheduled) {
            this.stopScheduled = stopScheduled;
        }

        private synchronized boolean isStopScheduled() {
            return this.stopScheduled;
        }

        private synchronized boolean isPauseScheduled() {
            return this.pauseScheduled;
        }
    }
}

