/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.logic.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    private transient ReentrantReadWriteLock lock;
    private List<Item> members = new ArrayList<Item>(5);
    private Set<Item> setOfMembers = new HashSet<Item>(5);
    private transient int sequenceNumber;
    private static int nextSequenceNumber;
    private static final Log log;
    private static final long MAX_PLAYING_TIME_DIFFERENCE = 5L;
    public static final int LOCK_TIMEOUT_IN_SECONDS = 60;

    public Group(Item item) {
        this.members.add(item);
        this.setOfMembers.add(item);
    }

    public static void resetSequenceNumberGenerator() {
        nextSequenceNumber = 0;
    }

    public void setNextSequenceNumber() {
        this.sequenceNumber = nextSequenceNumber++;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ReentrantReadWriteLock getLock() {
        if (this.lock == null) {
            this.lock = new ReentrantReadWriteLock();
        }
        return this.lock;
    }

    public long duplicateBytes() {
        long bytes = 0L;
        if (this.members.size() > 1) {
            for (int i = 1; i < this.members.size(); ++i) {
                Item item = this.members.get(i);
                bytes += item.getContentLength();
            }
        }
        return bytes;
    }

    public boolean isEmpty() {
        return this.members.size() == 0;
    }

    public boolean anyDuplicates() {
        return this.members.size() > 1;
    }

    public List<Item> getMembers() {
        return this.members;
    }

    public Set<Item> getSetOfMembers() {
        return this.setOfMembers;
    }

    public void setMembers(List<Item> members) {
        this.members = members;
        this.setOfMembers.clear();
        this.setOfMembers.addAll(members);
    }

    public Item getBestItem() {
        return this.members.size() > 0 ? this.members.get(0) : null;
    }

    public boolean hasMember(Item item) {
        return this.setOfMembers.contains(item);
    }

    public Item getMember(File file) {
        for (Item m : this.members) {
            if (!file.equals(m.getFile())) continue;
            return m;
        }
        return null;
    }

    public Collection<Item> validateMemberFiles(boolean removeInvalid) {
        ArrayList<Item> invalid = new ArrayList<Item>();
        for (Item item : this.members) {
            if (item.isValid()) continue;
            invalid.add(item);
        }
        if (removeInvalid && invalid.size() > 0) {
            this.members.removeAll(invalid);
            if (this.anyDuplicates()) {
                this.sortMembers();
            }
        }
        return invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Item m) {
        try {
            this.acquireWriteLock();
            try {
                this.members.remove(m);
                this.setOfMembers.remove(m);
                if (this.anyDuplicates()) {
                    this.sortMembers();
                }
            }
            finally {
                this.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not acquire write-lock to update duplicateds: " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addMember(Item item) {
        this.acquireWriteLock();
        try {
            this.members.add(item);
            this.setOfMembers.add(item);
            long diffLen = this.sortMembers();
            if (log.isDebugEnabled()) {
                this.printMembers();
            }
            long l = item.getContentLength() - diffLen;
            this.releaseWriteLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.releaseWriteLock();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Could not acquire write-lock to update duplicateds: " + this);
            }
        }
    }

    public long sortMembers() {
        long lastBestItemLen = this.getBestItem().getContentLength();
        Collections.sort(this.members, new Comparator(){

            public int compare(Object o1, Object o2) {
                Item i1 = (Item)o1;
                Item i2 = (Item)o2;
                return i1.compareQuality(i2);
            }
        });
        long newBestItemLen = this.getBestItem().getContentLength();
        return newBestItemLen - lastBestItemLen;
    }

    public void printMembers() {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("Duplicate members:");
        for (Item item : this.members) {
            log.debug("-------------------------------");
            log.debug("data descriptors");
            log.debug("... " + item.getDataDescriptors());
            log.debug("tag descriptors");
            log.debug("... " + item.getTagDescriptors());
            log.debug("sound descriptors");
            log.debug("... " + item.getSoundDescriptors());
            log.debug("-------------------------------");
        }
    }

    public boolean isDuplicate(Item item) {
        return !item.equals(this.getBestItem());
    }

    public void acquireReadLock() throws InterruptedException {
        if (!this.getLock().readLock().tryLock(60L, TimeUnit.SECONDS)) {
            throw new InterruptedException("read-lock timeout");
        }
    }

    public void releaseReadLock() {
        this.getLock().readLock().unlock();
    }

    public void acquireWriteLock() throws InterruptedException {
        if (!this.getLock().writeLock().tryLock(60L, TimeUnit.SECONDS)) {
            throw new InterruptedException("write-lock timeout");
        }
    }

    public void releaseWriteLock() {
        this.getLock().writeLock().unlock();
    }

    public int size() {
        return this.members.size();
    }

    public boolean hasDeviantPlayingTime() {
        long minPlayingTime = 1000000L;
        long maxPlayinTime = -1L;
        for (Item item : this.members) {
            long time = item.getPlayingTime();
            if (time > maxPlayinTime) {
                maxPlayinTime = time;
            }
            if (time >= minPlayingTime) continue;
            minPlayingTime = time;
        }
        return maxPlayinTime - minPlayingTime > 5L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        return ((Object)this.members).equals(group.members);
    }

    public int hashCode() {
        int result = ((Object)this.members).hashCode();
        return result;
    }

    static {
        log = LogFactory.getLog(Group.class);
    }
}

