/*
 * Decompiled with CFR 0.152.
 */
package tigor.srdmusicduplicates.logic;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tigor.srdmusicduplicates.logic.DataDescriptors;
import tigor.srdmusicduplicates.logic.DuplicateScanner;
import tigor.srdmusicduplicates.logic.ItemDescriptors;
import tigor.srdmusicduplicates.logic.Root;
import tigor.srdmusicduplicates.logic.SoundDescriptors;
import tigor.srdmusicduplicates.logic.TagDescriptors;

public class Item
implements Serializable {
    private File file;
    private Root root;
    private DataDescriptors dataDescriptors;
    private TagDescriptors tagDescriptors;
    private SoundDescriptors soundDescriptors;
    private String fileName;
    private String dirPath;
    private long contentLength;
    private boolean dataEquality;
    private boolean tagsEquality;
    private boolean soundEquality;
    public static final long MIN_FILE_LENGTH = 32768L;
    public static final boolean COMPARE_DATA_DEFAUT = true;
    public static final boolean COMPARE_TAGS_DEFAUT = true;
    public static final boolean COMPARE_SOUND_DEFAUT = false;
    private static String[] FileTypes = null;
    private static boolean CompareData = true;
    private static boolean CompareTags = true;
    private static boolean CompareSound = false;
    private static final Log log = LogFactory.getLog(Item.class);

    public Item(File file, Root root) {
        this.file = file;
        this.root = root;
        this.fileName = file.getName();
        this.contentLength = file.length();
        this.dirPath = file.getParentFile().getPath();
        if (CompareData) {
            this.dataDescriptors = new DataDescriptors(file);
            if (this.dataDescriptors.isNotSupported()) {
                this.dataDescriptors = null;
            } else if (log.isDebugEnabled()) {
                log.debug(this.dataDescriptors);
            }
        }
        if (CompareTags) {
            this.tagDescriptors = new TagDescriptors(file);
            if (this.tagDescriptors.isNotSupported()) {
                this.tagDescriptors = null;
            } else if (log.isDebugEnabled()) {
                log.debug(this.tagDescriptors);
            }
        }
        if (CompareSound) {
            this.soundDescriptors = new SoundDescriptors(file);
            if (this.soundDescriptors.isNotSupported()) {
                this.soundDescriptors = null;
            } else if (log.isDebugEnabled()) {
                log.debug(this.soundDescriptors);
            }
        }
    }

    public static void ClearFileTypes() {
        FileTypes = null;
    }

    public static String[] FileTypes() {
        if (FileTypes == null) {
            String[] array;
            ArrayList<String> types = new ArrayList<String>();
            for (String type : array = DataDescriptors.FileTypes()) {
                if (type.length() <= 0 || types.contains(type)) continue;
                types.add(type);
            }
            for (String type : array = TagDescriptors.FileTypes()) {
                if (type.length() <= 0 || types.contains(type)) continue;
                types.add(type);
            }
            for (String type : array = SoundDescriptors.FileTypes()) {
                if (type.length() <= 0 || types.contains(type)) continue;
                types.add(type);
            }
            FileTypes = new String[types.size()];
            for (int i = 0; i < types.size(); ++i) {
                Item.FileTypes[i] = (String)types.get(i);
            }
        }
        return FileTypes;
    }

    public String getType() {
        if (this.dataDescriptors != null) {
            return this.dataDescriptors.getType();
        }
        if (this.tagDescriptors != null) {
            return this.tagDescriptors.getType();
        }
        if (this.soundDescriptors != null) {
            return this.soundDescriptors.getType();
        }
        return "?";
    }

    public boolean setRoot(Root newRoot) {
        boolean lockChange;
        boolean bl = this.root != null ? this.root.isLocked() != newRoot.isLocked() : (lockChange = true);
        if (this.root != null && !this.root.equlasPath(newRoot)) {
            throw new IllegalArgumentException("Can't set to root with the different path. existed=" + this.root + ", new=" + newRoot);
        }
        this.root = newRoot;
        return lockChange;
    }

    public DataDescriptors getDataDescriptors() {
        return this.dataDescriptors;
    }

    public TagDescriptors getTagDescriptors() {
        return this.tagDescriptors;
    }

    public SoundDescriptors getSoundDescriptors() {
        return this.soundDescriptors;
    }

    public static boolean accepts(File file) {
        return file.canRead() && file.length() >= 32768L;
    }

    public File getFile() {
        return this.file;
    }

    public Root getRoot() {
        return this.root;
    }

    public boolean isValid() {
        return this.getFile().canRead();
    }

    public String getRelativeDirectoryPath() {
        return this.dirPath.substring(this.root.getPath().length());
    }

    public static boolean isCompareData() {
        return CompareData;
    }

    public static void setCompareData(boolean compareData) {
        CompareData = compareData;
    }

    public static boolean isCompareTags() {
        return CompareTags;
    }

    public static void setCompareTags(boolean compareTags) {
        CompareTags = compareTags;
    }

    public static boolean isCompareSound() {
        return CompareSound;
    }

    public static void setCompareSound(boolean compareSound) {
        CompareSound = compareSound;
    }

    public boolean isDataEquality() {
        return this.dataEquality;
    }

    public void setDataEquality(boolean dataEquality) {
        this.dataEquality = dataEquality;
    }

    public boolean isTagsEquality() {
        return this.tagsEquality;
    }

    public void setTagsEquality(boolean tagsEquality) {
        this.tagsEquality = tagsEquality;
    }

    public boolean isSoundEquality() {
        return this.soundEquality;
    }

    public void setSoundEquality(boolean soundEquality) {
        this.soundEquality = soundEquality;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public boolean isFileLocked() {
        return this.root.isLocked();
    }

    public void resetEquality() {
        this.dataEquality = false;
        this.tagsEquality = false;
        this.soundEquality = false;
    }

    public String getEquality() {
        String eq = "";
        if (this.dataEquality) {
            eq = eq + "D";
        }
        if (this.tagsEquality) {
            eq = eq + "T";
        }
        if (this.soundEquality) {
            eq = eq + "S";
        }
        return eq;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getPlayingTime() {
        return this.tagDescriptors != null ? this.tagDescriptors.getPlayTime() : -1L;
    }

    public String toString() {
        return "Item{file=" + this.file + ", root=" + this.root + ", dataDescriptors=" + this.dataDescriptors + ", tagDescriptors=" + this.tagDescriptors + ", soundDescriptors=" + this.soundDescriptors + ", fileName='" + this.fileName + '\'' + ", dirPath='" + this.dirPath + '\'' + ", contentLength=" + this.contentLength + ", dataEquality=" + this.dataEquality + ", tagsEquality=" + this.tagsEquality + ", soundEquality=" + this.soundEquality + '}';
    }

    public int compareQuality(Item t2) {
        return DuplicateScanner.getStrategy().compareItems(this, t2);
    }

    public static String getCompareDescription() {
        String desc = "";
        String delimiter = "";
        if ((desc = desc + (CompareData ? "D(" + ItemDescriptors.fileTypesAsString(DataDescriptors.FileTypes()) + ")" : "")).length() > 0) {
            delimiter = ", ";
        }
        if ((desc = desc + (CompareTags ? delimiter + "T(" + ItemDescriptors.fileTypesAsString(TagDescriptors.FileTypes()) + ")" : "")).length() > 0) {
            delimiter = ", ";
        }
        desc = desc + (CompareSound ? delimiter + "S(" + ItemDescriptors.fileTypesAsString(SoundDescriptors.FileTypes()) + ")" : "");
        return desc;
    }
}

